/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.comparator;

import cn.hutool.core.util.StrUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WindowsExplorerStringComparator
implements Comparator<CharSequence> {
    public static final WindowsExplorerStringComparator INSTANCE = new WindowsExplorerStringComparator();
    private static final Pattern splitPattern = Pattern.compile("\\d+|\\.|\\s");

    @Override
    public int compare(CharSequence str1, CharSequence str2) {
        int result;
        Iterator<String> i1 = this.splitStringPreserveDelimiter(str1).iterator();
        Iterator<String> i2 = this.splitStringPreserveDelimiter(str2).iterator();
        do {
            if (!i1.hasNext() && !i2.hasNext()) {
                return 0;
            }
            if (!i1.hasNext()) {
                return -1;
            }
            if (!i2.hasNext()) {
                return 1;
            }
            String data1 = i1.next();
            String data2 = i2.next();
            try {
                result = Long.compare(Long.parseLong(data1), Long.parseLong(data2));
                if (result != 0) continue;
                result = -Integer.compare(data1.length(), data2.length());
            }
            catch (NumberFormatException ex) {
                result = data1.compareToIgnoreCase(data2);
            }
        } while (result == 0);
        return result;
    }

    private List<String> splitStringPreserveDelimiter(CharSequence str) {
        Matcher matcher = splitPattern.matcher(str);
        ArrayList<String> list = new ArrayList<String>();
        int pos = 0;
        while (matcher.find()) {
            list.add(StrUtil.sub(str, pos, matcher.start()));
            list.add(matcher.group());
            pos = matcher.end();
        }
        list.add(StrUtil.subSuf(str, pos));
        return list;
    }
}

