/*
 * Decompiled with CFR 0.152.
 */
package tools.mv.backend.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.codec.binary.Hex;
import tools.mv.backend.drive.DriveParent;
import tools.mv.backend.model.Node;

public class TempFileManager {
    private final InputStream source;
    private final DriveParent drive;
    private final Node node;
    private File tempFile;

    public TempFileManager(InputStream source, Node node, DriveParent drive) {
        this.source = source;
        this.node = node;
        this.drive = drive;
    }

    public String saveToTempAndHash() throws IOException, NoSuchAlgorithmException {
        if (this.tempFile != null) {
            throw new IllegalStateException("The temporary file already exists and cannot be written again.");
        }
        this.tempFile = Files.createTempFile("upload_", ".tmp", new FileAttribute[0]).toFile();
        this.tempFile.deleteOnExit();
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        try (DigestInputStream dis = new DigestInputStream(this.source, md);
             FileOutputStream out = new FileOutputStream(this.tempFile);){
            int len;
            byte[] buffer = new byte[8192];
            long bytesRead = 0L;
            while ((len = dis.read(buffer)) != -1) {
                ((OutputStream)out).write(buffer, 0, len);
                this.drive.setCustomMsg(this.node, bytesRead += (long)len, "SHA-256");
            }
        }
        return Hex.encodeHexString((byte[])md.digest());
    }

    public InputStream getInputStream() throws IOException {
        if (this.tempFile == null) {
            throw new IllegalStateException("The temporary file has not been created. Please call saveToTempAndHash() first.");
        }
        return new FileInputStream(this.tempFile);
    }

    public void deleteTempFile() {
        if (this.tempFile != null && this.tempFile.exists()) {
            if (!this.tempFile.delete()) {
                this.tempFile.deleteOnExit();
            }
            this.tempFile = null;
        }
    }
}

