/*
 * Decompiled with CFR 0.152.
 */
package tools.mv.backend.util;

import cn.hutool.core.codec.Base64;
import cn.hutool.crypto.asymmetric.KeyType;
import cn.hutool.crypto.asymmetric.RSA;
import cn.hutool.crypto.digest.DigestUtil;
import com.google.gson.Gson;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletResponse;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.time.ZonedDateTime;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.springframework.scheduling.support.CronExpression;
import tools.mv.backend.config.InitRunner;
import tools.mv.backend.entity.Task;
import tools.mv.backend.exception.BusinessException;
import tools.mv.backend.model.DriveAuth;
import tools.mv.backend.model.TaskResult;
import tools.mv.backend.util.MacUtil;

public class StringUtil {
    private static final String PUBLIC_KEY = "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDVWNLdXNfzUytvJhReEATTHNITcbAMRr+0EG4TkyWP8imd2fSJgtfxqaJ8qwUZIdHNYzNkvUKMsNVWpacgVk6HhUEhOwYN4faD31DVlHGEJIShrVj2qB+XvQ/oTj3uFXgyESIP+VtWOK30KEF2ZqI1Qb254gNWxazxki5bioZvZQIDAQAB";
    private static final SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final String SALT = "MV-Tools";

    public static boolean isVip() {
        return InitRunner.userInfo.isVip();
    }

    public static String encryptCode() {
        return StringUtil.encrypt(MacUtil.getMac());
    }

    public static String md5(String str) {
        return DigestUtil.md5Hex((String)(SALT + str));
    }

    public static void addCookie(HttpServletResponse response, String name, String value, int maxAge) {
        Cookie cookie = new Cookie(name, value);
        cookie.setMaxAge(maxAge);
        cookie.setPath("/");
        response.addCookie(cookie);
    }

    public static boolean isDev(String profile) {
        return "dev".equals(profile);
    }

    public static String getOrigin(String profile) {
        if (StringUtil.isDev(profile)) {
            return "http://localhost";
        }
        return "https://mv.tools";
    }

    public static String decrypt(String encryptBase64) {
        RSA rsaPublic = new RSA(null, PUBLIC_KEY);
        byte[] decrypt = rsaPublic.decrypt(Base64.decode((CharSequence)encryptBase64), KeyType.PublicKey);
        return new String(decrypt);
    }

    public static String encrypt(String data) {
        RSA rsaPublic = new RSA(null, PUBLIC_KEY);
        byte[] encryptData = rsaPublic.encrypt(data.getBytes(), KeyType.PublicKey);
        return Base64.encode((byte[])encryptData);
    }

    public static void checkCron(String cron) {
        if (!StringUtil.isValidCron(cron)) {
            throw new BusinessException("Cron expression format error", new Object[0]);
        }
        if (!StringUtil.isCronIntervalValid(cron)) {
            throw new BusinessException("Cron expression interval too short", new Object[0]);
        }
    }

    public static boolean isValidCron(String cron) {
        try {
            CronExpression.parse((String)cron);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isCronIntervalValid(String cron) {
        long minInterval;
        List<Long> times = StringUtil.nextExecutionTimes(cron, 2);
        if (times.size() < 2) {
            return false;
        }
        long first = times.get(0);
        long second = times.get(1);
        long diffMillis = second - first;
        return diffMillis >= (minInterval = 300000L);
    }

    public static List<Long> nextExecutionTimes(String cron, int count) {
        CronExpression expression = CronExpression.parse((String)cron);
        ArrayList<Long> results = new ArrayList<Long>();
        ZonedDateTime time = ZonedDateTime.now();
        for (int i = 0; i < count && (time = (ZonedDateTime)expression.next((Temporal)time)) != null; ++i) {
            results.add(time.toInstant().toEpochMilli());
        }
        return results;
    }

    public static String nowDate() {
        return SDF.format(new Date());
    }

    public static String formatBytes(long bytes) {
        int unitIndex;
        if (bytes < 1024L) {
            if (bytes < 0L) {
                return "0B";
            }
            return bytes + "B";
        }
        String[] units = new String[]{"KB", "MB", "GB", "TB", "PB", "EB"};
        double value = bytes;
        for (unitIndex = -1; value >= 1024.0 && unitIndex < units.length - 1; value /= 1024.0, ++unitIndex) {
        }
        return String.format("%.2f%s", value, units[unitIndex]);
    }

    public static String uuid() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    public static boolean needApp(String type) {
        switch (type) {
            case "GoogleDrive": 
            case "OneDrive": 
            case "Dropbox": 
            case "PCloud": 
            case "Box": 
            case "MediaFire": {
                return true;
            }
        }
        return false;
    }

    public static String checkAppType(String type) {
        if (StringUtil.needApp(type)) {
            return type;
        }
        throw new BusinessException("App type does not exist", new Object[0]);
    }

    public static String checkDriveType(String type) {
        if ("LocalDrive".equals(type)) {
            return type;
        }
        if ("FTP".equals(type)) {
            return type;
        }
        if ("SFTP".equals(type)) {
            return type;
        }
        if ("WebDAV".equals(type)) {
            return type;
        }
        try {
            return StringUtil.checkAppType(type);
        }
        catch (Exception e) {
            throw new BusinessException("Drive type does not exist", new Object[0]);
        }
    }

    public static String createDriveId(String type, DriveAuth auth) {
        String uuid = auth.getUuid();
        if (uuid == null) {
            throw new BusinessException("Drive UUID is empty", new Object[0]);
        }
        return DigestUtil.md5Hex((String)(type + uuid));
    }

    public static String base64(String text) {
        return Base64.encode((CharSequence)text);
    }

    public static String checkTaskType(String type) {
        if ("copy".equals(type)) {
            return type;
        }
        if ("tran".equals(type)) {
            return type;
        }
        if ("sync".equals(type)) {
            return type;
        }
        if ("backup".equals(type)) {
            return type;
        }
        throw new BusinessException("Task type error", new Object[0]);
    }

    public static boolean taskIsDone(String status) {
        return "Canceled".equals(status) || "Success".equals(status) || "Failed".equals(status) || "Warning".equals(status) || "Error".equals(status);
    }

    public static boolean taskIsRun(String status) {
        return "Pending".equals(status) || "Running".equals(status);
    }

    public static boolean taskIsPending(String status) {
        return "Pending".equals(status);
    }

    public static boolean taskIsRunning(String status) {
        return "Running".equals(status);
    }

    public static String getMsgOrTrace(Throwable e) {
        String msg = e.getMessage();
        if (msg != null) {
            return msg;
        }
        return StringUtil.getTrace(e);
    }

    public static String getMsg(Throwable e) {
        String msg = e.getMessage();
        if (msg != null) {
            return msg;
        }
        return e.toString();
    }

    public static String getTrace(Throwable e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        return sw.toString();
    }

    public static void changeTask(Task task, TaskResult result, String status, String msg) {
        if (result == null) {
            result = new TaskResult();
        }
        if (msg == null) {
            msg = "";
        }
        task.setResult(new Gson().toJson((Object)result));
        task.setStatus(status);
        task.setMsg(msg);
    }
}

