/*
 * Decompiled with CFR 0.152.
 */
package tools.mv.backend.util;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import tools.mv.backend.drive.DriveParent;
import tools.mv.backend.model.Node;

public class ProgInputStream
extends FilterInputStream {
    private final Node node;
    private final DriveParent drive;
    private long bytesRead = 0L;

    public ProgInputStream(InputStream in, Node node, DriveParent drive) {
        super(in);
        this.node = node;
        this.drive = drive;
    }

    @Override
    public int read() throws IOException {
        int b = super.read();
        if (b != -1) {
            ++this.bytesRead;
            this.drive.setUploadMsg(this.node, this.bytesRead);
        }
        return b;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int n = super.read(b, off, len);
        if (n > 0) {
            this.bytesRead += (long)n;
            this.drive.setUploadMsg(this.node, this.bytesRead);
        }
        return n;
    }

    public long getSum() {
        return this.bytesRead;
    }
}

