/*
 * Decompiled with CFR 0.152.
 */
package tools.mv.backend.util;

import com.pcloud.sdk.DataSource;
import java.io.IOException;
import java.io.InputStream;
import okio.BufferedSink;
import okio.Okio;
import okio.Source;

public class InputStreamDataSource
extends DataSource {
    private final InputStream in;
    private final long length;

    public InputStreamDataSource(InputStream in, long length) {
        if (in == null) {
            throw new IllegalArgumentException("InputStream cannot be null");
        }
        this.in = in;
        this.length = length;
    }

    public long contentLength() {
        return this.length;
    }

    public void writeTo(BufferedSink sink) throws IOException {
        try (Source source = Okio.source((InputStream)this.in);){
            sink.writeAll(source);
        }
    }
}

