/*
 * Decompiled with CFR 0.152.
 */
package tools.mv.backend.task;

import com.google.gson.Gson;
import jakarta.servlet.ServletContext;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import tools.mv.backend.entity.Task;
import tools.mv.backend.exception.CancelTaskException;
import tools.mv.backend.exception.StopTaskException;
import tools.mv.backend.model.ExecTaskParam;
import tools.mv.backend.model.Node;
import tools.mv.backend.model.TaskParam;
import tools.mv.backend.model.TaskResult;
import tools.mv.backend.model.TaskRun;
import tools.mv.backend.run.BaseTask;
import tools.mv.backend.service.AppService;
import tools.mv.backend.service.DriveService;
import tools.mv.backend.service.TaskService;
import tools.mv.backend.task.ApplicationKeys;
import tools.mv.backend.util.StringUtil;

@Service
public class TaskExecutor {
    @Autowired
    private AppService appService;
    @Autowired
    private DriveService driveService;
    @Autowired
    private TaskService taskService;
    @Autowired
    private ServletContext application;
    private static final int MAX_ERROR_FILE_COUNT = 100;
    public static final int MAX_WAIT_MINUTE = 5;
    private static final Logger logger = LoggerFactory.getLogger(TaskExecutor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Async(value="myTaskExecutor")
    public void execute(Task task) {
        String taskId = task.getId();
        logger.info(StringUtil.nowDate() + " Start task: " + taskId);
        TaskParam taskParam = task.getTaskParam();
        int runThread = taskParam.loadRunThread();
        int listThread = taskParam.loadListThread();
        ExecutorService workerPool = Executors.newFixedThreadPool(runThread);
        ExecutorService listPool = Executors.newFixedThreadPool(listThread);
        TaskResult taskResult = new TaskResult();
        try {
            long[] lastTime = new long[]{System.currentTimeMillis()};
            taskResult.setStartTime(lastTime[0]);
            taskResult.setEndTime(lastTime[0] + 1000L);
            if (!StringUtil.isVip()) {
                TaskExecutor.cancelTask(taskResult, listPool, workerPool, "The subscription has expired");
            }
            TaskRun taskRun = task.toTaskRun(taskResult, () -> {
                long now;
                if (taskResult.isCancel()) {
                    throw new CancelTaskException(taskResult.getCancelMsg());
                }
                if (taskResult.getCancelMsg() != null) {
                    TaskExecutor.cancelTask(taskResult, listPool, workerPool, taskResult.getCancelMsg());
                }
                if ((now = System.currentTimeMillis()) - lastTime[0] > 3000L) {
                    lastTime[0] = now;
                    if (this.application.getAttribute(ApplicationKeys.cancelFlag(taskId)) != null) {
                        TaskExecutor.cancelTask(taskResult, listPool, workerPool, "Manually cancel task");
                    } else if ((long)taskResult.getErrorFiles().size() - taskResult.getCountWarn().get() >= 100L) {
                        TaskExecutor.cancelTask(taskResult, listPool, workerPool, "Too many failed files");
                    } else {
                        taskResult.setEndTime(now);
                        this.application.setAttribute(ApplicationKeys.progress(taskId), (Object)taskResult.toTaskResultLess());
                        this.application.setAttribute(ApplicationKeys.progress(taskId).concat("_time"), (Object)System.currentTimeMillis());
                    }
                }
            });
            ExecTaskParam execTaskParam = ExecTaskParam.builder().appService(this.appService).driveService(this.driveService).taskRun(taskRun).workerPool(workerPool).listPool(listPool).build();
            BaseTask baseTask = BaseTask.create(execTaskParam);
            try {
                baseTask.run();
                baseTask.isListDone = true;
                taskResult.setListDone(true);
                ThreadPoolExecutor tpeList = (ThreadPoolExecutor)listPool;
                baseTask.setCurNodeAndMsg(null, "List done. " + tpeList.getCompletedTaskCount() + "/" + tpeList.getTaskCount());
                logger.info(StringUtil.nowDate() + " Task traversal completed: " + taskId + "\uff0c" + tpeList.getCompletedTaskCount() + "/" + tpeList.getTaskCount());
                workerPool.shutdown();
                long MAX_WAIT = 290000L;
                while (!workerPool.isTerminated()) {
                    if (System.currentTimeMillis() - taskResult.getEndTime() > 290000L) {
                        throw new StopTaskException("Task unresponsive for a long time 290000");
                    }
                    Thread.sleep(1000L);
                }
                ThreadPoolExecutor tpeWork = (ThreadPoolExecutor)workerPool;
                logger.info(StringUtil.nowDate() + " Task execution completed: " + taskId + "\uff0c" + tpeWork.getCompletedTaskCount() + "/" + tpeWork.getTaskCount());
                logger.info(StringUtil.nowDate() + " Task execution statistics: " + taskId + "\uff0c" + (tpeList.getCompletedTaskCount() + tpeWork.getCompletedTaskCount()));
            }
            finally {
                baseTask.closeAll();
            }
            if (taskResult.isCancel()) {
                throw new CancelTaskException(taskResult.getCancelMsg());
            }
            List<Node> errorFiles = taskResult.getErrorFiles();
            if (errorFiles.isEmpty()) {
                logger.info(StringUtil.nowDate() + " Task ran successfully: " + taskId);
                StringUtil.changeTask(task, taskResult, "Success", "Task ran successfully");
            } else {
                long countWarn = taskResult.getCountWarn().get();
                long countError = taskResult.getCountError().get();
                logger.info(StringUtil.nowDate() + " Task failed: " + taskId + ", Warning:" + countWarn + ", Error:" + countError + ", Total:" + errorFiles.size());
                if (countError > 0L) {
                    StringUtil.changeTask(task, taskResult, "Failed", "Task execution failed");
                } else {
                    StringUtil.changeTask(task, taskResult, "Warning", "Task has warning files");
                }
            }
            this.updateTask(task, taskResult);
        }
        catch (CancelTaskException e) {
            logger.info(StringUtil.nowDate() + " Task has been fully cancelled: " + taskId);
            Task tempTask = this.taskService.get(taskId);
            if (tempTask != null) {
                StringUtil.changeTask(tempTask, taskResult, "Canceled", StringUtil.getMsgOrTrace(e));
                this.updateTask(tempTask, taskResult);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            logger.error(StringUtil.nowDate() + " Task running error: " + taskId + ", " + e.getMessage());
            StringUtil.changeTask(task, taskResult, "Error", StringUtil.getMsgOrTrace(e));
            this.updateTask(task, taskResult);
        }
        finally {
            this.application.removeAttribute(ApplicationKeys.progress(task.getId()));
            this.application.removeAttribute(ApplicationKeys.progress(task.getId()).concat("_time"));
            this.application.removeAttribute(ApplicationKeys.cancelFlag(task.getId()));
            listPool.shutdownNow();
            workerPool.shutdownNow();
        }
    }

    private static void cancelTask(TaskResult taskResult, ExecutorService listPool, ExecutorService workerPool, String cancelMsg) {
        if (!taskResult.isCancel()) {
            taskResult.setCancelMsg(cancelMsg);
            taskResult.setCancel(true);
            ((ThreadPoolExecutor)listPool).getQueue().clear();
            ((ThreadPoolExecutor)workerPool).getQueue().clear();
        }
        throw new CancelTaskException(cancelMsg);
    }

    private void updateTask(Task task, TaskResult taskResult) {
        taskResult.setEndTime(System.currentTimeMillis());
        taskResult.getRunningFilesMap().clear();
        taskResult.setCurNode(null);
        taskResult.setCurMsg("");
        task.setResult(new Gson().toJson((Object)taskResult));
        this.taskService.update(task);
    }
}

