/*
 * Decompiled with CFR 0.152.
 */
package tools.mv.backend.task;

import jakarta.servlet.ServletContext;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import tools.mv.backend.config.InitRunner;
import tools.mv.backend.entity.Task;
import tools.mv.backend.model.TaskResultLess;
import tools.mv.backend.service.TaskService;
import tools.mv.backend.task.ApplicationKeys;
import tools.mv.backend.task.ManageTask;
import tools.mv.backend.task.TaskDeque;
import tools.mv.backend.task.TaskExecutor;
import tools.mv.backend.util.StringUtil;

@Component
public class MyTaskScheduler {
    @Autowired
    private TaskService taskService;
    @Autowired
    private ServletContext application;
    @Autowired
    private TaskDeque taskDeque;
    @Autowired
    private TaskExecutor taskExecutor;
    @Autowired
    private ManageTask manageTask;
    @Value(value="${spring.profiles.active}")
    private String profile;
    private static final Logger logger = LoggerFactory.getLogger(MyTaskScheduler.class);

    @Scheduled(fixedDelay=60000L)
    public void checkAuth() {
        InitRunner.refreshUserInfo(this.profile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Scheduled(fixedDelay=60000L)
    public void checkRunningTasks() {
        MyTaskScheduler myTaskScheduler = this;
        synchronized (myTaskScheduler) {
            List<Task> runningTasks = this.taskService.loadRunningTasks();
            if (!runningTasks.isEmpty()) {
                block5: for (Task task : runningTasks) {
                    try {
                        Long time;
                        int count = 0;
                        while ((time = (Long)this.application.getAttribute(ApplicationKeys.progress(task.getId()).concat("_time"))) == null || System.currentTimeMillis() - time > 300000L) {
                            Thread.sleep(1000L);
                            if (!"Running".equals((task = this.taskService.get(task.getId())).getStatus())) continue block5;
                            if (++count < 3) continue;
                            task = this.manageTask.cancel(task);
                            this.manageTask.start(task);
                            logger.info(StringUtil.nowDate() + " Resume Running Task: " + task.getId());
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Scheduled(fixedDelay=60000L)
    public void recoverTasks() {
        MyTaskScheduler myTaskScheduler = this;
        synchronized (myTaskScheduler) {
            List<Task> errorTasks = this.taskService.loadErrorTasks();
            if (!errorTasks.isEmpty()) {
                for (Task task : errorTasks) {
                    this.manageTask.start(task);
                    logger.info(StringUtil.nowDate() + " Resume Error Task: " + task.getId());
                }
            }
        }
    }

    @Scheduled(fixedDelay=3000L)
    public void scheduleTasks() {
        String taskId;
        while ((taskId = this.taskDeque.pollFirst()) != null) {
            Task task = this.taskService.get(taskId);
            if (task == null || !StringUtil.taskIsPending(task.getStatus()) || (task = this.taskService.get(taskId)) == null || !StringUtil.taskIsPending(task.getStatus())) continue;
            this.application.setAttribute(ApplicationKeys.progress(taskId), (Object)new TaskResultLess());
            this.application.setAttribute(ApplicationKeys.progress(taskId).concat("_time"), (Object)System.currentTimeMillis());
            StringUtil.changeTask(task, null, "Running", "Start task");
            this.taskService.update(task);
            this.taskExecutor.execute(task);
        }
    }
}

