/*
 * Decompiled with CFR 0.152.
 */
package tools.mv.backend.task;

import jakarta.servlet.ServletContext;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import tools.mv.backend.entity.Task;
import tools.mv.backend.model.TaskResultLess;
import tools.mv.backend.service.TaskService;
import tools.mv.backend.task.ApplicationKeys;
import tools.mv.backend.task.TaskDeque;
import tools.mv.backend.util.StringUtil;

@Service
public class ManageTask {
    @Autowired
    private TaskDeque taskDeque;
    @Autowired
    private TaskService taskService;
    @Autowired
    private ServletContext application;
    private final Map<String, Integer> noProgCount = new HashMap<String, Integer>();

    public Task start(Task task) {
        String taskId = task.getId();
        String status = task.getStatus();
        if (StringUtil.taskIsRun(status)) {
            throw new RuntimeException("Task is running");
        }
        Object cancelFlag = this.application.getAttribute(ApplicationKeys.cancelFlag(taskId));
        if (cancelFlag != null && status.equals("Canceled")) {
            Long time = (Long)this.application.getAttribute(ApplicationKeys.progress(taskId).concat("_time"));
            if (time == null || System.currentTimeMillis() - time > 300000L) {
                this.application.removeAttribute(ApplicationKeys.progress(task.getId()));
                this.application.removeAttribute(ApplicationKeys.progress(task.getId()).concat("_time"));
                this.application.removeAttribute(ApplicationKeys.cancelFlag(task.getId()));
            } else {
                throw new RuntimeException("Waiting for task cancellation");
            }
        }
        if (cancelFlag != null) {
            this.application.removeAttribute(ApplicationKeys.cancelFlag(taskId));
        }
        StringUtil.changeTask(task, null, "Pending", "Waiting for task scheduling.");
        this.taskService.update(task);
        this.taskDeque.addLast(taskId);
        return task;
    }

    public TaskResultLess progress(String taskId) {
        TaskResultLess taskResultLess = (TaskResultLess)this.application.getAttribute(ApplicationKeys.progress(taskId));
        Long time = (Long)this.application.getAttribute(ApplicationKeys.progress(taskId).concat("_time"));
        if (time == null || System.currentTimeMillis() - time > 300000L) {
            taskResultLess = new TaskResultLess();
            Task task = this.taskService.get(taskId);
            if (task != null && StringUtil.taskIsRunning(task.getStatus())) {
                if (this.noProgCount.size() > 1000) {
                    this.noProgCount.clear();
                } else {
                    Integer count = this.noProgCount.get(taskId);
                    if (count == null) {
                        count = 0;
                    }
                    Integer n = count;
                    count = count + 1;
                    if (count >= 10) {
                        StringUtil.changeTask(task, null, "Error", "Task unresponsive for a long time");
                        this.taskService.update(task);
                        this.application.removeAttribute(ApplicationKeys.progress(task.getId()));
                        this.application.removeAttribute(ApplicationKeys.progress(task.getId()).concat("_time"));
                        this.application.removeAttribute(ApplicationKeys.cancelFlag(task.getId()));
                        this.noProgCount.remove(taskId);
                    } else {
                        this.noProgCount.put(taskId, count);
                    }
                }
            }
        } else {
            this.noProgCount.remove(taskId);
            Long ttlInMilliseconds = (System.currentTimeMillis() - time) / 1000L;
            taskResultLess.setTtl(ttlInMilliseconds);
        }
        return taskResultLess;
    }

    public Task cancel(Task task) {
        String taskId = task.getId();
        if (!StringUtil.taskIsRun(task.getStatus())) {
            throw new RuntimeException("Task is not running");
        }
        if (StringUtil.taskIsPending(task.getStatus())) {
            this.taskDeque.remove(taskId);
            StringUtil.changeTask(task, null, "Canceled", "Cancel pending task");
        } else {
            this.application.setAttribute(ApplicationKeys.cancelFlag(taskId), (Object)"1");
            StringUtil.changeTask(task, null, "Canceled", "Cancel running task");
            Long time = (Long)this.application.getAttribute(ApplicationKeys.progress(taskId).concat("_time"));
            if (time == null || System.currentTimeMillis() - time > 300000L) {
                this.application.removeAttribute(ApplicationKeys.progress(task.getId()));
                this.application.removeAttribute(ApplicationKeys.progress(task.getId()).concat("_time"));
                this.application.removeAttribute(ApplicationKeys.cancelFlag(task.getId()));
            }
        }
        this.taskService.update(task);
        return task;
    }
}

