/*
 * Decompiled with CFR 0.152.
 */
package tools.mv.backend.service;

import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tools.mv.backend.entity.Drive;
import tools.mv.backend.entity.Task;
import tools.mv.backend.exception.BusinessException;
import tools.mv.backend.model.TaskOptions;
import tools.mv.backend.model.TaskParam;
import tools.mv.backend.model.TaskResult;
import tools.mv.backend.repository.TaskRepository;
import tools.mv.backend.service.PlanService;
import tools.mv.backend.util.StringUtil;

@Service
public class TaskService {
    @Autowired
    private TaskRepository taskRepository;
    @Lazy
    @Autowired
    private PlanService planService;

    @Transactional
    public Task create(String type, TaskParam param, Drive driveFrom, Drive driveTo) {
        String cron = param.getOptions().getCron();
        if (cron != null && !cron.isEmpty()) {
            StringUtil.checkCron(cron);
        }
        long now = System.currentTimeMillis();
        Task task = Task.builder().id(StringUtil.uuid()).type(type).ctime(now).mtime(now).param(new Gson().toJson((Object)param)).result(new Gson().toJson((Object)new TaskResult())).status("Created").msg("Task has been created").fdid(driveFrom.getId()).tdid(driveTo.getId()).build();
        this.taskRepository.save(task);
        if (cron != null && !cron.isEmpty()) {
            this.planService.add("task", task.getId(), cron);
        }
        return task;
    }

    public void update(Task task) {
        task.setMtime(System.currentTimeMillis());
        this.taskRepository.save(task);
    }

    @Transactional
    public void delete(String id) {
        Task task = this.get(id);
        if (task != null) {
            if (StringUtil.taskIsRun(task.getStatus())) {
                throw new BusinessException("Task is running", new Object[0]);
            }
            this.taskRepository.deleteById(id);
            String cron = task.getTaskParam().getOptions().getCron();
            if (cron != null && !cron.isEmpty()) {
                this.planService.delete("task", task.getId());
            }
        }
    }

    @Transactional
    public Task options(String id, TaskOptions options) {
        Task task = this.get(id);
        if (task != null) {
            TaskParam taskParam = task.getTaskParam();
            String cronOld = taskParam.getOptions().getCron();
            String cronNew = options.getCron();
            taskParam.setOptions(options);
            task.setParam(new Gson().toJson((Object)taskParam));
            this.update(task);
            if (!cronOld.equals(cronNew)) {
                if (!cronOld.isEmpty() && cronNew.isEmpty()) {
                    this.planService.delete("task", task.getId());
                } else {
                    StringUtil.checkCron(cronNew);
                    this.planService.update("task", task.getId(), cronNew);
                }
            }
            return task;
        }
        throw new BusinessException("Task does not exist", new Object[0]);
    }

    public Task get(String id) {
        return this.taskRepository.findById(id).orElse(null);
    }

    public List<Task> listByFdid(String fdid) {
        ArrayList<Task> list = new ArrayList<Task>();
        List tasks = this.taskRepository.findAll();
        for (Task task : tasks) {
            if (!task.getFdid().equals(fdid)) continue;
            list.add(task);
        }
        return list;
    }

    public List<Task> listByTdid(String tdid) {
        ArrayList<Task> list = new ArrayList<Task>();
        List tasks = this.taskRepository.findAll();
        for (Task task : tasks) {
            if (!task.getTdid().equals(tdid)) continue;
            list.add(task);
        }
        return list;
    }

    public List<Task> listAll() {
        return this.taskRepository.findAll();
    }

    public List<Task> loadErrorTasks() {
        ArrayList<Task> list = new ArrayList<Task>();
        List tasks = this.taskRepository.findAll();
        for (Task task : tasks) {
            if (!task.getStatus().equals("Error")) continue;
            list.add(task);
        }
        return list;
    }

    public List<Task> loadRunningTasks() {
        ArrayList<Task> list = new ArrayList<Task>();
        List tasks = this.taskRepository.findAll();
        for (Task task : tasks) {
            if (!task.getStatus().equals("Running")) continue;
            list.add(task);
        }
        return list;
    }
}

