/*
 * Decompiled with CFR 0.152.
 */
package tools.mv.backend.service;

import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.scheduling.support.CronTrigger;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tools.mv.backend.entity.Plan;
import tools.mv.backend.entity.Task;
import tools.mv.backend.repository.PlanRepository;
import tools.mv.backend.repository.TaskRepository;
import tools.mv.backend.task.ManageTask;
import tools.mv.backend.util.StringUtil;

@Service
public class PlanService {
    @Autowired
    private ManageTask manageTask;
    @Autowired
    private TaskRepository taskRepository;
    @Autowired
    private PlanRepository planRepository;
    private static final Logger logger = LoggerFactory.getLogger(PlanService.class);
    private final TaskScheduler taskScheduler = new ThreadPoolTaskScheduler();
    private final Map<String, ScheduledFuture<?>> tasks = new ConcurrentHashMap();
    private final Map<String, String> crons = new ConcurrentHashMap<String, String>();

    public PlanService() {
        ((ThreadPoolTaskScheduler)this.taskScheduler).initialize();
    }

    @PostConstruct
    public void recover() {
        List plans = this.planRepository.findAll();
        for (Plan plan : plans) {
            this.schedule(plan);
        }
    }

    @Transactional
    public void add(String type, String val, String cron) {
        Plan plan = new Plan();
        plan.setId(StringUtil.uuid());
        plan.setType(type);
        plan.setVal(val);
        plan.setCron(cron);
        this.planRepository.save(plan);
        this.schedule(plan);
    }

    @Transactional
    public void update(String type, String val, String cron) {
        this.delete(type, val);
        this.add(type, val, cron);
    }

    @Transactional
    public void delete(String type, String val) {
        ArrayList<Plan> list = new ArrayList<Plan>();
        List plans = this.planRepository.findAll();
        for (Plan plan : plans) {
            if (!plan.getType().equals(type) || !plan.getVal().equals(val)) continue;
            list.add(plan);
        }
        for (Plan paln : list) {
            this.cancel(paln.getId());
            this.planRepository.deleteById(paln.getId());
        }
    }

    private void schedule(Plan plan) {
        CronTrigger trigger = new CronTrigger(plan.getCron());
        ScheduledFuture future = this.taskScheduler.schedule(() -> this.execute(plan.getId()), (Trigger)trigger);
        this.tasks.put(plan.getId(), future);
        this.crons.put(plan.getId(), plan.getCron());
    }

    private void cancel(String id) {
        ScheduledFuture<?> f = this.tasks.get(id);
        if (f != null) {
            f.cancel(false);
        }
        this.tasks.remove(id);
        this.crons.remove(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(String id) {
        String string = id.intern();
        synchronized (string) {
            Plan plan = this.planRepository.findById(id).orElse(null);
            if (plan == null) {
                this.cancel(id);
            } else if ("task".equals(plan.getType())) {
                String tid = plan.getVal();
                Task task = this.taskRepository.findById(tid).orElse(null);
                if (task == null) {
                    this.delete(plan.getType(), plan.getVal());
                } else {
                    try {
                        this.manageTask.start(task);
                        logger.info(StringUtil.nowDate() + " Scheduled task is normal: " + tid + "\uff0c" + plan.getCron());
                    }
                    catch (Exception e) {
                        logger.error(StringUtil.nowDate() + " Scheduled task error: " + tid + "\uff0c" + e.getMessage());
                    }
                }
            }
        }
    }
}

