/*
 * Decompiled with CFR 0.152.
 */
package tools.mv.backend.service;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import tools.mv.backend.entity.Drive;
import tools.mv.backend.entity.Task;
import tools.mv.backend.exception.BusinessException;
import tools.mv.backend.repository.DriveRepository;
import tools.mv.backend.service.TaskService;

@Service
public class DriveService {
    @Autowired
    private DriveRepository driveRepository;
    @Autowired
    private TaskService taskService;

    public Drive add(String id, String type, String name, String auth, String info) {
        long now = System.currentTimeMillis();
        Drive drive = Drive.builder().id(id).type(type).name(name).ctime(now).mtime(now).auth(auth).info(info).build();
        this.driveRepository.save(drive);
        return drive;
    }

    public void update(Drive drive) {
        drive.setMtime(System.currentTimeMillis());
        this.driveRepository.save(drive);
    }

    public void delete(String id) {
        Drive drive;
        List<Task> tasksTo;
        List<Task> tasksFrom = this.taskService.listByFdid(id);
        if (!tasksFrom.isEmpty()) {
            for (Task task : tasksFrom) {
                this.taskService.delete(task.getId());
            }
        }
        if (!(tasksTo = this.taskService.listByTdid(id)).isEmpty()) {
            for (Task task : tasksTo) {
                this.taskService.delete(task.getId());
            }
        }
        if ((drive = this.get(id)) != null) {
            this.driveRepository.deleteById(id);
        }
    }

    public Drive rename(String id, String name) {
        Drive drive = this.get(id);
        if (drive != null) {
            drive.setName(name);
            this.update(drive);
            return drive;
        }
        throw new BusinessException("Drive does not exist", new Object[0]);
    }

    public Drive get(String id) {
        return this.driveRepository.findById(id).orElse(null);
    }

    public List<Drive> listAll() {
        return this.driveRepository.findAll();
    }

    public boolean hasTypeDrive(String type) {
        List<Drive> drives = this.listAll();
        for (Drive drive : drives) {
            if (!drive.getType().equals(type)) continue;
            return true;
        }
        return false;
    }
}

