/*
 * Decompiled with CFR 0.152.
 */
package tools.mv.backend.run;

import java.util.ArrayList;
import java.util.HashMap;
import tools.mv.backend.model.CreateFolderResult;
import tools.mv.backend.model.ExecTaskParam;
import tools.mv.backend.model.MkdirParam;
import tools.mv.backend.model.Node;
import tools.mv.backend.run.BaseTask;
import tools.mv.backend.util.DriveUtil;
import tools.mv.backend.util.StringUtil;

public class SyncTask
extends BaseTask {
    public SyncTask(ExecTaskParam execTaskParam) {
        super(execTaskParam);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        DriveUtil driveUtilFromTemp = null;
        DriveUtil driveUtilToTemp = null;
        try {
            driveUtilFromTemp = this.srcPoolList.borrow();
            driveUtilToTemp = this.dstPoolList.borrow();
            this.checkNode(this.nodeFrom, this.nodeTo);
            this.syncDirectory(this.nodeFrom, this.nodeTo, driveUtilToTemp, driveUtilFromTemp, false, false);
        }
        catch (Throwable e) {
            try {
                this.taskThrowable(e);
            }
            catch (Throwable throwable) {
                this.releaseDrive(driveUtilToTemp, driveUtilFromTemp);
                throw throwable;
            }
            this.releaseDrive(driveUtilToTemp, driveUtilFromTemp);
        }
        this.releaseDrive(driveUtilToTemp, driveUtilFromTemp);
        this.waitListDone();
    }

    private void syncDirectory(Node fromNodeParam, Node toNodeParam, DriveUtil driveUtilToTemp, DriveUtil driveUtilFromTemp, boolean toFolderIsNew, boolean fromFolderIsNew) {
        try {
            HashMap<String, Node> toExists;
            ArrayList<Node> toNodes;
            HashMap<String, Node> fromExists;
            ArrayList<Node> fromNodes;
            if (fromFolderIsNew) {
                fromNodes = new ArrayList(0);
                fromExists = new HashMap(0);
            } else {
                fromNodes = this.listAll(fromNodeParam, false, driveUtilToTemp, driveUtilFromTemp, true);
                fromExists = this.nodesToMap(fromNodes);
                this.addSumCountAndSumSize(fromNodes);
            }
            if (toFolderIsNew) {
                toNodes = new ArrayList(0);
                toExists = new HashMap(0);
            } else {
                toNodes = this.listAll(toNodeParam, true, driveUtilToTemp, driveUtilFromTemp, true);
                toExists = this.nodesToMap(toNodes);
                this.addSumCountAndSumSize(toNodes);
            }
            for (Node toNode : toNodes) {
                if (!this.shouldExclude(toNode)) {
                    if (toNode.isDir()) {
                        this.listPool.submit(() -> {
                            boolean released;
                            DriveUtil driveUtilFromNew;
                            block10: {
                                if (this.result.isCancel()) {
                                    return;
                                }
                                driveUtilFromNew = null;
                                DriveUtil driveUtilToNew = null;
                                try {
                                    boolean released2;
                                    driveUtilFromNew = this.srcPoolList.borrow();
                                    driveUtilToNew = this.dstPoolList.borrow();
                                    MkdirParam param = MkdirParam.builder().node(fromNodeParam).name(toNode.getName()).build();
                                    CreateFolderResult result = this.createDirectoryWithRetry(param, fromExists, false, driveUtilToNew, driveUtilFromNew);
                                    Node fromNewFolder = result.getNode();
                                    if (fromNewFolder != null && result.getIsNew().booleanValue()) {
                                        this.syncDirectory(fromNewFolder, toNode, driveUtilToNew, driveUtilFromNew, false, true);
                                    }
                                    if (driveUtilToNew == null || (released2 = this.dstPoolList.release(driveUtilToNew))) break block10;
                                }
                                catch (Throwable e) {
                                    boolean released3;
                                    block11: {
                                        try {
                                            boolean released4;
                                            this.checkTaskError(e);
                                            toNode.setMsg("Error to copy dir:" + toNode.getName() + "," + StringUtil.getMsg(e));
                                            toNode.setTrace(StringUtil.getTrace(e));
                                            this.addError(toNode, false);
                                            if (driveUtilToNew == null || (released4 = this.dstPoolList.release(driveUtilToNew))) break block11;
                                        }
                                        catch (Throwable throwable) {
                                            boolean released5;
                                            if (driveUtilToNew != null && !(released5 = this.dstPoolList.release(driveUtilToNew))) {
                                                logger.error("Failed to release driveUtilToNew(dstPoolList)");
                                            }
                                            if (driveUtilFromNew != null && !(released5 = this.srcPoolList.release(driveUtilFromNew))) {
                                                logger.error("Failed to release driveUtilFromNew(srcPoolList)");
                                            }
                                            throw throwable;
                                        }
                                        logger.error("Failed to release driveUtilToNew(dstPoolList)");
                                    }
                                    if (driveUtilFromNew != null && !(released3 = this.srcPoolList.release(driveUtilFromNew))) {
                                        logger.error("Failed to release driveUtilFromNew(srcPoolList)");
                                    }
                                }
                                logger.error("Failed to release driveUtilToNew(dstPoolList)");
                            }
                            if (driveUtilFromNew != null && !(released = this.srcPoolList.release(driveUtilFromNew))) {
                                logger.error("Failed to release driveUtilFromNew(srcPoolList)");
                            }
                        });
                        continue;
                    }
                    if (this.shouldCopy(toNode)) {
                        this.copyFileWithRetry(toNode, fromNodeParam, fromExists, false, driveUtilToTemp, driveUtilFromTemp);
                        continue;
                    }
                    this.subNode(toNode);
                    continue;
                }
                this.subNode(toNode);
            }
            for (Node fromNode : fromNodes) {
                if (!this.shouldExclude(fromNode)) {
                    if (fromNode.isDir()) {
                        this.listPool.submit(() -> {
                            boolean released;
                            DriveUtil driveUtilFromNew;
                            block10: {
                                if (this.result.isCancel()) {
                                    return;
                                }
                                driveUtilFromNew = null;
                                DriveUtil driveUtilToNew = null;
                                try {
                                    boolean released2;
                                    driveUtilFromNew = this.srcPoolList.borrow();
                                    driveUtilToNew = this.dstPoolList.borrow();
                                    MkdirParam param = MkdirParam.builder().node(toNodeParam).name(fromNode.getName()).build();
                                    CreateFolderResult result = this.createDirectoryWithRetry(param, toExists, true, driveUtilToNew, driveUtilFromNew);
                                    Node toNewFolder = result.getNode();
                                    if (toNewFolder != null) {
                                        this.syncDirectory(fromNode, toNewFolder, driveUtilToNew, driveUtilFromNew, result.getIsNew(), false);
                                    }
                                    if (driveUtilToNew == null || (released2 = this.dstPoolList.release(driveUtilToNew))) break block10;
                                }
                                catch (Throwable e) {
                                    boolean released3;
                                    block11: {
                                        try {
                                            boolean released4;
                                            this.checkTaskError(e);
                                            fromNode.setMsg("Error to copy dir:" + fromNode.getName() + "," + StringUtil.getMsg(e));
                                            fromNode.setTrace(StringUtil.getTrace(e));
                                            this.addError(fromNode, false);
                                            if (driveUtilToNew == null || (released4 = this.dstPoolList.release(driveUtilToNew))) break block11;
                                        }
                                        catch (Throwable throwable) {
                                            boolean released5;
                                            if (driveUtilToNew != null && !(released5 = this.dstPoolList.release(driveUtilToNew))) {
                                                logger.error("Failed to release driveUtilToNew(dstPoolList)");
                                            }
                                            if (driveUtilFromNew != null && !(released5 = this.srcPoolList.release(driveUtilFromNew))) {
                                                logger.error("Failed to release driveUtilFromNew(srcPoolList)");
                                            }
                                            throw throwable;
                                        }
                                        logger.error("Failed to release driveUtilToNew(dstPoolList)");
                                    }
                                    if (driveUtilFromNew != null && !(released3 = this.srcPoolList.release(driveUtilFromNew))) {
                                        logger.error("Failed to release driveUtilFromNew(srcPoolList)");
                                    }
                                }
                                logger.error("Failed to release driveUtilToNew(dstPoolList)");
                            }
                            if (driveUtilFromNew != null && !(released = this.srcPoolList.release(driveUtilFromNew))) {
                                logger.error("Failed to release driveUtilFromNew(srcPoolList)");
                            }
                        });
                        continue;
                    }
                    if (this.shouldCopy(fromNode)) {
                        this.copyFileWithRetry(fromNode, toNodeParam, toExists, true, driveUtilToTemp, driveUtilFromTemp);
                        continue;
                    }
                    this.subNode(fromNode);
                    continue;
                }
                this.subNode(fromNode);
            }
        }
        catch (Throwable e) {
            this.checkTaskError(e);
            Node tempNode = fromNodeParam;
            if (tempNode == null) {
                tempNode = Node.builder().name("root").build();
            }
            tempNode.setMsg("Failed to copy dir:" + tempNode.getName() + "," + StringUtil.getMsg(e));
            tempNode.setTrace(StringUtil.getTrace(e));
            boolean isWarn = false;
            if (tempNode.getWarn() != null && tempNode.getWarn().booleanValue()) {
                isWarn = true;
            }
            if (toNodeParam != null && toNodeParam.getWarn() != null && toNodeParam.getWarn().booleanValue()) {
                isWarn = true;
            }
            if (!isWarn && tempNode.getMsg().contains("Insufficient drive space")) {
                isWarn = true;
            }
            this.addError(tempNode, isWarn);
        }
    }
}

