/*
 * Decompiled with CFR 0.152.
 */
package tools.mv.backend.run;

import java.util.HashMap;
import java.util.List;
import tools.mv.backend.model.CreateFolderResult;
import tools.mv.backend.model.ExecTaskParam;
import tools.mv.backend.model.MkdirParam;
import tools.mv.backend.model.Node;
import tools.mv.backend.run.BaseTask;
import tools.mv.backend.util.DriveUtil;
import tools.mv.backend.util.StringUtil;

public abstract class CopyTranBackupTask
extends BaseTask {
    public CopyTranBackupTask(ExecTaskParam execTaskParam) {
        super(execTaskParam);
    }

    public void copyDirectory(Node fromNodeParam, Node toNodeParam, DriveUtil driveUtilToTemp, DriveUtil driveUtilFromTemp, boolean toFolderIsNew) {
        try {
            HashMap<String, Node> exists;
            List<Node> fromNodes = this.listAll(fromNodeParam, false, driveUtilToTemp, driveUtilFromTemp, true);
            this.addSumCountAndSumSize(fromNodes);
            if (toFolderIsNew) {
                exists = new HashMap(0);
            } else {
                List<Node> listAll = this.listAll(toNodeParam, true, driveUtilToTemp, driveUtilFromTemp, false);
                exists = this.nodesToMap(listAll);
            }
            for (Node fromNode : fromNodes) {
                if (!this.shouldExclude(fromNode)) {
                    if (fromNode.isDir()) {
                        this.listPool.submit(() -> {
                            boolean released;
                            DriveUtil driveUtilFromNew;
                            block10: {
                                if (this.result.isCancel()) {
                                    return;
                                }
                                driveUtilFromNew = null;
                                DriveUtil driveUtilToNew = null;
                                try {
                                    boolean released2;
                                    driveUtilFromNew = this.srcPoolList.borrow();
                                    driveUtilToNew = this.dstPoolList.borrow();
                                    MkdirParam param = MkdirParam.builder().node(toNodeParam).name(fromNode.getName()).build();
                                    CreateFolderResult result = this.createDirectoryWithRetry(param, exists, true, driveUtilToNew, driveUtilFromNew);
                                    Node node = result.getNode();
                                    if (node != null) {
                                        this.copyDirectory(fromNode, node, driveUtilToNew, driveUtilFromNew, result.getIsNew());
                                    }
                                    if (driveUtilToNew == null || (released2 = this.dstPoolList.release(driveUtilToNew))) break block10;
                                }
                                catch (Throwable e) {
                                    boolean released3;
                                    block11: {
                                        try {
                                            boolean released4;
                                            this.checkTaskError(e);
                                            fromNode.setMsg("Error to copy dir:" + fromNode.getName() + "," + StringUtil.getMsg(e));
                                            fromNode.setTrace(StringUtil.getTrace(e));
                                            this.addError(fromNode, false);
                                            if (driveUtilToNew == null || (released4 = this.dstPoolList.release(driveUtilToNew))) break block11;
                                        }
                                        catch (Throwable throwable) {
                                            boolean released5;
                                            if (driveUtilToNew != null && !(released5 = this.dstPoolList.release(driveUtilToNew))) {
                                                logger.error(StringUtil.nowDate() + "_" + this.tid + " Failed to release driveUtilToNew(dstPoolList)");
                                            }
                                            if (driveUtilFromNew != null && !(released5 = this.srcPoolList.release(driveUtilFromNew))) {
                                                logger.error(StringUtil.nowDate() + "_" + this.tid + " Failed to release driveUtilFromNew(srcPoolList)");
                                            }
                                            throw throwable;
                                        }
                                        logger.error(StringUtil.nowDate() + "_" + this.tid + " Failed to release driveUtilToNew(dstPoolList)");
                                    }
                                    if (driveUtilFromNew != null && !(released3 = this.srcPoolList.release(driveUtilFromNew))) {
                                        logger.error(StringUtil.nowDate() + "_" + this.tid + " Failed to release driveUtilFromNew(srcPoolList)");
                                    }
                                }
                                logger.error(StringUtil.nowDate() + "_" + this.tid + " Failed to release driveUtilToNew(dstPoolList)");
                            }
                            if (driveUtilFromNew != null && !(released = this.srcPoolList.release(driveUtilFromNew))) {
                                logger.error(StringUtil.nowDate() + "_" + this.tid + " Failed to release driveUtilFromNew(srcPoolList)");
                            }
                        });
                        continue;
                    }
                    if (this.shouldCopy(fromNode)) {
                        this.copyFileWithRetry(fromNode, toNodeParam, exists, true, driveUtilToTemp, driveUtilFromTemp);
                        continue;
                    }
                    this.subNode(fromNode);
                    continue;
                }
                this.subNode(fromNode);
            }
        }
        catch (Throwable e) {
            this.checkTaskError(e);
            if (fromNodeParam == null) {
                fromNodeParam = Node.builder().name("root").build();
            }
            fromNodeParam.setMsg("Failed to copy dir:" + fromNodeParam.getName() + "," + StringUtil.getMsg(e));
            fromNodeParam.setTrace(StringUtil.getTrace(e));
            boolean isWarn = false;
            if (fromNodeParam.getWarn() != null && fromNodeParam.getWarn().booleanValue()) {
                isWarn = true;
            }
            if (toNodeParam != null && toNodeParam.getWarn() != null && toNodeParam.getWarn().booleanValue()) {
                isWarn = true;
            }
            if (!isWarn && fromNodeParam.getMsg().contains("Insufficient drive space")) {
                isWarn = true;
            }
            this.addError(fromNodeParam, isWarn);
        }
    }
}

