/*
 * Decompiled with CFR 0.152.
 */
package tools.mv.backend.run;

import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tools.mv.backend.entity.Drive;
import tools.mv.backend.exception.BusinessException;
import tools.mv.backend.exception.CancelTaskException;
import tools.mv.backend.exception.NotRetryException;
import tools.mv.backend.exception.StopTaskException;
import tools.mv.backend.model.CreateFolderResult;
import tools.mv.backend.model.DownloadParam;
import tools.mv.backend.model.DriveInfo;
import tools.mv.backend.model.ExecTaskParam;
import tools.mv.backend.model.ListParam;
import tools.mv.backend.model.MkdirParam;
import tools.mv.backend.model.Node;
import tools.mv.backend.model.TaskOptions;
import tools.mv.backend.model.TaskParam;
import tools.mv.backend.model.TaskResult;
import tools.mv.backend.model.TaskRun;
import tools.mv.backend.model.UploadParam;
import tools.mv.backend.run.BackupTask;
import tools.mv.backend.run.CopyTask;
import tools.mv.backend.run.SyncTask;
import tools.mv.backend.run.TranTask;
import tools.mv.backend.service.AppService;
import tools.mv.backend.service.DriveService;
import tools.mv.backend.task.ListAllError;
import tools.mv.backend.task.TaskProgress;
import tools.mv.backend.util.DriveUtil;
import tools.mv.backend.util.DriveUtilPool;
import tools.mv.backend.util.StringUtil;

public abstract class BaseTask {
    private String fdid;
    private String tdid;
    public Node nodeFrom;
    public Node nodeTo;
    public Boolean fromNodeHasSameName = false;
    public Boolean toNodeHasSameName = false;
    public final TaskResult result;
    private final TaskProgress progress;
    private Set<String> excludeNames = new HashSet<String>(0);
    private Set<String> allowedExtensions = new HashSet<String>(0);
    private static final int MAX_RETRY = 1;
    public static final int MAX_SLEEP_SECOND = 3;
    private final ExecutorService workerPool;
    private final DriveUtilPool srcPool;
    private final DriveUtilPool dstPool;
    public final ExecutorService listPool;
    public final DriveUtilPool srcPoolList;
    public final DriveUtilPool dstPoolList;
    public boolean isListDone;
    public String tid;
    public static final Logger logger = LoggerFactory.getLogger(BaseTask.class);

    public BaseTask(ExecTaskParam execTaskParam) {
        Drive driveFrom;
        AppService appService = execTaskParam.getAppService();
        DriveService driveService = execTaskParam.getDriveService();
        TaskRun taskRun = execTaskParam.getTaskRun();
        this.tid = taskRun.getId();
        this.result = taskRun.getResult();
        this.progress = taskRun.getProgress();
        this.fdid = taskRun.getFdid();
        this.tdid = taskRun.getTdid();
        TaskParam param = taskRun.getParam();
        this.nodeFrom = param.getFrom();
        this.nodeTo = param.getTo();
        int runThread = param.loadRunThread();
        int listThread = param.loadListThread();
        TaskOptions options = param.getOptions();
        if (options != null) {
            this.excludeNames = options.getExcludeNames();
            this.allowedExtensions = options.getAllowedExtensions();
            if (this.excludeNames == null) {
                this.excludeNames = new HashSet<String>(0);
            }
            if (this.allowedExtensions == null) {
                this.allowedExtensions = new HashSet<String>(0);
            }
        }
        if ((driveFrom = driveService.get(taskRun.getFdid())) == null) {
            throw new BusinessException("Source drive does not exist", new Object[0]);
        }
        this.fromNodeHasSameName = this.driveHasSameName(driveFrom.getType());
        Drive driveTo = driveService.get(taskRun.getTdid());
        if (driveTo == null) {
            throw new BusinessException("Target drive does not exist", new Object[0]);
        }
        this.toNodeHasSameName = this.driveHasSameName(driveTo.getType());
        this.setCurNodeAndMsg(null, "Initialize multithreading");
        ArrayList<DriveUtil> srcInstances = new ArrayList<DriveUtil>(runThread);
        ArrayList<DriveUtil> dstInstances = new ArrayList<DriveUtil>(runThread);
        ArrayList<DriveUtil> srcInstancesList = new ArrayList<DriveUtil>(listThread);
        ArrayList<DriveUtil> dstInstancesList = new ArrayList<DriveUtil>(listThread);
        try {
            int i;
            this.listPool = execTaskParam.getListPool();
            this.workerPool = execTaskParam.getWorkerPool();
            for (i = 0; i < runThread; ++i) {
                srcInstances.add(new DriveUtil(appService, driveService, driveFrom, taskRun.getProgress()));
                dstInstances.add(new DriveUtil(appService, driveService, driveTo, taskRun.getProgress()));
            }
            for (i = 0; i < listThread; ++i) {
                srcInstancesList.add(new DriveUtil(appService, driveService, driveFrom, taskRun.getProgress()));
                dstInstancesList.add(new DriveUtil(appService, driveService, driveTo, taskRun.getProgress()));
            }
            this.srcPool = new DriveUtilPool(srcInstances);
            this.dstPool = new DriveUtilPool(dstInstances);
            this.srcPoolList = new DriveUtilPool(srcInstancesList);
            this.dstPoolList = new DriveUtilPool(dstInstancesList);
        }
        catch (Exception e) {
            for (DriveUtil srcInstance : srcInstances) {
                srcInstance.close();
            }
            for (DriveUtil dstInstance : dstInstances) {
                dstInstance.close();
            }
            for (DriveUtil srcInstanceList : srcInstancesList) {
                srcInstanceList.close();
            }
            for (DriveUtil dstInstanceList : dstInstancesList) {
                dstInstanceList.close();
            }
            throw new StopTaskException("Failed to initialize multithreading: " + StringUtil.getMsgOrTrace(e));
        }
    }

    public void closeAll() {
        this.closeList();
        this.dstPool.close();
        this.srcPool.close();
    }

    public void closeList() {
        this.dstPoolList.close();
        this.srcPoolList.close();
    }

    private void refreshProgress() {
        if (this.progress != null) {
            this.progress.callback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurNodeAndMsg(Node node, String msg) {
        TaskResult taskResult = this.result;
        synchronized (taskResult) {
            this.result.setCurNode(node);
            this.result.setCurMsg(msg);
        }
        this.refreshProgress();
    }

    private void addCurSize(Long size) {
        if (size != null && size > 0L) {
            this.result.getSizeCur().addAndGet(size);
        }
    }

    public void addSumSize(Long size) {
        if (size != null && size > 0L) {
            this.result.getSizeSum().addAndGet(size);
        }
    }

    private void changeSumSize(long gap) {
        if (gap != 0L) {
            this.result.getSizeSum().addAndGet(gap);
        }
    }

    public void addSumCountAndSumSize(List<Node> nodes) {
        this.addSum(nodes.size());
        for (Node node : nodes) {
            if (node.isDir()) continue;
            this.addSumSize(node.getSize());
        }
    }

    public void subNode(Node node) {
        Long size;
        this.addSum(-1);
        if (!node.isDir() && (size = node.getSize()) != null) {
            this.addSumSize(-size.longValue());
        }
    }

    public void addError(Node node, boolean isWarn) {
        node.setWarn(isWarn);
        this.result.getErrorFiles().add(node);
        if (isWarn) {
            this.result.getCountWarn().incrementAndGet();
        } else {
            this.result.getCountError().incrementAndGet();
        }
    }

    private void addSkip() {
        this.result.getCountSkip().incrementAndGet();
    }

    private void addSuccess() {
        this.result.getCountSuccess().incrementAndGet();
    }

    public void addSum(int count) {
        this.result.getCountSum().addAndGet(count);
    }

    public void checkTargetSpace(DriveUtil driveUtilToTemp) {
        DriveInfo info;
        try {
            this.setCurNodeAndMsg(null, "Start retrieving target space information");
            info = driveUtilToTemp.info();
        }
        catch (Exception e) {
            throw new StopTaskException("Failed to retrieve target space information: " + StringUtil.getMsgOrTrace(e));
        }
        Long used = info.getUsed();
        Long total = info.getTotal();
        if (used != null && total != null && total >= 0L && used >= total) {
            throw new StopTaskException("Target drive is full");
        }
    }

    public boolean shouldExclude(Node node) {
        return this.excludeNames.contains(node.getName());
    }

    public boolean shouldCopy(Node node) {
        if (node.isDir()) {
            return false;
        }
        if (this.shouldExclude(node)) {
            return false;
        }
        if (this.allowedExtensions.isEmpty()) {
            return true;
        }
        String name = node.getName().toLowerCase();
        int dot = name.lastIndexOf(46);
        if (dot != -1 && dot < name.length() - 1) {
            String ext = name.substring(dot + 1);
            return this.allowedExtensions.contains(ext);
        }
        return false;
    }

    public void sleep(int ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private boolean isSkipFile(UploadParam param, Node thisNode, Map<String, Node> exists) throws Exception {
        boolean isSkip = false;
        Node existNode = exists.get(param.getName().toLowerCase());
        if (existNode != null) {
            if (existNode.isDir()) {
                throw new Exception("Name is already in use: " + param.getName() + "\u2192" + existNode.getName());
            }
            Long thisSize = thisNode.getSize();
            Long existSize = existNode.getSize();
            if (thisSize == null || existSize == null) {
                isSkip = true;
            } else if (thisSize.longValue() == existSize.longValue()) {
                isSkip = true;
            } else {
                Long thisTime = thisNode.getTime();
                Long existTime = existNode.getTime();
                if (thisTime == null || existTime == null) {
                    isSkip = true;
                } else if (thisTime <= existTime) {
                    isSkip = true;
                }
            }
        }
        return isSkip;
    }

    public void copyFileWithRetry(Node file, Node folder, Map<String, Node> exists, boolean isLeftToRight, DriveUtil driveUtilToTempParam, DriveUtil driveUtilFromTempParam) {
        UploadParam param = UploadParam.builder().node(folder).name(file.getName()).build();
        if (isLeftToRight) {
            param.setName(driveUtilToTempParam.supportName(param.getName()));
        } else {
            param.setName(driveUtilFromTempParam.supportName(param.getName()));
        }
        try {
            if (this.isSkipFile(param, file, exists)) {
                this.addSkip();
                return;
            }
        }
        catch (Exception e) {
            file.setMsg(StringUtil.getMsg(e));
            file.setTrace(StringUtil.getTrace(e));
            this.addError(file, true);
            return;
        }
        this.workerPool.submit(() -> {
            boolean released;
            boolean released2;
            if (this.result.isCancel()) {
                return;
            }
            boolean isWarn = false;
            DriveUtil driveUtilFromTemp = null;
            DriveUtil driveUtilToTemp = null;
            try {
                file.setMsg("Ready copy");
                this.result.getRunningFilesMap().put(file.getId(), file);
                driveUtilFromTemp = this.srcPool.borrow();
                driveUtilToTemp = this.dstPool.borrow();
                Exception ex = null;
                Long firstSize = file.getSize();
                int sleepSeconds = 1;
                for (int attempt = 1; attempt <= 1; ++attempt) {
                    try {
                        Node uploadResNode = null;
                        Exception fex = null;
                        boolean driveUtilFromTempClosed = false;
                        boolean driveUtilToTempClosed = false;
                        try {
                            if (isLeftToRight) {
                                file.setMsg("Ready download \u2192");
                                result = driveUtilFromTemp.download(DownloadParam.builder().node(file).build());
                                result.setDriveUtil(driveUtilFromTemp);
                                param.setResult(result);
                                file.setMsg("Ready upload \u2192");
                                uploadResNode = driveUtilToTemp.upload(param);
                                driveUtilFromTempClosed = result.getDriveUtil() == null;
                            } else {
                                file.setMsg("Ready download \u2190");
                                result = driveUtilToTemp.download(DownloadParam.builder().node(file).build());
                                result.setDriveUtil(driveUtilToTemp);
                                param.setResult(result);
                                file.setMsg("Ready upload \u2190");
                                uploadResNode = driveUtilFromTemp.upload(param);
                                boolean bl = driveUtilToTempClosed = result.getDriveUtil() == null;
                            }
                            if (uploadResNode == null) {
                                throw new Exception("Upload result is null:" + param.getName());
                            }
                        }
                        finally {
                            if (!driveUtilToTempClosed) {
                                try {
                                    driveUtilToTemp.finish();
                                }
                                catch (Exception e) {
                                    fex = e;
                                }
                            }
                            if (!driveUtilFromTempClosed) {
                                try {
                                    driveUtilFromTemp.finish();
                                }
                                catch (Exception e) {
                                    fex = e;
                                }
                            }
                        }
                        if (fex != null) {
                            file.setMsg("Failed to finish:" + StringUtil.getMsg(fex));
                            --attempt;
                            continue;
                        }
                        this.addSuccess();
                        Long lastSize = uploadResNode.getSize();
                        if (firstSize != null && lastSize != null) {
                            this.addCurSize(lastSize);
                            this.changeSumSize(lastSize - firstSize);
                        }
                        if (firstSize == null && lastSize != null) {
                            this.addSumSize(lastSize);
                            this.addCurSize(lastSize);
                        }
                        if (firstSize != null && lastSize == null) {
                            this.addCurSize(firstSize);
                        }
                        ex = null;
                        break;
                    }
                    catch (CancelTaskException | NotRetryException | StopTaskException e) {
                        ex = e;
                        isWarn = true;
                        break;
                    }
                    catch (Exception e) {
                        boolean isLimited;
                        logger.error(StringUtil.nowDate() + "_" + this.tid + " File transfer error: " + param.getName() + "\uff0c" + e.toString());
                        ex = e;
                        boolean bl = isWarn = driveUtilToTemp.isWarning(e) || driveUtilFromTemp.isWarning(e);
                        if (isWarn) break;
                        boolean bl2 = isLimited = driveUtilToTemp.isLimited(e) || driveUtilFromTemp.isLimited(e);
                        if (isLimited) {
                            int finalSeconds = Math.min(sleepSeconds *= 2, 3);
                            file.setMsg("attempt:" + attempt + ",sleepSeconds:" + finalSeconds + ":" + StringUtil.getMsg(e));
                            for (int i = 0; i < finalSeconds; ++i) {
                                if (i % 3 == 0) {
                                    this.refreshProgress();
                                }
                                this.sleep(1000);
                            }
                            --attempt;
                            continue;
                        }
                        this.sleep(300);
                    }
                }
                if (ex != null) {
                    throw ex;
                }
                this.result.getRunningFilesMap().remove(file.getId());
            }
            catch (Throwable e) {
                boolean released3;
                boolean released4;
                try {
                    this.checkTaskError(e);
                    file.setMsg("Failed to copy file:" + param.getName() + "," + StringUtil.getMsg(e));
                    file.setTrace(StringUtil.getTrace(e));
                    this.addError(file, isWarn);
                    this.result.getRunningFilesMap().remove(file.getId());
                }
                catch (Throwable throwable) {
                    boolean released5;
                    this.result.getRunningFilesMap().remove(file.getId());
                    if (driveUtilToTemp != null && !(released5 = this.dstPool.release(driveUtilToTemp))) {
                        logger.error(StringUtil.nowDate() + "_" + this.tid + " Failed to release driveUtilToTemp(dstPool)");
                    }
                    if (driveUtilFromTemp != null && !(released5 = this.srcPool.release(driveUtilFromTemp))) {
                        logger.error(StringUtil.nowDate() + "_" + this.tid + " Failed to release driveUtilFromTemp(srcPool)");
                    }
                    throw throwable;
                }
                if (driveUtilToTemp != null && !(released4 = this.dstPool.release(driveUtilToTemp))) {
                    logger.error(StringUtil.nowDate() + "_" + this.tid + " Failed to release driveUtilToTemp(dstPool)");
                }
                if (driveUtilFromTemp != null && !(released3 = this.srcPool.release(driveUtilFromTemp))) {
                    logger.error(StringUtil.nowDate() + "_" + this.tid + " Failed to release driveUtilFromTemp(srcPool)");
                }
            }
            if (driveUtilToTemp != null && !(released2 = this.dstPool.release(driveUtilToTemp))) {
                logger.error(StringUtil.nowDate() + "_" + this.tid + " Failed to release driveUtilToTemp(dstPool)");
            }
            if (driveUtilFromTemp != null && !(released = this.srcPool.release(driveUtilFromTemp))) {
                logger.error(StringUtil.nowDate() + "_" + this.tid + " Failed to release driveUtilFromTemp(srcPool)");
            }
        });
    }

    public void checkTaskError(Throwable t) {
        String msg = StringUtil.getMsg(t);
        if (t instanceof Exception) {
            if (msg.contains("storageQuotaExceeded")) {
                this.result.setCancelMsg("Insufficient drive space");
            } else if (msg.contains("insufficient_space")) {
                this.result.setCancelMsg("Insufficient drive space");
            }
        } else {
            this.result.setCancelMsg(msg);
        }
    }

    public CreateFolderResult createDirectoryWithRetry(MkdirParam param, Map<String, Node> exists, boolean isLeftToRight, DriveUtil driveUtilToTemp, DriveUtil driveUtilFromTemp) {
        Node parentNode = param.getNode();
        this.setCurNodeAndMsg(parentNode, "Creating folder:" + param.getName());
        if (isLeftToRight) {
            param.setName(driveUtilToTemp.supportName(param.getName()));
        } else {
            param.setName(driveUtilFromTemp.supportName(param.getName()));
        }
        Node existNode = exists.get(param.getName().toLowerCase());
        if (existNode != null) {
            if (existNode.isDir()) {
                this.addSkip();
                existNode.setParent(parentNode);
                return new CreateFolderResult(existNode, false);
            }
            String msg = "Name is already in use: " + param.getName() + "\u2192" + existNode.getName();
            if (parentNode == null) {
                parentNode = Node.builder().name("root").build();
            }
            parentNode.setMsg(msg);
            parentNode.setTrace(new Gson().toJson((Object)existNode));
            this.addError(parentNode, true);
            return new CreateFolderResult(null, null);
        }
        boolean isWarn = false;
        Throwable ex = null;
        int sleepSeconds = 1;
        for (int attempt = 1; attempt <= 1; ++attempt) {
            DriveUtil curDriveUtil = null;
            try {
                Node newNode;
                if (isLeftToRight) {
                    curDriveUtil = driveUtilToTemp;
                    newNode = driveUtilToTemp.mkdir(param);
                } else {
                    curDriveUtil = driveUtilFromTemp;
                    newNode = driveUtilFromTemp.mkdir(param);
                }
                if (newNode == null) {
                    throw new Exception("The folder creation result is empty.");
                }
                this.addSuccess();
                newNode.setParent(parentNode);
                return new CreateFolderResult(newNode, true);
            }
            catch (CancelTaskException | NotRetryException | StopTaskException e) {
                ex = e;
                break;
            }
            catch (Throwable e) {
                Exception ee;
                logger.error(StringUtil.nowDate() + "_" + this.tid + " Folder creation error: " + param.getName() + "\uff0c" + e.toString());
                ex = e;
                if (!(e instanceof Exception) || (isWarn = curDriveUtil.isWarning(ee = (Exception)e))) break;
                if (curDriveUtil.isLimited(ee)) {
                    int finalSeconds = Math.min(sleepSeconds *= 2, 3);
                    if (parentNode != null) {
                        parentNode.setMsg("attempt:" + attempt + ",sleepSeconds:" + finalSeconds + ":" + StringUtil.getMsg(ee));
                    }
                    for (int i = 0; i < finalSeconds; ++i) {
                        if (i % 3 == 0) {
                            this.refreshProgress();
                        }
                        this.sleep(1000);
                    }
                    --attempt;
                    continue;
                }
                this.sleep(300);
                continue;
            }
        }
        if (parentNode == null) {
            parentNode = Node.builder().name("root").build();
        }
        this.checkTaskError(ex);
        parentNode.setMsg("Failed to create folder:" + param.getName() + "," + StringUtil.getMsg(ex));
        parentNode.setTrace(StringUtil.getTrace(ex));
        this.addError(parentNode, isWarn);
        return new CreateFolderResult(null, null);
    }

    public Map<String, Node> nodesToMap(List<Node> nodes) {
        return nodes.stream().collect(Collectors.toMap(node -> node.getName().toLowerCase(), node -> node, (existing, replacement) -> existing));
    }

    public List<Node> listAll(Node node, boolean isLeftToRight, DriveUtil driveUtilToTemp, DriveUtil driveUtilFromTemp, boolean needSort) throws Exception {
        String msg = "Listing all";
        this.setCurNodeAndMsg(node, msg);
        ListParam param = ListParam.builder().node(node).build();
        ListAllError listAllError = errorMsg -> {
            if (!this.isListDone) {
                this.setCurNodeAndMsg(node, msg + ":" + errorMsg);
            }
        };
        if (isLeftToRight) {
            return driveUtilToTemp.listAll(param, this.toNodeHasSameName, needSort, listAllError).getNodes();
        }
        return driveUtilFromTemp.listAll(param, this.fromNodeHasSameName, needSort, listAllError).getNodes();
    }

    public abstract void run() throws Exception;

    public static BaseTask create(ExecTaskParam execTaskParam) throws Exception {
        switch (execTaskParam.getTaskRun().getType()) {
            case "copy": {
                return new CopyTask(execTaskParam);
            }
            case "tran": {
                return new TranTask(execTaskParam);
            }
            case "sync": {
                return new SyncTask(execTaskParam);
            }
            case "backup": {
                return new BackupTask(execTaskParam);
            }
        }
        throw new StopTaskException("Task type error.");
    }

    private boolean driveHasSameName(String type) {
        return "GoogleDrive".equals(type);
    }

    public void taskThrowable(Throwable e) {
        this.checkTaskError(e);
        Node tempNode = this.nodeFrom == null ? Node.builder().name("root").build() : this.nodeFrom;
        tempNode.setMsg("Error to copy:" + tempNode.getName() + "," + StringUtil.getMsg(e));
        tempNode.setTrace(StringUtil.getTrace(e));
        boolean isWarn = false;
        if (this.nodeFrom != null && this.nodeFrom.getWarn() != null && this.nodeFrom.getWarn().booleanValue()) {
            isWarn = true;
        }
        if (this.nodeTo != null && this.nodeTo.getWarn() != null && this.nodeTo.getWarn().booleanValue()) {
            isWarn = true;
        }
        if (!isWarn && StringUtil.getMsg(e).contains(" conflicts with ")) {
            isWarn = true;
        }
        this.addError(tempNode, isWarn);
    }

    public void releaseDrive(DriveUtil driveUtilToTemp, DriveUtil driveUtilFromTemp) {
        boolean released;
        if (driveUtilToTemp != null && !(released = this.dstPoolList.release(driveUtilToTemp))) {
            logger.error(StringUtil.nowDate() + "_" + this.tid + " Failed to release driveUtilToTemp(dstPoolList)");
        }
        if (driveUtilFromTemp != null && !(released = this.srcPoolList.release(driveUtilFromTemp))) {
            logger.error(StringUtil.nowDate() + "_" + this.tid + " Failed to release driveUtilFromTemp(srcPoolList)");
        }
    }

    public void waitListDone() {
        if (this.listPool instanceof ThreadPoolExecutor) {
            ThreadPoolExecutor tpe = (ThreadPoolExecutor)this.listPool;
            while (tpe.getCompletedTaskCount() != tpe.getTaskCount()) {
                this.sleep(1000);
            }
            this.listPool.shutdown();
            this.closeList();
        }
    }

    private String getNodeFullPath(Node node) {
        Object path = "";
        while (node != null) {
            path = "/" + node.getName() + (String)path;
            node = node.getParent();
        }
        return path;
    }

    public void checkNode(Node from, Node to) {
        if (this.fdid.equals(this.tdid)) {
            String sub;
            String fromPath = this.getNodeFullPath(from);
            String toPath = this.getNodeFullPath(to);
            if (toPath.startsWith(fromPath) && ((sub = toPath.substring(fromPath.length())).startsWith("/") || toPath.equals(fromPath))) {
                throw new CancelTaskException(fromPath + " conflicts with " + toPath);
            }
        }
    }
}

