/*
 * Decompiled with CFR 0.152.
 */
package tools.mv.backend.entity;

import com.google.gson.Gson;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import lombok.Generated;
import tools.mv.backend.model.TaskParam;
import tools.mv.backend.model.TaskRes;
import tools.mv.backend.model.TaskResult;
import tools.mv.backend.model.TaskRun;
import tools.mv.backend.task.TaskProgress;

@Entity
@Table(name="task")
public class Task {
    public static final String TYPE_COPY = "copy";
    public static final String TYPE_TRAN = "tran";
    public static final String TYPE_SYNC = "sync";
    public static final String TYPE_BACKUP = "backup";
    public static final String STATUS_CREATED = "Created";
    public static final String STATUS_PENDING = "Pending";
    public static final String STATUS_RUNNING = "Running";
    public static final String STATUS_CANCELED = "Canceled";
    public static final String STATUS_SUCCESS = "Success";
    public static final String STATUS_FAILED = "Failed";
    public static final String STATUS_WARNING = "Warning";
    public static final String STATUS_ERROR = "Error";
    @Id
    private String id;
    @Column(nullable=false)
    private String type;
    @Column(nullable=false)
    private Long ctime;
    @Column(nullable=false)
    private Long mtime;
    @Column(nullable=false, columnDefinition="TEXT")
    private String param;
    @Column(nullable=false, columnDefinition="TEXT")
    private String result;
    @Column(nullable=false)
    private String status;
    @Column(nullable=false, columnDefinition="TEXT")
    private String msg;
    @Column(nullable=false)
    private String fdid;
    @Column(nullable=false)
    private String tdid;

    public TaskParam getTaskParam() {
        return (TaskParam)new Gson().fromJson(this.param, TaskParam.class);
    }

    public TaskResult getTaskResult() {
        return (TaskResult)new Gson().fromJson(this.result, TaskResult.class);
    }

    public TaskRes toTaskRes() {
        return TaskRes.builder().id(this.id).type(this.type).ctime(this.ctime).mtime(this.mtime).param(this.getTaskParam()).result(this.getTaskResult().toTaskResultLess()).status(this.status).msg(this.msg).fdid(this.fdid).tdid(this.tdid).build();
    }

    public TaskRun toTaskRun(TaskResult result, TaskProgress progress) {
        return TaskRun.builder().id(this.id).type(this.type).ctime(this.ctime).mtime(this.mtime).param(this.getTaskParam()).result(result).status(this.status).msg(this.msg).fdid(this.fdid).tdid(this.tdid).progress(progress).build();
    }

    @Generated
    public static TaskBuilder builder() {
        return new TaskBuilder();
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public Long getCtime() {
        return this.ctime;
    }

    @Generated
    public Long getMtime() {
        return this.mtime;
    }

    @Generated
    public String getParam() {
        return this.param;
    }

    @Generated
    public String getResult() {
        return this.result;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public String getMsg() {
        return this.msg;
    }

    @Generated
    public String getFdid() {
        return this.fdid;
    }

    @Generated
    public String getTdid() {
        return this.tdid;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setCtime(Long ctime) {
        this.ctime = ctime;
    }

    @Generated
    public void setMtime(Long mtime) {
        this.mtime = mtime;
    }

    @Generated
    public void setParam(String param) {
        this.param = param;
    }

    @Generated
    public void setResult(String result) {
        this.result = result;
    }

    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @Generated
    public void setMsg(String msg) {
        this.msg = msg;
    }

    @Generated
    public void setFdid(String fdid) {
        this.fdid = fdid;
    }

    @Generated
    public void setTdid(String tdid) {
        this.tdid = tdid;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Task)) {
            return false;
        }
        Task other = (Task)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$ctime = this.getCtime();
        Long other$ctime = other.getCtime();
        if (this$ctime == null ? other$ctime != null : !((Object)this$ctime).equals(other$ctime)) {
            return false;
        }
        Long this$mtime = this.getMtime();
        Long other$mtime = other.getMtime();
        if (this$mtime == null ? other$mtime != null : !((Object)this$mtime).equals(other$mtime)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$param = this.getParam();
        String other$param = other.getParam();
        if (this$param == null ? other$param != null : !this$param.equals(other$param)) {
            return false;
        }
        String this$result = this.getResult();
        String other$result = other.getResult();
        if (this$result == null ? other$result != null : !this$result.equals(other$result)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$msg = this.getMsg();
        String other$msg = other.getMsg();
        if (this$msg == null ? other$msg != null : !this$msg.equals(other$msg)) {
            return false;
        }
        String this$fdid = this.getFdid();
        String other$fdid = other.getFdid();
        if (this$fdid == null ? other$fdid != null : !this$fdid.equals(other$fdid)) {
            return false;
        }
        String this$tdid = this.getTdid();
        String other$tdid = other.getTdid();
        return !(this$tdid == null ? other$tdid != null : !this$tdid.equals(other$tdid));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Task;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $ctime = this.getCtime();
        result = result * 59 + ($ctime == null ? 43 : ((Object)$ctime).hashCode());
        Long $mtime = this.getMtime();
        result = result * 59 + ($mtime == null ? 43 : ((Object)$mtime).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $param = this.getParam();
        result = result * 59 + ($param == null ? 43 : $param.hashCode());
        String $result = this.getResult();
        result = result * 59 + ($result == null ? 43 : $result.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $msg = this.getMsg();
        result = result * 59 + ($msg == null ? 43 : $msg.hashCode());
        String $fdid = this.getFdid();
        result = result * 59 + ($fdid == null ? 43 : $fdid.hashCode());
        String $tdid = this.getTdid();
        result = result * 59 + ($tdid == null ? 43 : $tdid.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Task(id=" + this.getId() + ", type=" + this.getType() + ", ctime=" + this.getCtime() + ", mtime=" + this.getMtime() + ", param=" + this.getParam() + ", result=" + this.getResult() + ", status=" + this.getStatus() + ", msg=" + this.getMsg() + ", fdid=" + this.getFdid() + ", tdid=" + this.getTdid() + ")";
    }

    @Generated
    public Task() {
    }

    @Generated
    public Task(String id, String type, Long ctime, Long mtime, String param, String result, String status, String msg, String fdid, String tdid) {
        this.id = id;
        this.type = type;
        this.ctime = ctime;
        this.mtime = mtime;
        this.param = param;
        this.result = result;
        this.status = status;
        this.msg = msg;
        this.fdid = fdid;
        this.tdid = tdid;
    }

    @Generated
    public static class TaskBuilder {
        @Generated
        private String id;
        @Generated
        private String type;
        @Generated
        private Long ctime;
        @Generated
        private Long mtime;
        @Generated
        private String param;
        @Generated
        private String result;
        @Generated
        private String status;
        @Generated
        private String msg;
        @Generated
        private String fdid;
        @Generated
        private String tdid;

        @Generated
        TaskBuilder() {
        }

        @Generated
        public TaskBuilder id(String id) {
            this.id = id;
            return this;
        }

        @Generated
        public TaskBuilder type(String type) {
            this.type = type;
            return this;
        }

        @Generated
        public TaskBuilder ctime(Long ctime) {
            this.ctime = ctime;
            return this;
        }

        @Generated
        public TaskBuilder mtime(Long mtime) {
            this.mtime = mtime;
            return this;
        }

        @Generated
        public TaskBuilder param(String param) {
            this.param = param;
            return this;
        }

        @Generated
        public TaskBuilder result(String result) {
            this.result = result;
            return this;
        }

        @Generated
        public TaskBuilder status(String status) {
            this.status = status;
            return this;
        }

        @Generated
        public TaskBuilder msg(String msg) {
            this.msg = msg;
            return this;
        }

        @Generated
        public TaskBuilder fdid(String fdid) {
            this.fdid = fdid;
            return this;
        }

        @Generated
        public TaskBuilder tdid(String tdid) {
            this.tdid = tdid;
            return this;
        }

        @Generated
        public Task build() {
            return new Task(this.id, this.type, this.ctime, this.mtime, this.param, this.result, this.status, this.msg, this.fdid, this.tdid);
        }

        @Generated
        public String toString() {
            return "Task.TaskBuilder(id=" + this.id + ", type=" + this.type + ", ctime=" + this.ctime + ", mtime=" + this.mtime + ", param=" + this.param + ", result=" + this.result + ", status=" + this.status + ", msg=" + this.msg + ", fdid=" + this.fdid + ", tdid=" + this.tdid + ")";
        }
    }
}

