/*
 * Decompiled with CFR 0.152.
 */
package tools.mv.backend.entity;

import com.google.gson.Gson;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import lombok.Generated;
import tools.mv.backend.model.DriveAuth;
import tools.mv.backend.model.DriveRes;

@Entity
@Table(name="drive")
public class Drive {
    public static final String TYPE_LOCAL_DRIVE = "LocalDrive";
    public static final String TYPE_FTP = "FTP";
    public static final String TYPE_SFTP = "SFTP";
    public static final String TYPE_WEBDAV = "WebDAV";
    public static final String TYPE_GOOGLE_DRIVE = "GoogleDrive";
    public static final String TYPE_ONE_DRIVE = "OneDrive";
    public static final String TYPE_DROPBOX = "Dropbox";
    public static final String TYPE_P_CLOUD = "PCloud";
    public static final String TYPE_BOX = "Box";
    public static final String TYPE_MEDIAFIRE = "MediaFire";
    @Id
    private String id;
    @Column(nullable=false)
    private String type;
    @Column(nullable=false)
    private String name;
    @Column(nullable=false)
    private Long ctime;
    @Column(nullable=false)
    private Long mtime;
    @Column(nullable=false, columnDefinition="TEXT")
    private String auth;
    @Column(nullable=false, columnDefinition="TEXT")
    private String info;

    public DriveAuth getDriveAuth() {
        return (DriveAuth)new Gson().fromJson(this.auth, DriveAuth.class);
    }

    public DriveRes toDriveRes() {
        return DriveRes.builder().id(this.id).type(this.type).name(this.name).ctime(this.ctime).mtime(this.mtime).build();
    }

    @Generated
    public static DriveBuilder builder() {
        return new DriveBuilder();
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Long getCtime() {
        return this.ctime;
    }

    @Generated
    public Long getMtime() {
        return this.mtime;
    }

    @Generated
    public String getAuth() {
        return this.auth;
    }

    @Generated
    public String getInfo() {
        return this.info;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setCtime(Long ctime) {
        this.ctime = ctime;
    }

    @Generated
    public void setMtime(Long mtime) {
        this.mtime = mtime;
    }

    @Generated
    public void setAuth(String auth) {
        this.auth = auth;
    }

    @Generated
    public void setInfo(String info) {
        this.info = info;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Drive)) {
            return false;
        }
        Drive other = (Drive)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$ctime = this.getCtime();
        Long other$ctime = other.getCtime();
        if (this$ctime == null ? other$ctime != null : !((Object)this$ctime).equals(other$ctime)) {
            return false;
        }
        Long this$mtime = this.getMtime();
        Long other$mtime = other.getMtime();
        if (this$mtime == null ? other$mtime != null : !((Object)this$mtime).equals(other$mtime)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$auth = this.getAuth();
        String other$auth = other.getAuth();
        if (this$auth == null ? other$auth != null : !this$auth.equals(other$auth)) {
            return false;
        }
        String this$info = this.getInfo();
        String other$info = other.getInfo();
        return !(this$info == null ? other$info != null : !this$info.equals(other$info));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Drive;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $ctime = this.getCtime();
        result = result * 59 + ($ctime == null ? 43 : ((Object)$ctime).hashCode());
        Long $mtime = this.getMtime();
        result = result * 59 + ($mtime == null ? 43 : ((Object)$mtime).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $auth = this.getAuth();
        result = result * 59 + ($auth == null ? 43 : $auth.hashCode());
        String $info = this.getInfo();
        result = result * 59 + ($info == null ? 43 : $info.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Drive(id=" + this.getId() + ", type=" + this.getType() + ", name=" + this.getName() + ", ctime=" + this.getCtime() + ", mtime=" + this.getMtime() + ", auth=" + this.getAuth() + ", info=" + this.getInfo() + ")";
    }

    @Generated
    public Drive() {
    }

    @Generated
    public Drive(String id, String type, String name, Long ctime, Long mtime, String auth, String info) {
        this.id = id;
        this.type = type;
        this.name = name;
        this.ctime = ctime;
        this.mtime = mtime;
        this.auth = auth;
        this.info = info;
    }

    @Generated
    public static class DriveBuilder {
        @Generated
        private String id;
        @Generated
        private String type;
        @Generated
        private String name;
        @Generated
        private Long ctime;
        @Generated
        private Long mtime;
        @Generated
        private String auth;
        @Generated
        private String info;

        @Generated
        DriveBuilder() {
        }

        @Generated
        public DriveBuilder id(String id) {
            this.id = id;
            return this;
        }

        @Generated
        public DriveBuilder type(String type) {
            this.type = type;
            return this;
        }

        @Generated
        public DriveBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public DriveBuilder ctime(Long ctime) {
            this.ctime = ctime;
            return this;
        }

        @Generated
        public DriveBuilder mtime(Long mtime) {
            this.mtime = mtime;
            return this;
        }

        @Generated
        public DriveBuilder auth(String auth) {
            this.auth = auth;
            return this;
        }

        @Generated
        public DriveBuilder info(String info) {
            this.info = info;
            return this;
        }

        @Generated
        public Drive build() {
            return new Drive(this.id, this.type, this.name, this.ctime, this.mtime, this.auth, this.info);
        }

        @Generated
        public String toString() {
            return "Drive.DriveBuilder(id=" + this.id + ", type=" + this.type + ", name=" + this.name + ", ctime=" + this.ctime + ", mtime=" + this.mtime + ", auth=" + this.auth + ", info=" + this.info + ")";
        }
    }
}

