/*
 * Decompiled with CFR 0.152.
 */
package tools.mv.backend.drive;

import cn.hutool.crypto.digest.DigestUtil;
import com.github.sardine.DavQuota;
import com.github.sardine.DavResource;
import com.github.sardine.Sardine;
import com.github.sardine.SardineFactory;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.client.ClientProtocolException;
import tools.mv.backend.drive.BaseDrive;
import tools.mv.backend.drive.DriveParent;
import tools.mv.backend.model.AppDrive;
import tools.mv.backend.model.AuthParam;
import tools.mv.backend.model.DeleteParam;
import tools.mv.backend.model.DownloadParam;
import tools.mv.backend.model.DownloadResult;
import tools.mv.backend.model.DriveAuth;
import tools.mv.backend.model.DriveInfo;
import tools.mv.backend.model.ListParam;
import tools.mv.backend.model.ListResult;
import tools.mv.backend.model.MkdirParam;
import tools.mv.backend.model.Node;
import tools.mv.backend.model.RenameParam;
import tools.mv.backend.model.UploadParam;
import tools.mv.backend.model.WebDAVParam;
import tools.mv.backend.util.ProgInputStream;

public class WebDAV
extends DriveParent
implements BaseDrive {
    private WebDAVParam webDAVParam;
    private Sardine client;

    public WebDAV(AppDrive appDrive) {
        super(appDrive);
        DriveAuth auth = appDrive.getAuth();
        if (auth != null) {
            this.initClient(auth.getWebdav());
        }
    }

    private void initClient(WebDAVParam webdav) {
        this.webDAVParam = webdav;
        this.client = SardineFactory.begin((String)webdav.getUsername(), (String)webdav.getPassword());
    }

    @Override
    public DriveAuth callback(AuthParam param) throws Exception {
        WebDAVParam webdav = param.getWebdav();
        Object url = webdav.getUrl();
        if (!((String)url).endsWith("/")) {
            url = (String)url + "/";
            webdav.setUrl((String)url);
        }
        this.initClient(webdav);
        this.client.exists((String)url);
        String uuid = DigestUtil.md5Hex((String)((String)url + webdav.getUsername()));
        return DriveAuth.builder().uuid(uuid).webdav(webdav).build();
    }

    @Override
    public DriveInfo info() throws Exception {
        DriveInfo info = new DriveInfo();
        DavQuota quota = this.client.getQuota(this.webDAVParam.getUrl());
        if (quota != null) {
            long used = quota.getQuotaUsedBytes();
            long total = quota.getQuotaAvailableBytes();
            info.setUsed(used);
            if (total > 0L) {
                info.setTotal(used + total);
            }
        }
        info.setWebdav(this.webDAVParam.toInfo());
        return info;
    }

    private String getPrefix(String fullUrl) throws Exception {
        URL url = new URL(fullUrl);
        return url.getProtocol() + "://" + url.getHost() + (String)(url.getPort() != -1 ? ":" + url.getPort() : "");
    }

    @Override
    public ListResult list(ListParam param) throws Exception {
        String url = this.folderId(this.webDAVParam.getUrl(), param.getNode());
        String prefix = this.getPrefix(url);
        ArrayList<Node> nodes = new ArrayList<Node>();
        List list = this.client.list(url);
        for (int i = 1; i < list.size(); ++i) {
            DavResource resource = (DavResource)list.get(i);
            boolean isDir = resource.isDirectory();
            Node node = new Node();
            node.setId(prefix + resource.getHref().toString());
            node.setType(isDir ? "folder" : "file");
            node.setName(resource.getName());
            node.setDir(isDir);
            if (!isDir) {
                node.setSize(resource.getContentLength());
            }
            node.setTime(resource.getModified().getTime());
            nodes.add(node);
        }
        return ListResult.builder().nodes(nodes).build();
    }

    private String encode(String name) throws UnsupportedEncodingException {
        return URLEncoder.encode(name, "UTF-8").replace("+", "%20");
    }

    @Override
    public Node mkdir(MkdirParam param) throws Exception {
        String url = this.folderId(this.webDAVParam.getUrl(), param.getNode());
        String name = param.getName();
        String id = url + this.encode(name) + "/";
        this.client.createDirectory(id);
        return this.createMkdirNode(id, name);
    }

    @Override
    public DownloadResult download(DownloadParam param) throws Exception {
        Node node = param.getNode();
        this.in = this.client.get(node.getId());
        return DownloadResult.builder().node(node).in(this.in).build();
    }

    @Override
    public Node upload(UploadParam param) throws Exception {
        String url = this.folderId(this.webDAVParam.getUrl(), param.getNode());
        String name = param.getName();
        String id = url + this.encode(name);
        DownloadResult result = param.getResult();
        InputStream in = result.getIn();
        Node fromNode = result.getNode();
        ProgInputStream stream = new ProgInputStream(in, fromNode, this);
        this.client.put(id, (InputStream)stream);
        return this.createUploadNode(id, name, stream.getSum());
    }

    @Override
    public Node rename(RenameParam param) throws Exception {
        String newUrl;
        Node node = param.getNode();
        String url = node.getId();
        String name = param.getName();
        if (node.isDir() && url.endsWith("/")) {
            String temp = url.substring(0, url.length() - 1);
            newUrl = temp.substring(0, temp.lastIndexOf("/") + 1) + this.encode(name) + "/";
        } else {
            newUrl = url.substring(0, url.lastIndexOf("/") + 1) + this.encode(name);
        }
        if (this.client.exists(newUrl)) {
            throw new Exception("Name already exists: " + name);
        }
        this.client.move(url, newUrl);
        return this.createMkdirNode(newUrl, name);
    }

    @Override
    public void delete(DeleteParam param) throws Exception {
        Node node = param.getNode();
        String url = node.getId();
        if (!this.client.exists(url)) {
            throw new Exception("Resource to delete does not exist: " + node.getName());
        }
        this.client.delete(url);
    }

    @Override
    public boolean expire(Exception e) {
        return false;
    }

    @Override
    public DriveAuth refresh() throws Exception {
        return null;
    }

    @Override
    public void newAuth(DriveAuth auth) throws Exception {
    }

    @Override
    public void close() {
        if (this.client != null) {
            try {
                this.client.shutdown();
            }
            catch (Exception exception) {
            }
            finally {
                this.client = null;
            }
        }
        this.webDAVParam = null;
    }

    @Override
    public boolean isLimited(Exception e) {
        return e instanceof ClientProtocolException;
    }
}

