/*
 * Decompiled with CFR 0.152.
 */
package tools.mv.backend.drive;

import cn.hutool.crypto.digest.DigestUtil;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.sftp.OpenMode;
import net.schmizz.sshj.sftp.RemoteFile;
import net.schmizz.sshj.sftp.RemoteResourceInfo;
import net.schmizz.sshj.sftp.SFTPClient;
import net.schmizz.sshj.sftp.SFTPException;
import net.schmizz.sshj.transport.verification.HostKeyVerifier;
import net.schmizz.sshj.transport.verification.PromiscuousVerifier;
import net.schmizz.sshj.userauth.keyprovider.KeyProvider;
import net.schmizz.sshj.userauth.password.PasswordFinder;
import net.schmizz.sshj.userauth.password.PasswordUtils;
import tools.mv.backend.drive.BaseDrive;
import tools.mv.backend.drive.DriveParent;
import tools.mv.backend.model.AppDrive;
import tools.mv.backend.model.AuthParam;
import tools.mv.backend.model.DeleteParam;
import tools.mv.backend.model.DownloadParam;
import tools.mv.backend.model.DownloadResult;
import tools.mv.backend.model.DriveAuth;
import tools.mv.backend.model.DriveInfo;
import tools.mv.backend.model.ListParam;
import tools.mv.backend.model.ListResult;
import tools.mv.backend.model.MkdirParam;
import tools.mv.backend.model.Node;
import tools.mv.backend.model.RenameParam;
import tools.mv.backend.model.SFTPObject;
import tools.mv.backend.model.SFTPParam;
import tools.mv.backend.model.UploadParam;
import tools.mv.backend.util.StringUtil;

public class SFTP
extends DriveParent
implements BaseDrive {
    private SFTPParam sftpParam;
    private SSHClient sshClient;
    private SFTPClient sftpClient;

    public SFTP(AppDrive appDrive) throws Exception {
        super(appDrive);
        DriveAuth auth = appDrive.getAuth();
        if (auth != null) {
            this.initAuth(auth.getSftp());
        }
    }

    @Override
    public DriveAuth callback(AuthParam param) throws Exception {
        this.initAuth(param.getSftp());
        String uuid = DigestUtil.md5Hex((String)(this.sftpParam.getHost() + this.sftpParam.getPort() + this.sftpParam.getUsername()));
        return DriveAuth.builder().uuid(uuid).sftp(this.sftpParam).build();
    }

    @Override
    public DriveInfo info() {
        return DriveInfo.builder().sftp(this.sftpParam.toInfo()).build();
    }

    @Override
    public ListResult list(ListParam param) throws Exception {
        String id = this.folderId(this.sftpParam.getPath(), param.getNode());
        List files = this.sftpClient.ls(id);
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (RemoteResourceInfo file : files) {
            nodes.add(this.toNode(file));
        }
        return ListResult.builder().nodes(nodes).build();
    }

    private Node toNode(RemoteResourceInfo file) {
        boolean isDir = file.isDirectory();
        Node node = new Node();
        node.setId(file.getPath());
        node.setType(isDir ? "folder" : "file");
        node.setName(file.getName());
        node.setDir(isDir);
        if (!isDir) {
            node.setSize(file.getAttributes().getSize());
        }
        node.setTime(file.getAttributes().getMtime() * 1000L);
        return node;
    }

    @Override
    public Node mkdir(MkdirParam param) throws Exception {
        String name = param.getName();
        String path = this.fullPath(this.sftpParam.getPath(), param.getNode(), name);
        this.sftpClient.mkdir(path);
        return this.createMkdirNode(path, name);
    }

    @Override
    public DownloadResult download(DownloadParam param) throws Exception {
        Node node = param.getNode();
        RemoteFile remoteFile = this.sftpClient.open(node.getId(), EnumSet.of(OpenMode.READ));
        this.in = new RemoteFile.RemoteFileInputStream(remoteFile);
        return DownloadResult.builder().node(node).in(this.in).build();
    }

    @Override
    public Node upload(UploadParam param) throws Exception {
        String name = param.getName();
        String path = this.fullPath(this.sftpParam.getPath(), param.getNode(), name);
        RemoteFile remoteFile = this.sftpClient.open(path, EnumSet.of(OpenMode.WRITE, OpenMode.CREAT, OpenMode.TRUNC));
        this.out = new RemoteFile.RemoteFileOutputStream(remoteFile);
        DownloadResult result = param.getResult();
        long sum = this.readAndWrite(result.getIn(), this.out, result.getNode());
        return this.createUploadNode(path, name, sum);
    }

    @Override
    public Node rename(RenameParam param) throws Exception {
        Node node = param.getNode();
        String name = param.getName();
        String oldPath = node.getId();
        String parentPath = this.parentPath(oldPath);
        String newPath = this.createNewPath(parentPath, name);
        this.sftpClient.rename(oldPath, newPath);
        node.setId(newPath);
        node.setName(name);
        return node;
    }

    @Override
    public void delete(DeleteParam param) throws Exception {
        Node node = param.getNode();
        String path = node.getId();
        if (node.isDir()) {
            this.deleteDirectoryRecursive(path);
        } else {
            this.sftpClient.rm(path);
        }
    }

    private void deleteDirectoryRecursive(String dirPath) throws Exception {
        List entries = this.sftpClient.ls(dirPath);
        for (RemoteResourceInfo entry : entries) {
            String name = entry.getName();
            if (".".equals(name) || "..".equals(name)) continue;
            String childPath = dirPath + "/" + name;
            if (entry.isDirectory()) {
                this.deleteDirectoryRecursive(childPath);
                continue;
            }
            this.sftpClient.rm(childPath);
        }
        this.sftpClient.rmdir(dirPath);
    }

    @Override
    public boolean expire(Exception e) {
        return e instanceof SocketException;
    }

    @Override
    public DriveAuth refresh() throws Exception {
        SFTP.closeSFTP(this.sftpClient);
        SFTP.closeSSH(this.sshClient);
        this.initAuth(this.sftpParam);
        return null;
    }

    @Override
    public void newAuth(DriveAuth auth) throws Exception {
        SFTP.closeSFTP(this.sftpClient);
        SFTP.closeSSH(this.sshClient);
        this.initAuth(auth.getSftp());
    }

    private void initAuth(SFTPParam param) throws Exception {
        this.sftpParam = param;
        SFTPObject client = SFTP.getSSHClient(this.sftpParam);
        this.sshClient = client.getSshClient();
        this.sftpClient = client.getSftpClient();
    }

    @Override
    public void close() {
        SFTP.closeSFTP(this.sftpClient);
        SFTP.closeSSH(this.sshClient);
        this.sftpParam = null;
        this.sftpClient = null;
        this.sshClient = null;
    }

    @Override
    public boolean isLimited(Exception e) {
        if (e instanceof SFTPException) {
            String msg = StringUtil.getMsg(e);
            return msg.contains("Failure");
        }
        return false;
    }

    private static SFTPObject getSSHClient(SFTPParam param) throws Exception {
        SSHClient ssh = new SSHClient();
        try {
            ssh.addHostKeyVerifier((HostKeyVerifier)new PromiscuousVerifier());
            ssh.connect(param.getHost(), param.getPort());
            if (param.getPrivateKey() != null && !param.getPrivateKey().trim().isEmpty()) {
                KeyProvider keyProvider;
                if (param.getPassphrase() != null && !param.getPassphrase().isEmpty()) {
                    PasswordFinder passwordFinder = PasswordUtils.createOneOff((char[])param.getPassphrase().toCharArray());
                    keyProvider = ssh.loadKeys(param.getPrivateKey().trim(), null, passwordFinder);
                } else {
                    keyProvider = ssh.loadKeys(param.getPrivateKey().trim(), null, null);
                }
                ssh.authPublickey(param.getUsername(), new KeyProvider[]{keyProvider});
            } else {
                ssh.authPassword(param.getUsername(), param.getPassword());
            }
            SFTPClient sftp = ssh.newSFTPClient();
            try {
                if (param.getPath() == null || param.getPath().trim().isEmpty()) {
                    param.setPath(sftp.canonicalize("."));
                } else {
                    String path = param.getPath().trim();
                    String canonicalPath = sftp.canonicalize(path);
                    sftp.ls(canonicalPath);
                    param.setPath(canonicalPath);
                }
            }
            catch (Exception e) {
                SFTP.closeSFTP(sftp);
                throw e;
            }
            return new SFTPObject(ssh, sftp);
        }
        catch (Exception e) {
            SFTP.closeSSH(ssh);
            throw e;
        }
    }

    private static void closeSSH(SSHClient sshClient) {
        if (sshClient != null && sshClient.isConnected()) {
            try {
                sshClient.disconnect();
            }
            catch (Exception e) {
                System.err.println("SSH disconnect error: " + e.getMessage());
            }
        }
    }

    private static void closeSFTP(SFTPClient sftpClient) {
        if (sftpClient != null) {
            try {
                sftpClient.close();
            }
            catch (Exception e) {
                System.err.println("SFTP close error: " + e.getMessage());
            }
        }
    }
}

