/*
 * Decompiled with CFR 0.152.
 */
package tools.mv.backend.drive;

import com.pcloud.sdk.ApiClient;
import com.pcloud.sdk.Authenticators;
import com.pcloud.sdk.DataSource;
import com.pcloud.sdk.PCloudSdk;
import com.pcloud.sdk.ProgressListener;
import com.pcloud.sdk.RemoteFile;
import java.io.InputStream;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.apache.http.client.fluent.Form;
import org.apache.http.client.fluent.Request;
import org.json.JSONArray;
import org.json.JSONObject;
import tools.mv.backend.drive.BaseDrive;
import tools.mv.backend.drive.DriveParent;
import tools.mv.backend.model.AppDrive;
import tools.mv.backend.model.AppInfo;
import tools.mv.backend.model.AuthParam;
import tools.mv.backend.model.DeleteParam;
import tools.mv.backend.model.DownloadParam;
import tools.mv.backend.model.DownloadResult;
import tools.mv.backend.model.DriveAuth;
import tools.mv.backend.model.DriveInfo;
import tools.mv.backend.model.ListParam;
import tools.mv.backend.model.ListResult;
import tools.mv.backend.model.MkdirParam;
import tools.mv.backend.model.Node;
import tools.mv.backend.model.RenameParam;
import tools.mv.backend.model.UploadParam;
import tools.mv.backend.util.InputStreamDataSource;
import tools.mv.backend.util.StringUtil;

public class PCloud
extends DriveParent
implements BaseDrive {
    private static final String ROOT_ID = "0";
    private final AppInfo app;
    private DriveAuth auth;
    private ApiClient client;

    public PCloud(AppDrive appDrive) {
        super(appDrive);
        this.app = appDrive.getInfo();
        this.auth = appDrive.getAuth();
        if (this.auth != null) {
            this.client = this.createClient(this.auth.getAccess());
        }
    }

    public ApiClient createClient(String accessToken) {
        return PCloudSdk.newClientBuilder().authenticator(Authenticators.newOAuthAuthenticator((String)accessToken)).readTimeout(5L, TimeUnit.MINUTES).writeTimeout(5L, TimeUnit.MINUTES).connectTimeout(1L, TimeUnit.MINUTES).create();
    }

    @Override
    public String auth(AuthParam param) {
        return "https://my.pcloud.com/oauth2/authorize?client_id=" + this.app.getKey() + "&redirect_uri=" + this.app.getCallback() + "&response_type=code&state=" + param.getState() + "&force_reapprove=true";
    }

    @Override
    public DriveAuth callback(AuthParam param) throws Exception {
        String tokenUrl = "https://api.pcloud.com/oauth2_token";
        String responseStr = Request.Post((String)tokenUrl).connectTimeout(6000).socketTimeout(60000).bodyForm((Iterable)Form.form().add("client_id", this.app.getKey()).add("client_secret", this.app.getSecret()).add("code", param.getCode()).add("redirect_uri", this.app.getCallback()).add("grant_type", "authorization_code").build(), StandardCharsets.UTF_8).execute().returnContent().asString();
        JSONObject json = new JSONObject(responseStr);
        String uuid = String.valueOf(json.getLong("userid"));
        String access = json.getString("access_token");
        this.auth = DriveAuth.builder().uuid(uuid).access(access).build();
        this.client = this.createClient(access);
        return this.auth;
    }

    private JSONObject getResponseStr(String url) throws Exception {
        String responseStr = Request.Get((String)url).connectTimeout(6000).socketTimeout(60000).execute().returnContent().asString();
        return new JSONObject(responseStr);
    }

    @Override
    public DriveInfo info() throws Exception {
        String url = "https://api.pcloud.com/userinfo?access_token=" + this.auth.getAccess();
        JSONObject json = this.getResponseStr(url);
        String email = json.getString("email");
        Long used = json.getLong("usedquota");
        Long total = json.getLong("quota");
        return DriveInfo.builder().email(email).used(used).total(total).build();
    }

    @Override
    public ListResult list(ListParam param) throws Exception {
        String id = this.folderId(ROOT_ID, param.getNode());
        String url = "https://api.pcloud.com/listfolder?folderid=" + id + "&access_token=" + this.auth.getAccess();
        JSONObject json = this.getResponseStr(url);
        if (!json.has("metadata")) {
            throw new Exception(json.toString());
        }
        JSONArray arr = json.getJSONObject("metadata").getJSONArray("contents");
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (int i = 0; i < arr.length(); ++i) {
            nodes.add(this.toNode(arr.getJSONObject(i)));
        }
        return ListResult.builder().nodes(nodes).build();
    }

    private Node toNode(JSONObject obj) {
        boolean isDir = obj.getBoolean("isfolder");
        Node node = new Node();
        if (isDir) {
            node.setId(String.valueOf(obj.getLong("folderid")));
        } else {
            node.setId(String.valueOf(obj.getLong("fileid")));
        }
        node.setType(isDir ? "folder" : "file");
        node.setName(obj.getString("name"));
        node.setDir(isDir);
        if (!isDir) {
            node.setSize(obj.getLong("size"));
        }
        node.setTime(this.getTime(obj.getString("modified")));
        return node;
    }

    private Node toNode(RemoteFile file) {
        boolean isDir = file.isFolder();
        Node node = new Node();
        node.setId(file.id());
        node.setType(isDir ? "folder" : "file");
        node.setName(file.name());
        node.setDir(isDir);
        if (!isDir) {
            node.setSize(file.size());
        }
        node.setTime(file.lastModified().toInstant().toEpochMilli());
        return node;
    }

    private long getTime(String str) {
        ZonedDateTime zdt = ZonedDateTime.parse(str, DateTimeFormatter.RFC_1123_DATE_TIME);
        return zdt.toInstant().toEpochMilli();
    }

    @Override
    public Node mkdir(MkdirParam param) throws Exception {
        String id = this.folderId(ROOT_ID, param.getNode());
        String name = param.getName();
        String encodeName = URLEncoder.encode(name, "UTF-8");
        String url = "https://api.pcloud.com/createfolder?access_token=" + this.auth.getAccess() + "&folderid=" + id + "&name=" + encodeName;
        JSONObject json = this.getResponseStr(url);
        if (json.has("metadata")) {
            return this.toNode(json.getJSONObject("metadata"));
        }
        throw new Exception(json.toString());
    }

    @Override
    public DownloadResult download(DownloadParam param) throws Exception {
        Node node = param.getNode();
        String url = "https://api.pcloud.com/getfilelink?fileid=" + node.getId() + "&access_token=" + this.auth.getAccess();
        JSONObject json = this.getResponseStr(url);
        String path = json.getString("path");
        String hosts = json.getJSONArray("hosts").getString(0);
        this.in = this.getInputStreamFromUrl("https://" + hosts + path, null);
        return DownloadResult.builder().node(node).in(this.in).build();
    }

    @Override
    public Node upload(UploadParam param) throws Exception {
        String id = this.folderId(ROOT_ID, param.getNode());
        String name = param.getName();
        DownloadResult result = param.getResult();
        InputStream in = result.getIn();
        final Node fromNode = result.getNode();
        Long time = fromNode.getTime();
        Date date = time == null ? null : new Date(time);
        ProgressListener listener = new ProgressListener(){

            public void onProgress(long done, long total) {
                PCloud.this.setUploadMsg(fromNode, done);
            }
        };
        RemoteFile file = (RemoteFile)this.client.createFile(Long.parseLong(id), name, (DataSource)new InputStreamDataSource(in, fromNode.getSize()), date, listener).execute();
        return this.toNode(file);
    }

    @Override
    public Node rename(RenameParam param) throws Exception {
        Node node = param.getNode();
        String id = node.getId();
        String name = param.getName();
        String encodeName = URLEncoder.encode(name, "UTF-8");
        String url = node.isDir() ? "https://api.pcloud.com/renamefolder?access_token=" + this.auth.getAccess() + "&folderid=" + id + "&toname=" + encodeName : "https://api.pcloud.com/renamefile?access_token=" + this.auth.getAccess() + "&fileid=" + id + "&toname=" + encodeName;
        JSONObject json = this.getResponseStr(url);
        if (json.has("metadata")) {
            return this.toNode(json.getJSONObject("metadata"));
        }
        throw new Exception("Rename failed: " + String.valueOf(json));
    }

    @Override
    public void delete(DeleteParam param) throws Exception {
        Node node = param.getNode();
        String id = node.getId();
        String url = node.isDir() ? "https://api.pcloud.com/deletefolderrecursive?access_token=" + this.auth.getAccess() + "&folderid=" + id : "https://api.pcloud.com/deletefile?access_token=" + this.auth.getAccess() + "&fileid=" + id;
        JSONObject json = this.getResponseStr(url);
        if (json.getInt("result") != 0) {
            throw new Exception("Delete failed: " + String.valueOf(json));
        }
    }

    @Override
    public boolean needSize() {
        return true;
    }

    @Override
    public boolean expire(Exception e) {
        return false;
    }

    @Override
    public DriveAuth refresh() throws Exception {
        return null;
    }

    @Override
    public void newAuth(DriveAuth auth) throws Exception {
    }

    @Override
    public void close() {
        if (this.client != null) {
            this.client.shutdown();
            this.client = null;
        }
        this.auth = null;
    }

    @Override
    public boolean isWarning(Exception e) {
        String msg = StringUtil.getMsg(e);
        return msg.contains("2005") && msg.contains("Directory does not exist");
    }
}

