/*
 * Decompiled with CFR 0.152.
 */
package tools.mv.backend.drive;

import com.auth0.jwt.JWT;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.google.gson.JsonPrimitive;
import com.microsoft.graph.authentication.IAuthenticationProvider;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.GraphFatalServiceException;
import com.microsoft.graph.models.Drive;
import com.microsoft.graph.models.DriveItem;
import com.microsoft.graph.models.Folder;
import com.microsoft.graph.models.Quota;
import com.microsoft.graph.models.User;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.DriveItemCollectionPage;
import com.microsoft.graph.requests.DriveItemCollectionRequest;
import com.microsoft.graph.requests.DriveItemCollectionRequestBuilder;
import com.microsoft.graph.requests.DriveItemCollectionResponse;
import com.microsoft.graph.requests.GraphServiceClient;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.fluent.Form;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.FileEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.jetbrains.annotations.NotNull;
import org.json.JSONObject;
import tools.mv.backend.drive.BaseDrive;
import tools.mv.backend.drive.DriveParent;
import tools.mv.backend.model.AppDrive;
import tools.mv.backend.model.AppInfo;
import tools.mv.backend.model.AuthParam;
import tools.mv.backend.model.DeleteParam;
import tools.mv.backend.model.DownloadParam;
import tools.mv.backend.model.DownloadResult;
import tools.mv.backend.model.DriveAuth;
import tools.mv.backend.model.DriveInfo;
import tools.mv.backend.model.ListParam;
import tools.mv.backend.model.ListResult;
import tools.mv.backend.model.MkdirParam;
import tools.mv.backend.model.Node;
import tools.mv.backend.model.RenameParam;
import tools.mv.backend.model.UploadParam;
import tools.mv.backend.util.DriveUtil;
import tools.mv.backend.util.ProgInputStreamEntity;
import tools.mv.backend.util.StringUtil;

public class OneDrive
extends DriveParent
implements BaseDrive {
    private static final String SCOPE = "openid profile email offline_access Files.ReadWrite.All User.Read";
    private static final long CHUNK_SIZE = 0x6400000L;
    private static final String ROOT_ID = "root";
    private final AppInfo app;
    private DriveAuth auth;
    private GraphServiceClient<Request> client;
    private boolean refreshedFlag = false;
    private boolean curIsLimited = false;

    public OneDrive(AppDrive appDrive) {
        super(appDrive);
        this.app = appDrive.getInfo();
        this.auth = appDrive.getAuth();
        if (this.auth != null) {
            this.client = this.createClient(this.auth.getAccess());
        }
    }

    public GraphServiceClient<Request> createClient(final String accessToken) {
        IAuthenticationProvider authProvider = new IAuthenticationProvider(){

            @NotNull
            public CompletableFuture<String> getAuthorizationTokenAsync(@NotNull URL requestUrl) {
                return CompletableFuture.completedFuture(accessToken);
            }
        };
        OkHttpClient okHttpClient = new OkHttpClient.Builder().readTimeout(20L, TimeUnit.HOURS).writeTimeout(20L, TimeUnit.MINUTES).connectTimeout(1L, TimeUnit.MINUTES).addInterceptor(chain -> {
            Request original = chain.request();
            Request.Builder builder = original.newBuilder().header("Authorization", "Bearer " + accessToken);
            return chain.proceed(builder.build());
        }).build();
        return GraphServiceClient.builder().authenticationProvider(authProvider).httpClient((Object)okHttpClient).buildClient();
    }

    @Override
    public String auth(AuthParam param) throws Exception {
        return "https://login.microsoftonline.com/common/oauth2/v2.0/authorize?client_id=" + this.app.getKey() + "&response_type=code&redirect_uri=" + this.app.getCallback() + "&response_mode=query&scope=openid profile email offline_access Files.ReadWrite.All User.Read&state=" + param.getState() + "&prompt=consent";
    }

    private JSONObject postAuth(Form form) throws Exception {
        String responseStr = org.apache.http.client.fluent.Request.Post((String)"https://login.microsoftonline.com/common/oauth2/v2.0/token").connectTimeout(6000).socketTimeout(60000).bodyForm((Iterable)form.build(), StandardCharsets.UTF_8).execute().returnContent().asString();
        return new JSONObject(responseStr);
    }

    @Override
    public DriveAuth callback(AuthParam param) throws Exception {
        Form form = Form.form().add("client_id", this.app.getKey()).add("scope", SCOPE).add("code", param.getCode()).add("redirect_uri", this.app.getCallback()).add("grant_type", "authorization_code").add("client_secret", this.app.getSecret());
        JSONObject json = this.postAuth(form);
        String access = json.getString("access_token");
        String refresh = json.getString("refresh_token");
        DecodedJWT jwt = JWT.decode((String)json.getString("id_token"));
        String sub = jwt.getSubject();
        this.auth = DriveAuth.builder().uuid(sub).access(access).refresh(refresh).build();
        this.client = this.createClient(access);
        return this.auth;
    }

    @Override
    public DriveInfo info() throws Exception {
        Quota quota;
        Drive drive;
        DriveInfo info = new DriveInfo();
        User user = this.client.me().buildRequest(new Option[0]).get();
        if (user != null) {
            info.setName(user.displayName);
            info.setEmail(user.mail);
        }
        if ((drive = this.client.me().drive().buildRequest(new Option[0]).get()) != null && (quota = drive.quota) != null) {
            info.setUsed(quota.used);
            info.setTotal(quota.total);
        }
        return info;
    }

    @Override
    public ListResult list(ListParam param) throws Exception {
        String id = this.folderId(ROOT_ID, param.getNode());
        String start = param.getStart();
        ArrayList<Node> nodes = new ArrayList<Node>();
        String next = null;
        if (start == null || start.isEmpty()) {
            DriveItemCollectionRequestBuilder nextPage;
            DriveItemCollectionPage result = (DriveItemCollectionPage)((DriveItemCollectionRequest)this.client.me().drive().items(id).children().buildRequest(new Option[0])).top(1000).get();
            this.addToList(result, nodes);
            if (result != null && (nextPage = (DriveItemCollectionRequestBuilder)result.getNextPage()) != null) {
                next = this.decodeNext(nextPage.getRequestUrl());
            }
        } else {
            DriveItemCollectionResponse response = (DriveItemCollectionResponse)this.client.customRequest(start, DriveItemCollectionResponse.class).buildRequest(new Option[0]).get();
            if (response != null) {
                DriveItemCollectionRequestBuilder builder = new DriveItemCollectionRequestBuilder(start, this.client, null);
                DriveItemCollectionPage result = new DriveItemCollectionPage(response, builder);
                this.addToList(result, nodes);
                String nextLink = response.nextLink;
                if (nextLink != null) {
                    next = this.decodeNext(nextLink);
                }
            }
        }
        return ListResult.builder().nodes(nodes).next(next).build();
    }

    private String decodeNext(String link) {
        return link.replace("https://graph.microsoft.com/v1.0", "");
    }

    private void addToList(DriveItemCollectionPage result, List<Node> nodes) {
        if (result != null) {
            List list = result.getCurrentPage();
            for (DriveItem item : list) {
                if (item.webUrl == null) continue;
                nodes.add(this.toNode(item));
            }
        }
    }

    private Node toNode(DriveItem item) {
        boolean isDir = item.folder != null;
        Node node = new Node();
        node.setId(item.id);
        node.setType(isDir ? "folder" : "file");
        node.setName(item.name);
        node.setDir(isDir);
        node.setSize(item.size);
        OffsetDateTime time = item.lastModifiedDateTime;
        if (time != null) {
            node.setTime(time.toInstant().toEpochMilli());
        }
        return node;
    }

    private Node toNode(JSONObject item) {
        Node node = new Node();
        node.setId(item.getString("id"));
        node.setType("file");
        node.setName(item.getString("name"));
        node.setDir(false);
        node.setSize(item.getLong("size"));
        node.setTime(Instant.parse(item.getString("lastModifiedDateTime")).toEpochMilli());
        return node;
    }

    @Override
    public Node mkdir(MkdirParam param) throws Exception {
        String id = this.folderId(ROOT_ID, param.getNode());
        String name = param.getName();
        DriveItem newFolder = new DriveItem();
        newFolder.name = name;
        newFolder.folder = new Folder();
        newFolder.additionalDataManager().put((Object)"@microsoft.graph.conflictBehavior", (Object)new JsonPrimitive("fail"));
        DriveItem item = ((DriveItemCollectionRequest)this.client.me().drive().items(id).children().buildRequest(new Option[0])).post(newFolder);
        return this.toNode(item);
    }

    @Override
    public DownloadResult download(DownloadParam param) throws Exception {
        Node node = param.getNode();
        Long size = node.getSize();
        this.in = size != null && size == 0L ? new ByteArrayInputStream(new byte[0]) : this.client.me().drive().items(node.getId()).content().buildRequest(new Option[0]).get();
        return DownloadResult.builder().node(node).in(this.in).build();
    }

    @Override
    public Node upload(UploadParam param) throws Exception {
        String id = this.folderId(ROOT_ID, param.getNode());
        String name = param.getName();
        return this.uploadFile(id, name, param.getResult());
    }

    @Override
    public Node rename(RenameParam param) throws Exception {
        Node node = param.getNode();
        String id = node.getId();
        String name = param.getName();
        DriveItem updateItem = new DriveItem();
        updateItem.name = name;
        DriveItem updated = this.client.me().drive().items(id).buildRequest(new Option[0]).patch(updateItem);
        if (updated == null) {
            throw new Exception("Failed to rename " + node.getName());
        }
        return this.toNode(updated);
    }

    @Override
    public void delete(DeleteParam param) throws Exception {
        Node node = param.getNode();
        String id = node.getId();
        this.client.me().drive().items(id).buildRequest(new Option[0]).delete();
    }

    @Override
    public boolean needSize() {
        return true;
    }

    @Override
    public boolean expire(Exception e) {
        String msg = e.getMessage();
        return msg != null && (msg.contains("InvalidAuthenticationToken") || msg.contains("Unauthenticated"));
    }

    @Override
    public DriveAuth refresh() throws Exception {
        Form form = Form.form().add("client_id", this.app.getKey()).add("client_secret", this.app.getSecret()).add("refresh_token", this.auth.getRefresh()).add("grant_type", "refresh_token").add("scope", SCOPE);
        JSONObject json = this.postAuth(form);
        String access = json.getString("access_token");
        String refresh = json.getString("refresh_token");
        this.auth.setAccess(access);
        this.auth.setRefresh(refresh);
        this.client = this.createClient(access);
        return this.auth;
    }

    @Override
    public void newAuth(DriveAuth auth) throws Exception {
        this.auth = auth;
        this.client = this.createClient(auth.getAccess());
    }

    @Override
    public void finish() throws Exception {
        super.finish();
        this.curIsLimited = false;
    }

    @Override
    public void close() {
        this.auth = null;
        this.client = null;
        this.refreshedFlag = false;
        this.curIsLimited = false;
    }

    @Override
    public boolean refreshed() {
        return this.refreshedFlag;
    }

    @Override
    public DriveAuth loadAuth() {
        return this.auth;
    }

    @Override
    public String supportName(String name) {
        if (((String)(name = super.supportName((String)name))).endsWith(".")) {
            name = ((String)name).substring(0, ((String)name).length() - 1) + "_";
        } else if (((String)name).toLowerCase().endsWith(".xsn")) {
            name = (String)name + ".bak";
        }
        return name;
    }

    @Override
    public boolean isWarning(Exception e) {
        String msg = StringUtil.getMsg(e);
        return msg.contains("itemNotFound");
    }

    @Override
    public boolean isLimited(Exception e) {
        String msg = StringUtil.getMsg(e);
        if (msg.contains("InvalidAuthenticationToken")) {
            return false;
        }
        if (msg.contains("itemNotFound")) {
            return false;
        }
        if (e instanceof SocketTimeoutException) {
            return true;
        }
        if (e instanceof ClientProtocolException) {
            return true;
        }
        if (e instanceof GraphFatalServiceException) {
            return true;
        }
        if (e instanceof ClientException) {
            return true;
        }
        if (msg.contains("activityLimitReached")) {
            return true;
        }
        if (msg.contains("serviceNotAvailable")) {
            return true;
        }
        if (msg.contains("UnknownError")) {
            return true;
        }
        return msg.contains("accessDenied");
    }

    public Node uploadFile(String folderId, String name, DownloadResult result) throws Exception {
        JSONObject json;
        InputStream in = result.getIn();
        Node node = result.getNode();
        Long size = node.getSize();
        if (size <= 0x6400000L) {
            if (this.curIsLimited) {
                String uploadUrl = this.createUploadSession(folderId, name);
                json = this.uploadSmallFileUseChunkAPI(in, node, uploadUrl);
            } else {
                ProgInputStreamEntity entity = new ProgInputStreamEntity(in, node, this);
                json = this.uploadSmallFile(folderId, name, entity);
            }
        } else {
            String uploadUrl = this.createUploadSession(folderId, name);
            json = this.uploadLargeFile(in, node, uploadUrl, result);
        }
        return this.toNode(json);
    }

    private String encodeName(String name) throws UnsupportedEncodingException {
        return URLEncoder.encode(name, "UTF-8").replace("+", "%20");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JSONObject uploadSmallFile(String folderId, String name, ProgInputStreamEntity entity) throws Exception {
        String url = "https://graph.microsoft.com/v1.0/me/drive/items/" + folderId + ":/" + this.encodeName(name) + ":/content";
        try (CloseableHttpClient client = HttpClients.createDefault();){
            HttpPut put = new HttpPut(url);
            put.setConfig(this.requestConfig);
            put.setHeader("Authorization", "Bearer " + this.auth.getAccess());
            put.setHeader("Content-Type", "application/octet-stream");
            put.setEntity((HttpEntity)entity);
            try {
                String result;
                block15: {
                    JSONObject jSONObject;
                    try (CloseableHttpResponse response = client.execute((HttpUriRequest)put);){
                        int status = response.getStatusLine().getStatusCode();
                        result = EntityUtils.toString((HttpEntity)response.getEntity());
                        if (status < 200 || status >= 300) break block15;
                        jSONObject = new JSONObject(result);
                        if (response == null) return jSONObject;
                    }
                    return jSONObject;
                }
                throw new Exception(result);
            }
            catch (Exception e) {
                if (!this.isLimited(e)) throw e;
                this.curIsLimited = true;
                throw e;
            }
        }
    }

    private String createUploadSession(String folderId, String name) throws Exception {
        String url = "https://graph.microsoft.com/v1.0/me/drive/items/" + folderId + ":/" + this.encodeName(name) + ":/createUploadSession";
        try (CloseableHttpClient client = HttpClients.createDefault();){
            HttpPost post = new HttpPost(url);
            post.setConfig(this.requestConfig);
            post.setHeader("Authorization", "Bearer " + this.auth.getAccess());
            post.setHeader("Content-Type", "application/json");
            JSONObject param = new JSONObject();
            param.put("@microsoft.graph.conflictBehavior", (Object)"replace");
            param.put("name", (Object)name);
            post.setEntity((HttpEntity)new StringEntity(param.toString()));
            try (CloseableHttpResponse response = client.execute((HttpUriRequest)post);){
                int status = response.getStatusLine().getStatusCode();
                String result = EntityUtils.toString((HttpEntity)response.getEntity());
                if (status >= 200 && status < 300) {
                    String string = new JSONObject(result).getString("uploadUrl");
                    return string;
                }
                throw new Exception(result);
            }
        }
    }

    private JSONObject uploadSmallFileUseChunkAPI(InputStream in, Node node, String uploadUrl) throws Exception {
        String result = null;
        int chunkSize = 0x500000;
        long uploaded = 0L;
        byte[] buffer = new byte[chunkSize];
        try (CloseableHttpClient client = HttpClients.createDefault();){
            while (uploaded < node.getSize()) {
                int totalRead;
                int bytesRead;
                for (totalRead = 0; totalRead < chunkSize && (bytesRead = in.read(buffer, totalRead, chunkSize - totalRead)) != -1; totalRead += bytesRead) {
                }
                if (totalRead <= 0) {
                    break;
                }
                long start = uploaded;
                long end = uploaded + (long)totalRead - 1L;
                HttpPut put = new HttpPut(uploadUrl);
                put.setConfig(this.requestConfig);
                put.setHeader("Content-Range", "bytes " + start + "-" + end + "/" + node.getSize());
                put.setEntity((HttpEntity)new ByteArrayEntity(buffer, 0, totalRead));
                try (CloseableHttpResponse response = client.execute((HttpUriRequest)put);){
                    int status = response.getStatusLine().getStatusCode();
                    result = EntityUtils.toString((HttpEntity)response.getEntity());
                    if (status < 200 || status >= 300) {
                        throw new Exception("Upload failed: " + result);
                    }
                }
                this.setUploadMsg(node, uploaded += (long)totalRead);
            }
        }
        if (result == null) {
            throw new Exception("Failed to upload the file.");
        }
        return new JSONObject(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JSONObject uploadLargeFile(InputStream in, Node node, String uploadUrl, DownloadResult downloadResult) throws Exception {
        ExecutorService pool = Executors.newFixedThreadPool(1);
        ArrayList<Future<String>> futures = new ArrayList<Future<String>>();
        try {
            long currentChunkSize;
            for (long downloaded = 0L; downloaded < node.getSize(); downloaded += currentChunkSize) {
                if (pool.isShutdown()) {
                    throw new Exception(node.getMsg());
                }
                long remaining = node.getSize() - downloaded;
                currentChunkSize = Math.min(0x6400000L, remaining);
                File tempFile = this.createTempFile(in, currentChunkSize);
                long start = downloaded;
                if (pool.isShutdown()) {
                    throw new Exception(node.getMsg());
                }
                Future<String> future = pool.submit(() -> {
                    try {
                        int sleepSeconds = 1;
                        int attempt = 0;
                        block7: while (true) {
                            ++attempt;
                            if (pool.isShutdown()) {
                                throw new Exception(node.getMsg());
                            }
                            try {
                                String result = this.uploadChunk(node, uploadUrl, start, currentChunkSize, tempFile);
                                this.setUploadMsg(node, start + currentChunkSize);
                                String string = result;
                                return string;
                            }
                            catch (Exception e) {
                                block13: {
                                    logger.error("OneDrive chunked upload error: " + node.getName() + "\uff0c" + e.toString());
                                    if (!this.expire(e)) break block13;
                                    this.refresh();
                                    this.refreshedFlag = true;
                                    String result = this.uploadChunk(node, uploadUrl, start, currentChunkSize, tempFile);
                                    this.setUploadMsg(node, start + currentChunkSize);
                                    String string = result;
                                    this.deleteTempFile(tempFile);
                                    return string;
                                }
                                if (this.isLimited(e)) {
                                    int finalSeconds = Math.min(sleepSeconds *= 2, 3);
                                    node.setMsg("attempt:" + attempt + ",sleepSeconds:" + finalSeconds + ":" + StringUtil.getMsg(e));
                                    int i = 0;
                                    while (true) {
                                        if (i >= finalSeconds) continue block7;
                                        if (i % 3 == 0) {
                                            this.refreshProgress();
                                        }
                                        Thread.sleep(1000L);
                                        ++i;
                                    }
                                }
                                node.setMsg(StringUtil.getMsg(e));
                                if (!pool.isShutdown()) {
                                    pool.shutdown();
                                }
                                throw e;
                            }
                            break;
                        }
                    }
                    finally {
                        this.deleteTempFile(tempFile);
                    }
                });
                futures.add(future);
            }
        }
        finally {
            DriveUtil driveUtil = downloadResult.getDriveUtil();
            if (driveUtil != null) {
                driveUtil.finish();
                downloadResult.setDriveUtil(null);
            }
            if (pool instanceof ThreadPoolExecutor) {
                ThreadPoolExecutor tpe = (ThreadPoolExecutor)pool;
                while (tpe.getCompletedTaskCount() != tpe.getTaskCount()) {
                    Thread.sleep(1000L);
                }
                pool.shutdown();
            }
        }
        if (futures.isEmpty()) {
            throw new Exception("Failed to upload the file.");
        }
        String result = (String)((Future)futures.get(futures.size() - 1)).get();
        return new JSONObject(result);
    }

    @NotNull
    private File createTempFile(InputStream in, long currentChunkSize) throws Exception {
        File tempFile = File.createTempFile("upload_chunk_", ".tmp");
        try (FileOutputStream fos = new FileOutputStream(tempFile);){
            int maxRead;
            int read;
            byte[] buffer = new byte[8192];
            for (long bytesWritten = 0L; bytesWritten < currentChunkSize && (read = in.read(buffer, 0, maxRead = (int)Math.min((long)buffer.length, currentChunkSize - bytesWritten))) != -1; bytesWritten += (long)read) {
                fos.write(buffer, 0, read);
            }
            fos.flush();
        }
        return tempFile;
    }

    private String uploadChunk(Node node, String uploadUrl, long uploaded, long currentChunkSize, File tempFile) throws Exception {
        String result;
        HttpPut put = new HttpPut(uploadUrl);
        put.setConfig(this.requestConfig);
        put.setHeader("Content-Range", "bytes " + uploaded + "-" + (uploaded + currentChunkSize - 1L) + "/" + node.getSize());
        put.setEntity((HttpEntity)new FileEntity(tempFile));
        try (CloseableHttpClient client = HttpClients.createDefault();
             CloseableHttpResponse response = client.execute((HttpUriRequest)put);){
            int status = response.getStatusLine().getStatusCode();
            result = EntityUtils.toString((HttpEntity)response.getEntity());
            if (status < 200 || status >= 300) {
                throw new Exception("Upload failed: " + result);
            }
        }
        return result;
    }

    private void deleteTempFile(File tempFile) {
        if (tempFile != null && !tempFile.delete()) {
            tempFile.deleteOnExit();
        }
    }
}

