/*
 * Decompiled with CFR 0.152.
 */
package tools.mv.backend.drive;

import cn.hutool.crypto.digest.DigestUtil;
import java.io.InputStream;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.fluent.Form;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import tools.mv.backend.drive.BaseDrive;
import tools.mv.backend.drive.DriveParent;
import tools.mv.backend.model.AppDrive;
import tools.mv.backend.model.AppInfo;
import tools.mv.backend.model.AuthParam;
import tools.mv.backend.model.DeleteParam;
import tools.mv.backend.model.DownloadParam;
import tools.mv.backend.model.DownloadResult;
import tools.mv.backend.model.DriveAuth;
import tools.mv.backend.model.DriveInfo;
import tools.mv.backend.model.ListParam;
import tools.mv.backend.model.ListResult;
import tools.mv.backend.model.MediaFireParam;
import tools.mv.backend.model.MediaFireResult;
import tools.mv.backend.model.MkdirParam;
import tools.mv.backend.model.Node;
import tools.mv.backend.model.RenameParam;
import tools.mv.backend.model.UploadParam;
import tools.mv.backend.util.DriveUtil;
import tools.mv.backend.util.ProgInputStreamEntity;
import tools.mv.backend.util.StringUtil;
import tools.mv.backend.util.TempFileManager;

public class MediaFire
extends DriveParent
implements BaseDrive {
    private final AppInfo app;
    private MediaFireParam mediaFireParam;
    private static final String ROOT_ID = "myfiles";
    private boolean refreshedFlag = false;
    private static final String EXPIRED_MSG = "The supplied Session Token is expired or invalid";
    private static final String ZERO_MSG = "Failed to create 0-byte file";

    public MediaFire(AppDrive appDrive) {
        super(appDrive);
        this.app = appDrive.getInfo();
        DriveAuth auth = appDrive.getAuth();
        if (auth != null) {
            this.mediaFireParam = auth.getMediafire();
        }
    }

    private void auth(MediaFireParam param) throws Exception {
        String requestResult = Request.Post((String)"https://www.mediafire.com/api/1.5/user/get_session_token.php").bodyForm((Iterable)Form.form().add("token_version", "1").add("response_format", "json").add("email", param.getEmail()).add("password", param.getPassword()).add("application_id", this.app.getKey()).add("signature", DigestUtil.sha1Hex((String)(param.getEmail() + param.getPassword() + this.app.getKey() + this.app.getSecret()))).build(), StandardCharsets.UTF_8).connectTimeout(6000).socketTimeout(60000).execute().returnContent().asString();
        try {
            JSONObject response = new JSONObject(requestResult).getJSONObject("response");
            param.setEkey(response.getString("ekey"));
            param.setToken(response.getString("session_token"));
        }
        catch (Exception e) {
            throw new Exception(requestResult, e);
        }
    }

    @Override
    public DriveAuth callback(AuthParam param) throws Exception {
        this.mediaFireParam = param.getMediafire();
        this.auth(this.mediaFireParam);
        return DriveAuth.builder().uuid(this.mediaFireParam.getEkey()).mediafire(this.mediaFireParam).build();
    }

    private JSONObject getResponseObj(String requestResult) throws Exception {
        if (requestResult == null || requestResult.isEmpty()) {
            throw new Exception("requestResult result is null.");
        }
        JSONObject response = new JSONObject(requestResult).getJSONObject("response");
        if (!"Success".equals(response.getString("result"))) {
            throw new Exception(response.toString());
        }
        return response;
    }

    @Override
    public DriveInfo info() throws Exception {
        String requestResult = Request.Get((String)("https://www.mediafire.com/api/1.5/user/get_info.php?response_format=json&session_token=" + this.mediaFireParam.getToken())).connectTimeout(6000).socketTimeout(60000).execute().returnContent().asString();
        try {
            DriveInfo info = new DriveInfo();
            JSONObject userInfo = this.getResponseObj(requestResult).getJSONObject("user_info");
            if (userInfo.has("email")) {
                info.setEmail(userInfo.getString("email"));
            }
            if (userInfo.has("display_name")) {
                info.setName(userInfo.getString("display_name"));
            }
            if (userInfo.has("used_storage_size")) {
                info.setUsed(Long.parseLong(userInfo.getString("used_storage_size")));
            }
            if (userInfo.has("base_storage")) {
                info.setTotal(Long.parseLong(userInfo.getString("base_storage")));
            }
            info.setMediafire(this.mediaFireParam.toInfo());
            return info;
        }
        catch (Exception e) {
            throw new Exception(requestResult, e);
        }
    }

    @Override
    public ListResult list(ListParam param) throws Exception {
        String id = this.folderId(ROOT_ID, param.getNode());
        String start = param.getStart();
        if (start == null || start.isEmpty()) {
            start = "folders:1";
        }
        String[] split = start.split(":");
        String type = split[0];
        String chunk = split[1];
        String requestResult = Request.Get((String)("https://www.mediafire.com/api/1.5/folder/get_content.php?response_format=json&content_type=" + type + "&chunk=" + chunk + "&chunk_size=1000&folder_key=" + id + "&session_token=" + this.mediaFireParam.getToken())).connectTimeout(6000).socketTimeout(60000).execute().returnContent().asString();
        Object next = null;
        ArrayList<Node> nodes = new ArrayList<Node>();
        try {
            boolean hasMore;
            JSONObject content = this.getResponseObj(requestResult).getJSONObject("folder_content");
            boolean bl = hasMore = !content.getString("more_chunks").equals("no");
            if (hasMore) {
                String curType = content.getString("content_type");
                String curChunk = content.getString("chunk_number");
                next = curType + ":" + (Long.parseLong(curChunk) + 1L);
            }
            if (content.has("folders")) {
                this.addNodes(nodes, content.getJSONArray("folders"));
                if (!hasMore) {
                    next = "files:1";
                }
            } else if (content.has("files")) {
                this.addNodes(nodes, content.getJSONArray("files"));
            }
        }
        catch (Exception e) {
            throw new Exception(requestResult, e);
        }
        return ListResult.builder().nodes(nodes).next((String)next).build();
    }

    private void addNodes(List<Node> nodes, JSONArray arr) {
        for (int i = 0; i < arr.length(); ++i) {
            nodes.add(this.toNode(arr.getJSONObject(i)));
        }
    }

    private Node toNode(JSONObject json) {
        boolean isDir = json.has("folderkey");
        Node node = new Node();
        node.setId(isDir ? json.getString("folderkey") : json.getString("quickkey"));
        node.setType(isDir ? "folder" : "file");
        node.setName(isDir ? json.getString("name") : json.getString("filename"));
        node.setDir(isDir);
        if (!isDir) {
            node.setSize(Long.parseLong(json.getString("size")));
        }
        node.setTime(Instant.parse(json.getString("created_utc")).toEpochMilli());
        return node;
    }

    @Override
    public Node mkdir(MkdirParam param) throws Exception {
        String id = this.folderId(ROOT_ID, param.getNode());
        String name = param.getName();
        String requestResult = Request.Post((String)"https://www.mediafire.com/api/1.5/folder/create.php").bodyForm((Iterable)Form.form().add("response_format", "json").add("action_on_duplicate", "skip").add("foldername", name).add("parent_key", id).add("session_token", this.mediaFireParam.getToken()).build(), StandardCharsets.UTF_8).connectTimeout(6000).socketTimeout(60000).execute().returnContent().asString();
        try {
            JSONObject response = this.getResponseObj(requestResult);
            response.put("folderkey", (Object)response.getString("folder_key"));
            return this.toNode(response);
        }
        catch (Exception e) {
            throw new Exception(requestResult, e);
        }
    }

    @Override
    public DownloadResult download(DownloadParam param) throws Exception {
        Node node = param.getNode();
        String requestResult = Request.Get((String)("https://www.mediafire.com/api/1.5/file/get_links.php?response_format=json&link_type=direct_download&quick_key=" + node.getId() + "&session_token=" + this.mediaFireParam.getToken())).connectTimeout(6000).socketTimeout(60000).execute().returnContent().asString();
        String url = null;
        try {
            JSONObject response = this.getResponseObj(requestResult);
            url = response.getJSONArray("links").getJSONObject(0).getString("direct_download");
        }
        catch (Exception e) {
            throw new Exception(requestResult, e);
        }
        this.in = this.getInputStreamFromUrl(url, null);
        return DownloadResult.builder().node(node).in(this.in).build();
    }

    @Override
    public Node upload(UploadParam param) throws Exception {
        Long size = param.getResult().getNode().getSize();
        if (size == 0L) {
            return this.uploadZero(param);
        }
        if (size <= 0x6400000L) {
            return this.uploadSmall(param);
        }
        return this.uploadLarge(param);
    }

    @Override
    public Node rename(RenameParam param) throws Exception {
        Form form;
        String apiUrl;
        Node node = param.getNode();
        String id = node.getId();
        String name = param.getName();
        if (node.isDir()) {
            apiUrl = "https://www.mediafire.com/api/1.5/folder/update.php";
            form = Form.form().add("response_format", "json").add("session_token", this.mediaFireParam.getToken()).add("folder_key", id).add("foldername", name);
        } else {
            apiUrl = "https://www.mediafire.com/api/1.5/file/update.php";
            form = Form.form().add("response_format", "json").add("session_token", this.mediaFireParam.getToken()).add("quick_key", id).add("filename", name);
        }
        String requestResult = Request.Post((String)apiUrl).bodyForm((Iterable)form.build(), StandardCharsets.UTF_8).connectTimeout(6000).socketTimeout(60000).execute().returnContent().asString();
        try {
            this.getResponseObj(requestResult);
            node.setName(name);
            return node;
        }
        catch (Exception e) {
            throw new Exception(requestResult, e);
        }
    }

    @Override
    public void delete(DeleteParam param) throws Exception {
        Form form;
        String apiUrl;
        Node node = param.getNode();
        String id = node.getId();
        if (node.isDir()) {
            apiUrl = "https://www.mediafire.com/api/1.5/folder/delete.php";
            form = Form.form().add("response_format", "json").add("session_token", this.mediaFireParam.getToken()).add("folder_key", id).add("recursive", "yes");
        } else {
            apiUrl = "https://www.mediafire.com/api/1.5/file/delete.php";
            form = Form.form().add("response_format", "json").add("session_token", this.mediaFireParam.getToken()).add("quick_key", id);
        }
        String requestResult = Request.Post((String)apiUrl).bodyForm((Iterable)form.build(), StandardCharsets.UTF_8).connectTimeout(6000).socketTimeout(60000).execute().returnContent().asString();
        try {
            this.getResponseObj(requestResult);
        }
        catch (Exception e) {
            throw new Exception(requestResult, e);
        }
    }

    private Node uploadZero(UploadParam param) throws Exception {
        String id = this.folderId(ROOT_ID, param.getNode());
        String url = "https://www.mediafire.com/api/1.5/file/create.php";
        Form form = Form.form().add("session_token", this.mediaFireParam.getToken()).add("filename", param.getName()).add("response_format", "json").add("type", "").add("parent_key", id);
        String requestResult = null;
        try {
            requestResult = Request.Post((String)url).bodyForm((Iterable)form.build(), StandardCharsets.UTF_8).socketTimeout(60000).connectTimeout(6000).execute().returnContent().asString(StandardCharsets.UTF_8);
        }
        catch (HttpResponseException e) {
            throw new Exception("Failed to create 0-byte file " + e.getMessage(), e);
        }
        try {
            JSONObject response = this.getResponseObj(requestResult);
            JSONObject fileinfo = response.getJSONObject("fileinfo");
            return this.toNode(fileinfo);
        }
        catch (Exception e) {
            throw new Exception(requestResult, e);
        }
    }

    private Node uploadSmall(UploadParam param) throws Exception {
        String id = this.folderId(ROOT_ID, param.getNode());
        String name = param.getName();
        DownloadResult result = param.getResult();
        InputStream in = result.getIn();
        Node fromNode = result.getNode();
        Long size = fromNode.getSize();
        String url = "https://www.mediafire.com/api/1.5/upload/simple.php?session_token=" + this.mediaFireParam.getToken() + "&folder_key=" + id + "&action_on_duplicate=replace&response_format=json";
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            HttpPost httpPost = new HttpPost(url);
            httpPost.setConfig(this.requestConfig);
            httpPost.setHeader("Content-Type", "application/octet-stream");
            httpPost.setHeader("x-filename", URLEncoder.encode(name, "UTF-8"));
            httpPost.setHeader("x-filesize", String.valueOf(size));
            ProgInputStreamEntity requestEntity = new ProgInputStreamEntity(in, fromNode, this);
            httpPost.setEntity((HttpEntity)requestEntity);
            String requestResult = (String)httpClient.execute((HttpUriRequest)httpPost, httpResponse -> {
                HttpEntity entity = httpResponse.getEntity();
                return entity != null ? EntityUtils.toString((HttpEntity)entity) : null;
            });
            try {
                JSONObject response = this.getResponseObj(requestResult);
                String key = response.getJSONObject("doupload").getString("key");
                if (key == null || key.isEmpty()) {
                    throw new Exception(response.toString());
                }
                Node node = this.createUploadNode(key, name, size);
                return node;
            }
            catch (Exception e) {
                throw new Exception(requestResult, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node uploadLarge(UploadParam param) throws Exception {
        String id = this.folderId(ROOT_ID, param.getNode());
        String name = param.getName();
        DownloadResult result = param.getResult();
        Node fromNode = result.getNode();
        Long size = fromNode.getSize();
        TempFileManager tempFileManager = new TempFileManager(result.getIn(), fromNode, this);
        String fileHash = tempFileManager.saveToTempAndHash();
        try {
            DriveUtil driveUtil = result.getDriveUtil();
            if (driveUtil != null) {
                driveUtil.finish();
                result.setDriveUtil(null);
            }
            MediaFireResult chunkInfo = this.getChunkInfo(name, size, fileHash, id, fromNode);
            String uploadKey = null;
            try (CloseableHttpClient httpClient = HttpClients.createDefault();
                 InputStream in = tempFileManager.getInputStream();){
                byte[] buffer = new byte[chunkInfo.getUnitSize()];
                long uploaded = 0L;
                for (int unitId = 0; unitId < chunkInfo.getNumberOfUnits(); ++unitId) {
                    int total;
                    int read = 0;
                    for (total = 0; total < chunkInfo.getUnitSize() && (read = in.read(buffer, total, chunkInfo.getUnitSize() - total)) != -1; total += read) {
                    }
                    if (total <= 0) {
                        break;
                    }
                    byte[] unitData = Arrays.copyOf(buffer, total);
                    String unitHash = DigestUtil.sha256Hex((byte[])unitData);
                    String uploadKeyTemp = this.chunkUpload(httpClient, fromNode, name, size, unitHash, fileHash, total, id, unitId, unitData);
                    if (uploadKey == null && uploadKeyTemp != null && !uploadKeyTemp.isEmpty()) {
                        uploadKey = uploadKeyTemp;
                    }
                    this.setUploadMsg(fromNode, uploaded += (long)total);
                }
            }
            Node node = this.pollUpload(uploadKey, fromNode);
            return node;
        }
        finally {
            tempFileManager.deleteTempFile();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private MediaFireResult getChunkInfo(String name, Long size, String fileHash, String id, Node fromNode) throws Exception {
        int sleepSeconds = 1;
        int attempt = 0;
        block4: while (true) {
            ++attempt;
            String checkUrl = "https://www.mediafire.com/api/1.5/upload/check.php?session_token=" + this.mediaFireParam.getToken() + "&filename=" + URLEncoder.encode(name, "UTF-8") + "&size=" + size + "&hash=" + fileHash + "&folder_key=" + id + "&resumable=yes&response_format=json";
            String requestResult = null;
            try {
                requestResult = Request.Get((String)checkUrl).connectTimeout(6000).socketTimeout(60000).execute().returnContent().asString();
            }
            catch (Exception e) {
                logger.error("MediaFire block info retrieval error: " + name + "\uff0c" + e.toString());
                if (this.expire(e)) {
                    this.refresh();
                    this.refreshedFlag = true;
                    continue;
                }
                if (!this.isLimited(e)) {
                    fromNode.setMsg(StringUtil.getMsg(e));
                    throw e;
                }
                int finalSeconds = Math.min(sleepSeconds *= 2, 3);
                fromNode.setMsg("attempt:" + attempt + ",sleepSeconds:" + finalSeconds + ":" + StringUtil.getMsg(e));
                int i = 0;
                while (true) {
                    if (i >= finalSeconds) continue block4;
                    if (i % 3 == 0) {
                        this.refreshProgress();
                    }
                    Thread.sleep(1000L);
                    ++i;
                }
            }
            try {
                JSONObject response = new JSONObject(requestResult).getJSONObject("response");
                if ("Success".equals(response.getString("result"))) {
                    JSONObject resumable = response.getJSONObject("resumable_upload");
                    int unitSize = resumable.getInt("unit_size");
                    int numberOfUnits = resumable.getInt("number_of_units");
                    return new MediaFireResult(unitSize, numberOfUnits);
                }
                if (!requestResult.contains(EXPIRED_MSG)) {
                    throw new Exception(response.toString());
                }
                this.refresh();
                this.refreshedFlag = true;
            }
            catch (Exception e) {
                throw new Exception(requestResult, e);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String chunkUpload(CloseableHttpClient httpClient, Node fromNode, String name, Long size, String unitHash, String fileHash, int total, String id, int unitId, byte[] unitData) throws Exception {
        int sleepSeconds = 1;
        int attempt = 0;
        block4: while (true) {
            ++attempt;
            String requestResult = null;
            try {
                String url = "https://www.mediafire.com/api/1.5/upload/resumable.php?session_token=" + this.mediaFireParam.getToken() + "&folder_key=" + id + "&action_on_duplicate=replace&response_format=json";
                HttpPost httpPost = new HttpPost(url);
                httpPost.setConfig(this.requestConfig);
                httpPost.setHeader("Content-Type", "application/octet-stream");
                httpPost.setHeader("x-filename", URLEncoder.encode(name, "UTF-8"));
                httpPost.setHeader("x-filesize", String.valueOf(size));
                httpPost.setHeader("x-filehash", fileHash);
                httpPost.setHeader("x-unit-id", String.valueOf(unitId));
                httpPost.setHeader("x-unit-size", String.valueOf(total));
                httpPost.setHeader("x-unit-hash", unitHash);
                httpPost.setEntity((HttpEntity)new ByteArrayEntity(unitData));
                requestResult = (String)httpClient.execute((HttpUriRequest)httpPost, httpResponse -> {
                    HttpEntity entity = httpResponse.getEntity();
                    return entity != null ? EntityUtils.toString((HttpEntity)entity) : null;
                });
            }
            catch (Exception e) {
                logger.error("MediaFire\u4e0a\u4f20\u5206\u5757\u5f02\u5e38\uff1a" + name + "\uff0c" + e.toString());
                if (this.expire(e)) {
                    this.refresh();
                    this.refreshedFlag = true;
                    continue;
                }
                if (!this.isLimited(e)) {
                    fromNode.setMsg(StringUtil.getMsg(e));
                    throw e;
                }
                int finalSeconds = Math.min(sleepSeconds *= 2, 3);
                fromNode.setMsg("attempt:" + attempt + ",sleepSeconds:" + finalSeconds + ":" + StringUtil.getMsg(e));
                int i = 0;
                while (true) {
                    if (i >= finalSeconds) continue block4;
                    if (i % 3 == 0) {
                        this.refreshProgress();
                    }
                    Thread.sleep(1000L);
                    ++i;
                }
            }
            try {
                JSONObject response = new JSONObject(requestResult).getJSONObject("response");
                if ("Success".equals(response.getString("result"))) {
                    return response.getJSONObject("doupload").getString("key");
                }
                if (!requestResult.contains(EXPIRED_MSG)) {
                    throw new Exception(response.toString());
                }
                this.refresh();
                this.refreshedFlag = true;
            }
            catch (Exception e) {
                throw new Exception(requestResult, e);
            }
        }
    }

    private Node pollUpload(String uploadKey, Node fromNode) throws Exception {
        int sleepSeconds = 1;
        int attempt = 0;
        block4: while (true) {
            ++attempt;
            String pollUrl = "https://www.mediafire.com/api/1.5/upload/poll_upload.php?key=" + uploadKey + "&response_format=json";
            String requestResult = null;
            try {
                requestResult = Request.Get((String)pollUrl).connectTimeout(6000).socketTimeout(60000).execute().returnContent().asString();
            }
            catch (Exception e) {
                logger.error("MediaFire block check error: " + fromNode.getName() + "\uff0c" + e.toString());
                if (this.expire(e)) {
                    this.refresh();
                    this.refreshedFlag = true;
                    continue;
                }
                if (this.isLimited(e)) {
                    int finalSeconds = Math.min(sleepSeconds *= 2, 3);
                    fromNode.setMsg("attempt:" + attempt + ",sleepSeconds:" + finalSeconds + ":" + StringUtil.getMsg(e));
                    int i = 0;
                    while (true) {
                        if (i >= finalSeconds) continue block4;
                        if (i % 3 == 0) {
                            this.refreshProgress();
                        }
                        Thread.sleep(1000L);
                        ++i;
                    }
                }
                fromNode.setMsg(StringUtil.getMsg(e) + ", uploadKey:" + uploadKey);
                throw e;
            }
            try {
                JSONObject response = this.getResponseObj(requestResult);
                JSONObject doupload = response.getJSONObject("doupload");
                if (doupload.getInt("status") == 99 && doupload.has("quickkey")) {
                    return this.toNode(doupload);
                }
                fromNode.setMsg("Wait poll upload: " + String.valueOf(response));
                this.refreshProgress();
                Thread.sleep(2000L);
            }
            catch (Exception e) {
                throw new Exception(requestResult, e);
            }
        }
    }

    @Override
    public boolean needSize() {
        return true;
    }

    @Override
    public boolean expire(Exception e) {
        String msg = StringUtil.getMsg(e);
        return msg.contains("403") && msg.contains("Forbidden") || msg.contains(EXPIRED_MSG);
    }

    @Override
    public boolean isLimited(Exception e) {
        if (e instanceof ClientProtocolException) {
            return true;
        }
        String msg = StringUtil.getMsg(e);
        return msg.contains("429") && msg.contains("Too Many Requests");
    }

    @Override
    public DriveAuth refresh() throws Exception {
        this.auth(this.mediaFireParam);
        return DriveAuth.builder().uuid(this.mediaFireParam.getEkey()).mediafire(this.mediaFireParam).build();
    }

    @Override
    public void newAuth(DriveAuth auth) throws Exception {
        this.mediaFireParam = auth.getMediafire();
    }

    @Override
    public void close() {
        this.mediaFireParam = null;
        this.refreshedFlag = false;
    }

    @Override
    public boolean refreshed() {
        return this.refreshedFlag;
    }

    @Override
    public DriveAuth loadAuth() {
        return DriveAuth.builder().uuid(this.mediaFireParam.getEkey()).mediafire(this.mediaFireParam).build();
    }

    @Override
    public boolean isWarning(Exception e) {
        String msg = StringUtil.getMsg(e);
        return msg.contains(ZERO_MSG);
    }
}

