/*
 * Decompiled with CFR 0.152.
 */
package tools.mv.backend.drive;

import cn.hutool.crypto.digest.DigestUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import tools.mv.backend.drive.BaseDrive;
import tools.mv.backend.drive.DriveParent;
import tools.mv.backend.exception.BusinessException;
import tools.mv.backend.model.AppDrive;
import tools.mv.backend.model.AuthParam;
import tools.mv.backend.model.DeleteParam;
import tools.mv.backend.model.DownloadParam;
import tools.mv.backend.model.DownloadResult;
import tools.mv.backend.model.DriveAuth;
import tools.mv.backend.model.DriveInfo;
import tools.mv.backend.model.ListParam;
import tools.mv.backend.model.ListResult;
import tools.mv.backend.model.LocalParam;
import tools.mv.backend.model.MkdirParam;
import tools.mv.backend.model.Node;
import tools.mv.backend.model.RenameParam;
import tools.mv.backend.model.UploadParam;

public class LocalDrive
extends DriveParent
implements BaseDrive {
    private LocalParam local;
    private String path;

    public LocalDrive(AppDrive appDrive) {
        super(appDrive);
        DriveAuth auth = appDrive.getAuth();
        if (auth != null) {
            this.local = auth.getLocal();
            this.path = this.local.getPath();
        }
    }

    @Override
    public DriveAuth callback(AuthParam param) throws Exception {
        this.local = param.getLocal();
        this.path = this.local.getPath();
        File folder = new File(this.path);
        if (!folder.exists()) {
            throw new BusinessException("Path does not exist", new Object[0]);
        }
        if (!folder.isDirectory()) {
            throw new BusinessException("Path is not a folder", new Object[0]);
        }
        File[] files = folder.listFiles();
        if (files == null) {
            throw new BusinessException("Permission denied for the path", new Object[0]);
        }
        String uuid = DigestUtil.md5Hex((String)folder.getAbsolutePath());
        return DriveAuth.builder().uuid(uuid).local(this.local).build();
    }

    @Override
    public DriveInfo info() throws Exception {
        File folder = new File(this.path);
        long total = folder.getTotalSpace();
        long used = total - folder.getUsableSpace();
        return DriveInfo.builder().used(used).total(total).local(this.local).build();
    }

    @Override
    public ListResult list(ListParam param) throws Exception {
        String id = this.folderId(this.path, param.getNode());
        File[] files = new File(id).listFiles();
        if (files == null) {
            throw new BusinessException("Permission denied for the path", new Object[0]);
        }
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (File file : files) {
            nodes.add(this.toNode(file));
        }
        return ListResult.builder().nodes(nodes).build();
    }

    private Node toNode(File file) {
        long time;
        boolean isDir = file.isDirectory();
        Node node = new Node();
        node.setId(file.getAbsolutePath());
        node.setType(isDir ? "folder" : "file");
        node.setName(file.getName());
        node.setDir(isDir);
        if (!isDir) {
            node.setSize(file.length());
        }
        if ((time = file.lastModified()) > 0L) {
            node.setTime(time);
        }
        return node;
    }

    @Override
    public Node mkdir(MkdirParam param) throws Exception {
        String id = this.folderId(this.path, param.getNode());
        File folder = new File(id, param.getName());
        if (folder.exists()) {
            throw new BusinessException("The folder already exists", new Object[0]);
        }
        if (!folder.mkdir()) {
            throw new BusinessException("Failed to create folder", new Object[0]);
        }
        return this.toNode(folder);
    }

    @Override
    public DownloadResult download(DownloadParam param) throws Exception {
        Node node = param.getNode();
        File file = new File(node.getId());
        if (!file.exists() || !file.isFile()) {
            throw new BusinessException("File does not exist", new Object[0]);
        }
        this.in = new FileInputStream(file);
        return DownloadResult.builder().node(node).in(this.in).build();
    }

    @Override
    public Node upload(UploadParam param) throws Exception {
        String name = param.getName();
        String id = this.folderId(this.path, param.getNode());
        File file = new File(id, name);
        this.out = new FileOutputStream(file);
        DownloadResult result = param.getResult();
        long sum = this.readAndWrite(result.getIn(), this.out, result.getNode());
        return this.createUploadNode(this.path, name, sum);
    }

    @Override
    public Node rename(RenameParam param) throws Exception {
        String id = this.folderId(this.path, param.getNode());
        File file = new File(id);
        if (!file.exists()) {
            throw new BusinessException("Item does not exist", new Object[0]);
        }
        File newFile = new File(file.getParent(), param.getName());
        if (newFile.exists()) {
            throw new BusinessException("The item already exists", new Object[0]);
        }
        if (!file.renameTo(newFile)) {
            throw new BusinessException("Failed to rename item", new Object[0]);
        }
        return this.toNode(newFile);
    }

    @Override
    public void delete(DeleteParam param) throws Exception {
        Node node = param.getNode();
        File file = new File(node.getId());
        if (!file.exists()) {
            throw new BusinessException("Item does not exist", new Object[0]);
        }
        this.delete(file);
    }

    private void delete(File file) {
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            if (files == null) {
                throw new BusinessException("Permission denied for the path", new Object[0]);
            }
            for (File f : files) {
                this.delete(f);
            }
        }
        if (!file.delete()) {
            throw new BusinessException("Failed to delete item", new Object[0]);
        }
    }

    @Override
    public boolean expire(Exception e) {
        return false;
    }

    @Override
    public DriveAuth refresh() throws Exception {
        return null;
    }

    @Override
    public void newAuth(DriveAuth auth) throws Exception {
    }

    @Override
    public void close() {
    }
}

