/*
 * Decompiled with CFR 0.152.
 */
package tools.mv.backend.drive;

import com.google.api.client.googleapis.auth.oauth2.GoogleIdToken;
import com.google.api.client.googleapis.auth.oauth2.GoogleTokenResponse;
import com.google.api.services.drive.Drive;
import com.google.api.services.drive.model.About;
import com.google.api.services.drive.model.User;
import tools.mv.backend.drive.BaseDrive;
import tools.mv.backend.drive.Google;
import tools.mv.backend.exception.BusinessException;
import tools.mv.backend.model.AppDrive;
import tools.mv.backend.model.AuthParam;
import tools.mv.backend.model.DeleteParam;
import tools.mv.backend.model.DownloadParam;
import tools.mv.backend.model.DownloadResult;
import tools.mv.backend.model.DriveAuth;
import tools.mv.backend.model.DriveInfo;
import tools.mv.backend.model.ListParam;
import tools.mv.backend.model.ListResult;
import tools.mv.backend.model.MkdirParam;
import tools.mv.backend.model.Node;
import tools.mv.backend.model.RenameParam;
import tools.mv.backend.model.UploadParam;
import tools.mv.backend.util.StringUtil;

public class GoogleDrive
extends Google
implements BaseDrive {
    private DriveAuth auth;
    private Drive client;

    public GoogleDrive(AppDrive appDrive) throws Exception {
        super(appDrive);
        this.auth = appDrive.getAuth();
        if (this.auth != null) {
            this.client = this.createClient(this.auth.getAccess());
        }
    }

    private Drive createClient(String access) throws Exception {
        return super.buildDriveByToken(access);
    }

    @Override
    public String auth(AuthParam param) throws Exception {
        return super.auth(param.getState(), true);
    }

    @Override
    public DriveAuth callback(AuthParam param) throws Exception {
        GoogleTokenResponse tokenResponse = super.callback(param.getCode());
        String access = tokenResponse.getAccessToken();
        String refresh = tokenResponse.getRefreshToken();
        String scope = tokenResponse.getScope();
        if (!(scope.contains("drive") && scope.contains("email") && scope.contains("profile") && scope.contains("openid"))) {
            throw new BusinessException("Please re-authorize and enable Google Drive permissions to continue.", new Object[0]);
        }
        GoogleIdToken.Payload payload = super.decodeIdToken(tokenResponse.getIdToken());
        String sub = payload.getSubject();
        this.auth = DriveAuth.builder().uuid(sub).access(access).refresh(refresh).build();
        this.client = this.createClient(access);
        return this.auth;
    }

    @Override
    public DriveInfo info() throws Exception {
        About about = (About)this.client.about().get().setFields("user,storageQuota").execute();
        About.StorageQuota quota = about.getStorageQuota();
        User user = about.getUser();
        String name = user.getDisplayName();
        String email = user.getEmailAddress();
        Long total = quota.getLimit();
        Long used = quota.getUsage();
        return DriveInfo.builder().name(name).email(email).used(used).total(total).build();
    }

    @Override
    public ListResult list(ListParam param) throws Exception {
        if (param.getNode() == null) {
            return super.virtualFolder();
        }
        return super.listFiles(this.client, param);
    }

    @Override
    public Node mkdir(MkdirParam param) throws Exception {
        super.createFolderCheck(param);
        return super.createFolder(this.client, param);
    }

    @Override
    public DownloadResult download(DownloadParam param) throws Exception {
        return super.downloadFile(this.client, param);
    }

    @Override
    public Node upload(UploadParam param) throws Exception {
        super.uploadFileCheck(param);
        return super.uploadFile(this.client, param);
    }

    @Override
    public Node rename(RenameParam param) throws Exception {
        super.checkRenameDelete(param.getNode().getId());
        return super.rename(this.client, param);
    }

    @Override
    public void delete(DeleteParam param) throws Exception {
        super.checkRenameDelete(param.getNode().getId());
        super.delete(this.client, param);
    }

    @Override
    public boolean expire(Exception e) {
        String msg = StringUtil.getMsg(e);
        return msg.contains("access token");
    }

    @Override
    public DriveAuth refresh() throws Exception {
        GoogleTokenResponse response = super.refresh(this.auth.getRefresh());
        String access = response.getAccessToken();
        String refresh = response.getRefreshToken();
        this.auth.setAccess(access);
        if (refresh != null) {
            this.auth.setRefresh(refresh);
        }
        this.client = this.createClient(access);
        return this.auth;
    }

    @Override
    public void newAuth(DriveAuth auth) throws Exception {
        this.auth = auth;
        this.client = this.createClient(auth.getAccess());
    }

    @Override
    public void close() {
        this.auth = null;
        this.client = null;
    }
}

