/*
 * Decompiled with CFR 0.152.
 */
package tools.mv.backend.drive;

import com.google.api.client.googleapis.auth.oauth2.GoogleAuthorizationCodeTokenRequest;
import com.google.api.client.googleapis.auth.oauth2.GoogleIdToken;
import com.google.api.client.googleapis.auth.oauth2.GoogleRefreshTokenRequest;
import com.google.api.client.googleapis.auth.oauth2.GoogleTokenResponse;
import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.googleapis.json.GoogleJsonError;
import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.api.client.googleapis.media.MediaHttpUploader;
import com.google.api.client.googleapis.media.MediaHttpUploaderProgressListener;
import com.google.api.client.http.AbstractInputStreamContent;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.InputStreamContent;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import com.google.api.services.drive.Drive;
import com.google.api.services.drive.model.Drive;
import com.google.api.services.drive.model.DriveList;
import com.google.api.services.drive.model.File;
import com.google.api.services.drive.model.FileList;
import com.google.auth.Credentials;
import com.google.auth.http.HttpCredentialsAdapter;
import com.google.auth.oauth2.AccessToken;
import com.google.auth.oauth2.GoogleCredentials;
import java.io.InputStream;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import tools.mv.backend.drive.DriveParent;
import tools.mv.backend.model.AppDrive;
import tools.mv.backend.model.AppInfo;
import tools.mv.backend.model.DeleteParam;
import tools.mv.backend.model.DownloadParam;
import tools.mv.backend.model.DownloadResult;
import tools.mv.backend.model.GoogleExport;
import tools.mv.backend.model.ListParam;
import tools.mv.backend.model.ListResult;
import tools.mv.backend.model.MkdirParam;
import tools.mv.backend.model.Node;
import tools.mv.backend.model.RenameParam;
import tools.mv.backend.model.UploadParam;
import tools.mv.backend.util.ProgMediaHttpUploaderProgressListener;
import tools.mv.backend.util.StringUtil;

public abstract class Google
extends DriveParent {
    private static final NetHttpTransport HTTP_TRANSPORT;
    private static final JsonFactory JSON_FACTORY;
    private static final Map<String, GoogleExport> MIME;
    private static final String NODE_FIELDS = "id, name, size, mimeType, modifiedTime, shortcutDetails(targetId,targetMimeType)";
    private static final String MY_DRIVE = "root";
    private static final String SHARED_DRIVES = "sharedDrives";
    private static final String SHARED_WITH_ME = "sharedWithMe";
    public static final String CUSTOMER_PREFIX = "customer_";
    private static final String APP_NAME = "MV Tools";
    private final AppInfo app;

    public Google(AppDrive appDrive) {
        super(appDrive);
        this.app = appDrive.getInfo();
    }

    public com.google.api.services.drive.Drive buildDriveByToken(String accessToken) {
        GoogleCredentials credential = GoogleCredentials.create((AccessToken)new AccessToken(accessToken, null));
        return this.buildDrive(credential);
    }

    private com.google.api.services.drive.Drive buildDrive(GoogleCredentials credential) {
        HttpCredentialsAdapter httpRequestInitializer = new HttpCredentialsAdapter((Credentials)credential);
        return new Drive.Builder((HttpTransport)HTTP_TRANSPORT, JSON_FACTORY, (HttpRequestInitializer)httpRequestInitializer).setApplicationName(APP_NAME).setHttpRequestInitializer(request -> {
            httpRequestInitializer.initialize(request);
            this.configTimeOut(request);
        }).build();
    }

    private void configTimeOut(HttpRequest request) {
        request.setReadTimeout(60000);
        request.setWriteTimeout(60000);
        request.setConnectTimeout(6000);
    }

    public String auth(String state, boolean isAuthDrive) {
        return "https://accounts.google.com/o/oauth2/v2/auth?scope=openid email profile" + (isAuthDrive ? " https://www.googleapis.com/auth/drive" : "") + "&access_type=offline&include_granted_scopes=true&response_type=code&prompt=consent&state=" + state + "&redirect_uri=" + this.app.getCallback() + "&client_id=" + this.app.getKey();
    }

    public GoogleTokenResponse callback(String code) throws Exception {
        return new GoogleAuthorizationCodeTokenRequest((HttpTransport)HTTP_TRANSPORT, JSON_FACTORY, "https://oauth2.googleapis.com/token", this.app.getKey(), this.app.getSecret(), code, this.app.getCallback()).execute();
    }

    public GoogleTokenResponse refresh(String refreshToken) throws Exception {
        return new GoogleRefreshTokenRequest((HttpTransport)HTTP_TRANSPORT, JSON_FACTORY, refreshToken, this.app.getKey(), this.app.getSecret()).execute();
    }

    public GoogleIdToken.Payload decodeIdToken(String idTokenStr) throws Exception {
        return GoogleIdToken.parse((JsonFactory)JSON_FACTORY, (String)idTokenStr).getPayload();
    }

    public ListResult virtualFolder() {
        ArrayList<Node> nodes = new ArrayList<Node>();
        nodes.add(this.createMkdirNode(MY_DRIVE, "My Drive"));
        nodes.add(this.createMkdirNode(SHARED_DRIVES, "Shared drives"));
        nodes.add(this.createMkdirNode(SHARED_WITH_ME, "Shared with me"));
        return ListResult.builder().nodes(nodes).build();
    }

    public ListResult listFiles(com.google.api.services.drive.Drive client, ListParam param) throws Exception {
        FileList fileList;
        Node node = param.getNode();
        String start = param.getStart();
        ArrayList<Node> nodes = new ArrayList<Node>();
        String id = node.getId();
        if (id.equals(SHARED_WITH_ME)) {
            fileList = this.getFileList(client, start, this.getSharedWithMeQuery());
        } else {
            if (id.equals(SHARED_DRIVES)) {
                Drive.Drives.List request = client.drives().list().setFields("nextPageToken, drives(id, name, createdTime)").setPageSize(Integer.valueOf(100));
                DriveList driveList = (DriveList)request.execute();
                for (Drive drive : driveList.getDrives()) {
                    nodes.add(this.createMkdirNode(drive.getId(), drive.getName(), drive.getCreatedTime().getValue()));
                }
                return ListResult.builder().nodes(nodes).next(driveList.getNextPageToken()).build();
            }
            fileList = this.getFileList(client, start, this.getFolderQuery(id));
        }
        this.addNodes(client, nodes, fileList);
        return ListResult.builder().nodes(nodes).next(fileList.getNextPageToken()).build();
    }

    private String getSharedWithMeQuery() {
        return "sharedWithMe and trashed = false";
    }

    private String getFolderQuery(String id) {
        return "'" + id + "' in parents and trashed = false";
    }

    private FileList getFileList(com.google.api.services.drive.Drive client, String start, String query) throws Exception {
        Drive.Files.List list = client.files().list().setQ(query).setSupportsAllDrives(Boolean.valueOf(true)).setIncludeItemsFromAllDrives(Boolean.valueOf(true)).setFields("nextPageToken, files(id, name, size, mimeType, modifiedTime, shortcutDetails(targetId,targetMimeType))").setOrderBy("folder, name").setPageSize(Integer.valueOf(1000));
        if (start != null && !start.isEmpty()) {
            list.setPageToken(start);
        }
        return (FileList)list.execute();
    }

    private void addNodes(com.google.api.services.drive.Drive client, List<Node> nodes, FileList fileList) {
        List files = fileList.getFiles();
        for (File file : files) {
            Node node = this.toNode(client, file);
            if (node == null) continue;
            if (this.isOnlineFile(node)) {
                GoogleExport export = this.getGoogleExport(node);
                if (export == null) {
                    node.setSize(null);
                } else {
                    node.setSize(null);
                    node.setName(node.getName() + export.getSuffix());
                }
            }
            nodes.add(node);
        }
    }

    private boolean isOnlineFile(Node node) {
        return !node.isDir() && node.getType().startsWith("application/vnd.google-apps.");
    }

    private GoogleExport getGoogleExport(Node node) {
        return MIME.get(node.getType());
    }

    public Node toNode(com.google.api.services.drive.Drive client, File file) {
        boolean isShortcut = false;
        String mimeType = file.getMimeType();
        if ("application/vnd.google-apps.shortcut".equals(mimeType)) {
            mimeType = file.getShortcutDetails().getTargetMimeType();
            isShortcut = true;
        }
        boolean isDir = "application/vnd.google-apps.folder".equals(mimeType);
        Node node = new Node();
        node.setId(isShortcut ? file.getShortcutDetails().getTargetId() : file.getId());
        node.setType(mimeType);
        node.setName(file.getName());
        node.setDir(isDir);
        if (!isDir) {
            if (isShortcut) {
                try {
                    File target = (File)client.files().get(file.getShortcutDetails().getTargetId()).setFields(NODE_FIELDS).execute();
                    node.setSize(target.getSize());
                }
                catch (Exception e) {
                    return null;
                }
            } else {
                node.setSize(file.getSize());
            }
        }
        node.setTime(file.getModifiedTime().getValue());
        return node;
    }

    public Node createFolder(com.google.api.services.drive.Drive client, MkdirParam param) throws Exception {
        File folderMetadata = new File();
        folderMetadata.setName(param.getName());
        folderMetadata.setMimeType("application/vnd.google-apps.folder");
        folderMetadata.setParents(Collections.singletonList(param.getNode().getId()));
        File folder = (File)client.files().create(folderMetadata).setSupportsAllDrives(Boolean.valueOf(true)).setFields(NODE_FIELDS).execute();
        return this.toNode(client, folder);
    }

    public void createFolderCheck(MkdirParam param) throws Exception {
        Node node = param.getNode();
        String id = this.folderId(MY_DRIVE, node);
        if (node == null || this.isLimitedFolder(id)) {
            throw new Exception("Folder creation not allowed here");
        }
    }

    private boolean isLimitedFolder(String id) {
        return id.equals(SHARED_DRIVES) || id.equals(SHARED_WITH_ME) || id.startsWith(CUSTOMER_PREFIX);
    }

    public DownloadResult downloadFile(com.google.api.services.drive.Drive client, DownloadParam param) throws Exception {
        Node node = param.getNode();
        String id = node.getId();
        if (this.isOnlineFile(node)) {
            GoogleExport export = this.getGoogleExport(node);
            if (export == null) {
                throw new Exception("The file does not support exporting.");
            }
            this.in = client.files().export(id, export.getExport()).executeMediaAsInputStream();
        } else {
            this.in = client.files().get(id).setAcknowledgeAbuse(Boolean.valueOf(true)).executeMediaAsInputStream();
        }
        return DownloadResult.builder().node(node).in(this.in).build();
    }

    public void uploadFileCheck(UploadParam param) throws Exception {
        Node node = param.getNode();
        String id = this.folderId(MY_DRIVE, node);
        if (node == null || this.isLimitedFolder(id)) {
            throw new Exception("File upload not allowed here");
        }
    }

    public Node uploadFile(com.google.api.services.drive.Drive client, UploadParam param) throws Exception {
        File fileMetadata = new File();
        fileMetadata.setName(param.getName());
        fileMetadata.setParents(Collections.singletonList(param.getNode().getId()));
        DownloadResult result = param.getResult();
        InputStream in = result.getIn();
        Node fromNode = result.getNode();
        InputStreamContent mediaContent = new InputStreamContent("application/octet-stream", in);
        Drive.Files.Create create = client.files().create(fileMetadata, (AbstractInputStreamContent)mediaContent).setSupportsAllDrives(Boolean.valueOf(true)).setFields(NODE_FIELDS);
        MediaHttpUploader uploader = create.getMediaHttpUploader();
        uploader.setChunkSize(0x500000);
        uploader.setProgressListener((MediaHttpUploaderProgressListener)new ProgMediaHttpUploaderProgressListener(fromNode, this));
        try {
            File file = (File)create.execute();
            return this.toNode(client, file);
        }
        catch (GoogleJsonResponseException | SocketTimeoutException e) {
            int code;
            GoogleJsonResponseException json;
            GoogleJsonError details;
            boolean maybeSuccess = false;
            if (e instanceof SocketTimeoutException) {
                maybeSuccess = true;
            } else if (e instanceof GoogleJsonResponseException && (details = (json = (GoogleJsonResponseException)e).getDetails()) != null && (code = details.getCode()) == 500) {
                maybeSuccess = true;
            }
            if (maybeSuccess) {
                logger.info("Google-like cloud drive, check if file exists successfully: " + result.getNode().getName());
                Thread.sleep(3000L);
                Node existFile = this.getExistFile(client, param.getNode(), result.getNode());
                if (existFile != null) {
                    return existFile;
                }
                throw e;
            }
            throw e;
        }
    }

    private Node getExistFile(com.google.api.services.drive.Drive client, Node folder, Node file) throws Exception {
        ListParam param = new ListParam(folder, null);
        while (true) {
            ListResult result = this.listFiles(client, param);
            List<Node> nodes = result.getNodes();
            String next = result.getNext();
            for (Node node : nodes) {
                if (node.isDir() || !node.getName().equals(file.getName())) continue;
                logger.info("Google-like cloud drive, file detected: " + file.getName());
                return node;
            }
            if (next == null) break;
            param.setStart(next);
        }
        logger.info("Google-like cloud drive, file not detected: " + file.getName());
        return null;
    }

    public void checkRenameDelete(String id) throws Exception {
        boolean isLimitId;
        boolean bl = isLimitId = id.equals(MY_DRIVE) || id.equals(SHARED_DRIVES) || id.equals(SHARED_WITH_ME) || id.startsWith(CUSTOMER_PREFIX);
        if (isLimitId) {
            throw new Exception("Renaming and deleting not allowed here");
        }
    }

    public Node rename(com.google.api.services.drive.Drive client, RenameParam param) throws Exception {
        Node node = param.getNode();
        String id = node.getId();
        String name = param.getName();
        File metadata = new File();
        metadata.setName(name);
        File updated = (File)client.files().update(id, metadata).setSupportsAllDrives(Boolean.valueOf(true)).setFields(NODE_FIELDS).execute();
        return this.toNode(client, updated);
    }

    public void delete(com.google.api.services.drive.Drive client, DeleteParam param) throws Exception {
        Node node = param.getNode();
        String id = node.getId();
        File metadata = new File();
        metadata.setTrashed(Boolean.valueOf(true));
        client.files().update(id, metadata).setSupportsAllDrives(Boolean.valueOf(true)).execute();
    }

    @Override
    public boolean isLimited(Exception e) {
        GoogleJsonResponseException json;
        GoogleJsonError details;
        if (e instanceof SocketTimeoutException) {
            return true;
        }
        if (e instanceof GoogleJsonResponseException && (details = (json = (GoogleJsonResponseException)((Object)e)).getDetails()) != null) {
            int code = details.getCode();
            if (code == 500 || code == 503) {
                return true;
            }
            List errors = details.getErrors();
            if (!errors.isEmpty()) {
                String reason = ((GoogleJsonError.ErrorInfo)errors.get(0)).getReason();
                return "userRateLimitExceeded".equals(reason);
            }
        }
        String msg = StringUtil.getMsg(e);
        if (e instanceof SocketException && msg.contains("Unexpected end of file from server")) {
            return true;
        }
        return e instanceof GoogleJsonResponseException && msg.contains("503 Service Unavailable");
    }

    @Override
    public boolean isWarning(Exception e) {
        if (e instanceof GoogleJsonResponseException) {
            List errors;
            GoogleJsonResponseException json = (GoogleJsonResponseException)((Object)e);
            GoogleJsonError details = json.getDetails();
            if (details != null && !(errors = details.getErrors()).isEmpty()) {
                String reason = ((GoogleJsonError.ErrorInfo)errors.get(0)).getReason();
                if ("insufficientParentPermissions".equals(reason)) {
                    return true;
                }
                if ("exportSizeLimitExceeded".equals(reason)) {
                    return true;
                }
                if ("insufficientPermissions".equals(reason)) {
                    return true;
                }
                if ("storageQuotaExceeded".equals(reason)) {
                    return true;
                }
                if ("myDriveHierarchyDepthLimitExceeded".equals(reason)) {
                    return true;
                }
                if ("downloadQuotaExceeded".equals(reason)) {
                    return true;
                }
                return "cannotDownloadAbusiveFile".equals(reason);
            }
        } else {
            String msg = StringUtil.getMsg(e);
            if (msg.contains("The file does not support exporting.")) {
                return true;
            }
            if (msg.contains("Insufficient drive space")) {
                return true;
            }
        }
        return false;
    }

    static {
        MIME = new HashMap<String, GoogleExport>();
        try {
            JSON_FACTORY = GsonFactory.getDefaultInstance();
            HTTP_TRANSPORT = GoogleNetHttpTransport.newTrustedTransport();
            MIME.put("application/vnd.google-apps.presentation", new GoogleExport("application/vnd.openxmlformats-officedocument.presentationml.presentation", ".pptx"));
            MIME.put("application/vnd.google-apps.document", new GoogleExport("application/vnd.openxmlformats-officedocument.wordprocessingml.document", ".docx"));
            MIME.put("application/vnd.google-apps.spreadsheet", new GoogleExport("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", ".xlsx"));
            MIME.put("application/vnd.google-apps.script", new GoogleExport("application/vnd.google-apps.script+json", ".json"));
            MIME.put("application/vnd.google-apps.mail-layout", new GoogleExport("text/plain", ".txt"));
            MIME.put("application/vnd.google-apps.form", new GoogleExport("application/zip", ".zip"));
            MIME.put("application/vnd.google-apps.jam", new GoogleExport("application/pdf", ".pdf"));
            MIME.put("application/vnd.google-apps.drawing", new GoogleExport("image/png", ".png"));
            MIME.put("application/vnd.google-apps.site", new GoogleExport("text/plain", ".txt"));
        }
        catch (Exception e) {
            throw new RuntimeException("Google Drive initialization error", e);
        }
    }
}

