/*
 * Decompiled with CFR 0.152.
 */
package tools.mv.backend.drive;

import cn.hutool.crypto.digest.DigestUtil;
import java.net.BindException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Calendar;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPConnectionClosedException;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.commons.net.ftp.FTPSClient;
import tools.mv.backend.drive.BaseDrive;
import tools.mv.backend.drive.DriveParent;
import tools.mv.backend.exception.DriveLimitException;
import tools.mv.backend.model.AppDrive;
import tools.mv.backend.model.AuthParam;
import tools.mv.backend.model.DeleteParam;
import tools.mv.backend.model.DownloadParam;
import tools.mv.backend.model.DownloadResult;
import tools.mv.backend.model.DriveAuth;
import tools.mv.backend.model.DriveInfo;
import tools.mv.backend.model.FTPParam;
import tools.mv.backend.model.ListParam;
import tools.mv.backend.model.ListResult;
import tools.mv.backend.model.MkdirParam;
import tools.mv.backend.model.Node;
import tools.mv.backend.model.RenameParam;
import tools.mv.backend.model.UploadParam;
import tools.mv.backend.util.StringUtil;

public class FTP
extends DriveParent
implements BaseDrive {
    private FTPParam ftpParam;
    private FTPClient ftpClient;
    private boolean hasStream;

    public FTP(AppDrive appDrive) throws Exception {
        super(appDrive);
        DriveAuth auth = appDrive.getAuth();
        if (auth != null) {
            this.initAuth(auth.getFtp());
        }
    }

    @Override
    public DriveAuth callback(AuthParam param) throws Exception {
        this.initAuth(param.getFtp());
        String uuid = DigestUtil.md5Hex((String)(this.ftpParam.getHost() + this.ftpParam.getPort() + this.ftpParam.getUsername()));
        return DriveAuth.builder().uuid(uuid).ftp(this.ftpParam).build();
    }

    @Override
    public DriveInfo info() {
        return DriveInfo.builder().ftp(this.ftpParam.toInfo()).build();
    }

    @Override
    public ListResult list(ListParam param) throws Exception {
        String id = this.folderId(this.ftpParam.getPath(), param.getNode());
        boolean changed = this.ftpClient.changeWorkingDirectory(id);
        if (!changed) {
            throw new DriveLimitException(this.ftpClient.getReplyString());
        }
        FTPFile[] files = this.ftpClient.listFiles();
        if (files == null) {
            throw new Exception(this.ftpClient.getReplyString());
        }
        if (files.length == 0 && !FTPReply.isPositiveCompletion((int)this.ftpClient.getReplyCode())) {
            throw new DriveLimitException(this.ftpClient.getReplyString());
        }
        id = this.prefix(id);
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (FTPFile file : files) {
            boolean isDir = file.isDirectory();
            String name = file.getName();
            if (isDir && (name.equals(".") || name.equals(".."))) continue;
            nodes.add(this.toNode(id, file));
        }
        return ListResult.builder().nodes(nodes).build();
    }

    private Node toNode(String id, FTPFile file) {
        Calendar calendar;
        boolean isDir = file.isDirectory();
        Node node = new Node();
        node.setId(id + "/" + file.getName());
        node.setType(isDir ? "folder" : "file");
        node.setName(file.getName());
        node.setDir(isDir);
        if (!isDir) {
            node.setSize(file.getSize());
        }
        if ((calendar = file.getTimestamp()) != null) {
            node.setTime(calendar.getTimeInMillis());
        }
        return node;
    }

    @Override
    public Node mkdir(MkdirParam param) throws Exception {
        String name = param.getName();
        String path = this.fullPath(this.ftpParam.getPath(), param.getNode(), name);
        boolean created = this.ftpClient.makeDirectory(path);
        if (created) {
            return this.createMkdirNode(path, name);
        }
        throw new DriveLimitException(this.ftpClient.getReplyString());
    }

    @Override
    public DownloadResult download(DownloadParam param) throws Exception {
        Node node = param.getNode();
        this.in = this.ftpClient.retrieveFileStream(node.getId());
        if (this.in == null) {
            throw new DriveLimitException(this.ftpClient.getReplyString());
        }
        this.hasStream = true;
        return DownloadResult.builder().node(node).in(this.in).build();
    }

    @Override
    public Node upload(UploadParam param) throws Exception {
        String name = param.getName();
        String path = this.fullPath(this.ftpParam.getPath(), param.getNode(), name);
        this.out = this.ftpClient.storeFileStream(path);
        if (this.out == null) {
            throw new DriveLimitException(this.ftpClient.getReplyString());
        }
        this.hasStream = true;
        DownloadResult result = param.getResult();
        long sum = this.readAndWrite(result.getIn(), this.out, result.getNode());
        return this.createUploadNode(path, name, sum);
    }

    @Override
    public Node rename(RenameParam param) throws Exception {
        String parentPath;
        String newPath;
        Node node = param.getNode();
        String name = param.getName();
        String oldPath = node.getId();
        boolean renamed = this.ftpClient.rename(oldPath, newPath = this.createNewPath(parentPath = this.parentPath(oldPath), name));
        if (renamed) {
            node.setId(newPath);
            node.setName(name);
            return node;
        }
        throw new DriveLimitException(this.ftpClient.getReplyString());
    }

    @Override
    public void delete(DeleteParam param) throws Exception {
        Node node = param.getNode();
        String path = node.getId();
        if (node.isDir()) {
            this.deleteDirectoryRecursive(path);
        } else {
            boolean deleted = this.ftpClient.deleteFile(path);
            if (!deleted) {
                throw new DriveLimitException(this.ftpClient.getReplyString());
            }
        }
    }

    private void deleteDirectoryRecursive(String dirPath) throws Exception {
        boolean removed;
        FTPFile[] files = this.ftpClient.listFiles(dirPath);
        if (files != null) {
            for (FTPFile file : files) {
                String childPath = dirPath + "/" + file.getName();
                if (file.isDirectory()) {
                    this.deleteDirectoryRecursive(childPath);
                    continue;
                }
                if (this.ftpClient.deleteFile(childPath)) continue;
                throw new Exception(this.ftpClient.getReplyString());
            }
        }
        if (!(removed = this.ftpClient.removeDirectory(dirPath))) {
            throw new Exception(this.ftpClient.getReplyString());
        }
    }

    @Override
    public boolean expire(Exception e) {
        if (e instanceof BindException) {
            return false;
        }
        if (e instanceof SocketException) {
            return true;
        }
        return e instanceof FTPConnectionClosedException;
    }

    @Override
    public DriveAuth refresh() throws Exception {
        this.closeRes(this.ftpClient);
        this.initAuth(this.ftpParam);
        return null;
    }

    @Override
    public void newAuth(DriveAuth auth) throws Exception {
        this.closeRes(this.ftpClient);
        this.initAuth(auth.getFtp());
    }

    @Override
    public void finish() throws Exception {
        super.finish();
        if (this.ftpClient != null && this.ftpClient.isConnected() && this.hasStream) {
            this.hasStream = false;
            if (!this.ftpClient.completePendingCommand()) {
                throw new Exception(this.ftpClient.getReplyString());
            }
        }
    }

    private void initAuth(FTPParam param) throws Exception {
        this.ftpParam = param;
        this.ftpClient = this.getFTPClient(this.ftpParam);
    }

    @Override
    public void close() {
        this.closeRes(this.ftpClient);
        this.ftpParam = null;
        this.ftpClient = null;
    }

    @Override
    public boolean isLimited(Exception e) {
        String msg = StringUtil.getMsg(e);
        if (msg.contains("Timed out waiting for initial connect reply")) {
            return true;
        }
        if (msg.contains("java.net.Socket.getInetAddress()")) {
            return true;
        }
        return e instanceof BindException || e instanceof SocketTimeoutException;
    }

    private FTPClient getFTPClient(FTPParam param) throws Exception {
        Object ftpClient = "ftps-explicit".equalsIgnoreCase(param.getProtocol()) ? new FTPSClient(false) : ("ftps-implicit".equalsIgnoreCase(param.getProtocol()) ? new FTPSClient(true) : new FTPClient());
        try {
            if (param.getEncoding() != null) {
                ftpClient.setControlEncoding(param.getEncoding());
            }
            ftpClient.setConnectTimeout(30000);
            ftpClient.connect(param.getHost(), param.getPort());
            int replyCode = ftpClient.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)replyCode)) {
                throw new Exception(ftpClient.getReplyString());
            }
            ftpClient.setSoTimeout(60000);
            boolean success = ftpClient.login(param.getUsername(), param.getPassword());
            if (!success) {
                throw new Exception(ftpClient.getReplyString());
            }
            ftpClient.setControlKeepAliveTimeout(Duration.ofSeconds(30L));
            ftpClient.setControlKeepAliveReplyTimeout(Duration.ofSeconds(30L));
            ftpClient.setFileType(2);
            if (param.isPassive()) {
                ftpClient.enterLocalPassiveMode();
            } else {
                ftpClient.enterLocalActiveMode();
            }
            if (param.getPath() == null || param.getPath().trim().isEmpty()) {
                param.setPath(ftpClient.printWorkingDirectory());
            } else {
                String path = param.getPath().trim();
                boolean changed = ftpClient.changeWorkingDirectory(path);
                if (!changed) {
                    throw new Exception(ftpClient.getReplyString());
                }
                param.setPath(path);
            }
            ftpClient.setListHiddenFiles(true);
            ftpClient.listFiles();
            int code = ftpClient.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)code)) {
                ftpClient.setListHiddenFiles(false);
            }
            return ftpClient;
        }
        catch (Exception e) {
            this.closeRes((FTPClient)ftpClient);
            throw e;
        }
    }

    private void closeRes(FTPClient ftpClient) {
        if (ftpClient != null && ftpClient.isConnected()) {
            try {
                ftpClient.logout();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                ftpClient.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

