/*
 * Decompiled with CFR 0.152.
 */
package tools.mv.backend.drive;

import com.dropbox.core.BadResponseCodeException;
import com.dropbox.core.DbxDownloader;
import com.dropbox.core.DbxRequestConfig;
import com.dropbox.core.InvalidAccessTokenException;
import com.dropbox.core.NetworkIOException;
import com.dropbox.core.RateLimitException;
import com.dropbox.core.RetryException;
import com.dropbox.core.ServerException;
import com.dropbox.core.v2.DbxClientV2;
import com.dropbox.core.v2.files.CommitInfo;
import com.dropbox.core.v2.files.CreateFolderResult;
import com.dropbox.core.v2.files.FileMetadata;
import com.dropbox.core.v2.files.FolderMetadata;
import com.dropbox.core.v2.files.ListFolderResult;
import com.dropbox.core.v2.files.Metadata;
import com.dropbox.core.v2.files.UploadSessionAppendV2Uploader;
import com.dropbox.core.v2.files.UploadSessionCursor;
import com.dropbox.core.v2.files.UploadSessionFinishUploader;
import com.dropbox.core.v2.files.UploadSessionStartResult;
import com.dropbox.core.v2.files.UploadSessionStartUploader;
import com.dropbox.core.v2.files.WriteMode;
import com.dropbox.core.v2.users.DbxUserUsersRequests;
import com.dropbox.core.v2.users.FullAccount;
import com.dropbox.core.v2.users.SpaceAllocation;
import com.dropbox.core.v2.users.SpaceUsage;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.apache.http.client.fluent.Form;
import org.apache.http.client.fluent.Request;
import org.json.JSONObject;
import org.springframework.web.util.UriComponentsBuilder;
import tools.mv.backend.drive.BaseDrive;
import tools.mv.backend.drive.DriveParent;
import tools.mv.backend.model.AppDrive;
import tools.mv.backend.model.AppInfo;
import tools.mv.backend.model.AuthParam;
import tools.mv.backend.model.DeleteParam;
import tools.mv.backend.model.DownloadParam;
import tools.mv.backend.model.DownloadResult;
import tools.mv.backend.model.DriveAuth;
import tools.mv.backend.model.DriveInfo;
import tools.mv.backend.model.ListParam;
import tools.mv.backend.model.ListResult;
import tools.mv.backend.model.MkdirParam;
import tools.mv.backend.model.Node;
import tools.mv.backend.model.RenameParam;
import tools.mv.backend.model.UploadParam;
import tools.mv.backend.util.ProgInputStream;
import tools.mv.backend.util.StringUtil;

public class Dropbox
extends DriveParent
implements BaseDrive {
    private static final String SCOPES = "files.metadata.read files.metadata.write files.content.read files.content.write account_info.read";
    private static final int SMALL_FILE_SIZE = 0x6400000;
    private static final int CHUNK_SIZE = 0x400000;
    private static final String ROOT_ID = "";
    private final AppInfo app;
    private DriveAuth auth;
    private DbxClientV2 client;
    private DbxDownloader<FileMetadata> download;

    public Dropbox(AppDrive appDrive) {
        super(appDrive);
        this.app = appDrive.getInfo();
        this.auth = appDrive.getAuth();
        if (this.auth != null) {
            this.client = this.createClient(this.auth.getAccess());
        }
    }

    private DbxClientV2 createClient(String access) {
        return new DbxClientV2(DbxRequestConfig.newBuilder((String)"MV Tools").build(), access);
    }

    @Override
    public String auth(AuthParam param) throws Exception {
        return UriComponentsBuilder.fromUriString((String)"https://www.dropbox.com/oauth2/authorize").queryParam("client_id", new Object[]{this.app.getKey()}).queryParam("response_type", new Object[]{"code"}).queryParam("redirect_uri", new Object[]{this.app.getCallback()}).queryParam("token_access_type", new Object[]{"offline"}).queryParam("scope", new Object[]{SCOPES}).queryParam("state", new Object[]{param.getState()}).queryParam("force_reapprove", new Object[]{true}).build().toUriString();
    }

    private JSONObject postAuth(Form form) throws Exception {
        String responseStr = Request.Post((String)"https://api.dropboxapi.com/oauth2/token").connectTimeout(6000).socketTimeout(60000).bodyForm((Iterable)form.build(), StandardCharsets.UTF_8).execute().returnContent().asString();
        return new JSONObject(responseStr);
    }

    @Override
    public DriveAuth callback(AuthParam param) throws Exception {
        Form form = Form.form().add("code", param.getCode()).add("grant_type", "authorization_code").add("client_id", this.app.getKey()).add("client_secret", this.app.getSecret()).add("redirect_uri", this.app.getCallback());
        JSONObject json = this.postAuth(form);
        String uid = json.getString("uid");
        String access = json.getString("access_token");
        String refresh = json.getString("refresh_token");
        this.auth = DriveAuth.builder().uuid(uid).access(access).refresh(refresh).build();
        this.client = this.createClient(access);
        return this.auth;
    }

    @Override
    public DriveInfo info() throws Exception {
        DbxUserUsersRequests user = this.client.users();
        FullAccount account = user.getCurrentAccount();
        DriveInfo info = new DriveInfo();
        info.setEmail(account.getEmail());
        info.setName(account.getName().getDisplayName());
        SpaceUsage usage = user.getSpaceUsage();
        info.setUsed(usage.getUsed());
        SpaceAllocation allocation = usage.getAllocation();
        if (allocation.isIndividual()) {
            info.setTotal(allocation.getIndividualValue().getAllocated());
        }
        return info;
    }

    @Override
    public ListResult list(ListParam param) throws Exception {
        String id = this.folderId(ROOT_ID, param.getNode());
        String start = param.getStart();
        ListFolderResult result = start == null || start.isEmpty() ? this.client.files().listFolder(id) : this.client.files().listFolderContinue(start);
        String next = result.getHasMore() ? result.getCursor() : null;
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (Metadata entry : result.getEntries()) {
            nodes.add(this.toNode(entry));
        }
        return ListResult.builder().nodes(nodes).next(next).build();
    }

    private Node toNode(Metadata entry) throws Exception {
        Node node = new Node();
        if (entry instanceof FileMetadata) {
            FileMetadata file = (FileMetadata)entry;
            node.setId(file.getPathLower());
            node.setType("file");
            node.setName(file.getName());
            node.setDir(false);
            node.setSize(file.getSize());
            node.setTime(file.getServerModified().getTime());
            return node;
        }
        if (entry instanceof FolderMetadata) {
            FolderMetadata folder = (FolderMetadata)entry;
            node.setId(folder.getPathLower());
            node.setType("folder");
            node.setName(folder.getName());
            node.setDir(true);
            return node;
        }
        logger.warn("Unsupported metadata type: {}", (Object)entry);
        throw new Exception("Unsupported metadata type");
    }

    @Override
    public Node mkdir(MkdirParam param) throws Exception {
        String newFolderPath = this.fullPath(ROOT_ID, param.getNode(), param.getName());
        CreateFolderResult result = this.client.files().createFolderV2(newFolderPath);
        return this.toNode((Metadata)result.getMetadata());
    }

    @Override
    public DownloadResult download(DownloadParam param) throws Exception {
        Node node = param.getNode();
        this.download = this.client.files().download(node.getId());
        this.in = this.download.getInputStream();
        return DownloadResult.builder().node(node).in(this.in).build();
    }

    @Override
    public Node upload(UploadParam param) throws Exception {
        String path = this.fullPath(ROOT_ID, param.getNode(), param.getName());
        DownloadResult downloadResult = param.getResult();
        Long size = downloadResult.getNode().getSize();
        if (size == null || size <= 0x6400000L) {
            return this.uploadSmallFile(path, downloadResult);
        }
        return this.uploadLargeFile(path, downloadResult);
    }

    @Override
    public Node rename(RenameParam param) throws Exception {
        String oldPath = param.getNode().getId();
        String parentPath = this.parentPath(oldPath);
        String newPath = this.createNewPath(parentPath, param.getName());
        Metadata metadata = this.client.files().moveV2(oldPath, newPath).getMetadata();
        return this.toNode(metadata);
    }

    @Override
    public void delete(DeleteParam param) throws Exception {
        String id = param.getNode().getId();
        this.client.files().deleteV2(id);
    }

    private Node uploadSmallFile(String path, DownloadResult downloadResult) throws Exception {
        ProgInputStream stream = new ProgInputStream(downloadResult.getIn(), downloadResult.getNode(), this);
        FileMetadata metadata = (FileMetadata)this.client.files().uploadBuilder(path).uploadAndFinish((InputStream)stream);
        return this.toNode((Metadata)metadata);
    }

    private Node uploadLargeFile(String path, DownloadResult downloadResult) throws Exception {
        InputStream stream = downloadResult.getIn();
        Node fromNode = downloadResult.getNode();
        Long size = fromNode.getSize();
        long uploaded = 0L;
        try (UploadSessionStartUploader uploader = this.client.files().uploadSessionStart();){
            Node node;
            block20: {
                long firstChunk = Math.min(0x400000L, size);
                UploadSessionStartResult uploadSessionStartResult = (UploadSessionStartResult)uploader.uploadAndFinish(stream, firstChunk);
                this.setUploadMsg(fromNode, uploaded += firstChunk);
                UploadSessionCursor cursor = new UploadSessionCursor(uploadSessionStartResult.getSessionId(), uploaded);
                while (size - uploaded > 0x400000L) {
                    try (UploadSessionAppendV2Uploader appendUploader = this.client.files().uploadSessionAppendV2(cursor);){
                        appendUploader.uploadAndFinish(stream, 0x400000L);
                    }
                    this.setUploadMsg(fromNode, uploaded += 0x400000L);
                    cursor = new UploadSessionCursor(cursor.getSessionId(), uploaded);
                }
                long remaining = size - uploaded;
                UploadSessionFinishUploader finishUploader = this.client.files().uploadSessionFinish(cursor, CommitInfo.newBuilder((String)path).withMode(WriteMode.OVERWRITE).build());
                try {
                    FileMetadata metadata = (FileMetadata)finishUploader.uploadAndFinish(stream, remaining);
                    node = this.toNode((Metadata)metadata);
                    if (finishUploader == null) break block20;
                }
                catch (Throwable throwable) {
                    if (finishUploader != null) {
                        try {
                            finishUploader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                finishUploader.close();
            }
            return node;
        }
    }

    @Override
    public boolean expire(Exception e) {
        return e instanceof InvalidAccessTokenException;
    }

    @Override
    public DriveAuth refresh() throws Exception {
        Form form = Form.form().add("grant_type", "refresh_token").add("refresh_token", this.auth.getRefresh()).add("client_id", this.app.getKey()).add("client_secret", this.app.getSecret());
        JSONObject json = this.postAuth(form);
        String access = json.getString("access_token");
        this.auth.setAccess(access);
        this.client = this.createClient(access);
        return this.auth;
    }

    @Override
    public void newAuth(DriveAuth auth) throws Exception {
        this.auth = auth;
        this.client = this.createClient(auth.getAccess());
    }

    @Override
    public void finish() throws Exception {
        super.finish();
        if (this.download != null) {
            this.download.close();
        }
    }

    @Override
    public void close() {
        this.auth = null;
        this.client = null;
    }

    @Override
    public boolean isWarning(Exception e) {
        String msg = StringUtil.getMsg(e);
        if (msg.contains("not_found")) {
            return true;
        }
        if (msg.contains("unsupported_file")) {
            return true;
        }
        if (msg.contains("insufficient_space")) {
            return true;
        }
        return msg.contains("Insufficient drive space");
    }

    @Override
    public boolean isLimited(Exception e) {
        if (e instanceof ServerException) {
            return true;
        }
        if (e instanceof RateLimitException) {
            return true;
        }
        if (e instanceof RetryException) {
            return true;
        }
        if (e instanceof NetworkIOException) {
            return true;
        }
        if (e instanceof BadResponseCodeException) {
            BadResponseCodeException bad = (BadResponseCodeException)e;
            return bad.getStatusCode() == 504;
        }
        return false;
    }
}

