/*
 * Decompiled with CFR 0.152.
 */
package tools.mv.backend.drive;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketTimeoutException;
import javax.net.ssl.SSLHandshakeException;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tools.mv.backend.drive.Dropbox;
import tools.mv.backend.exception.DriveLimitException;
import tools.mv.backend.model.AppDrive;
import tools.mv.backend.model.AuthParam;
import tools.mv.backend.model.DriveAuth;
import tools.mv.backend.model.Node;
import tools.mv.backend.task.TaskProgress;
import tools.mv.backend.util.StringUtil;

public abstract class DriveParent {
    public static final Logger logger = LoggerFactory.getLogger(Dropbox.class);
    public static final int CONNECT_TIMEOUT = 6000;
    public static final int SOCKET_TIMEOUT = 60000;
    public InputStream in;
    public OutputStream out;
    public TaskProgress progress;
    public RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(60000).setConnectTimeout(6000).setConnectionRequestTimeout(6000).build();
    private CloseableHttpClient downloadClient;
    private CloseableHttpResponse downloadResponse;

    public DriveParent(AppDrive appDrive) {
        this.progress = appDrive.getProgress();
    }

    private void closeURLDownload() {
        if (this.downloadResponse != null) {
            try {
                this.downloadResponse.close();
            }
            catch (Exception e) {
                System.err.println("Error closing download response: " + e.getMessage());
            }
            finally {
                this.downloadResponse = null;
            }
        }
        if (this.downloadClient != null) {
            try {
                this.downloadClient.close();
            }
            catch (Exception e) {
                System.err.println("Error closing download client: " + e.getMessage());
            }
            finally {
                this.downloadClient = null;
            }
        }
    }

    public void closeInOut() {
        if (this.in != null) {
            try {
                this.in.close();
            }
            catch (Exception e) {
                System.err.println("Error closing download stream: " + e.getMessage());
            }
            finally {
                this.in = null;
            }
        }
        if (this.out != null) {
            try {
                this.out.close();
            }
            catch (Exception e) {
                System.err.println("Error closing upload stream: " + e.getMessage());
            }
            finally {
                this.out = null;
            }
        }
    }

    public String parentPath(String path) {
        int idx = path.lastIndexOf(47);
        return idx > 0 ? path.substring(0, idx) : "";
    }

    public String createNewPath(String path, String name) {
        return path + "/" + name;
    }

    public String folderId(String path, Node node) {
        return node == null ? path : node.getId();
    }

    public String fullPath(String path, Node node, String name) {
        String id = this.folderId(path, node);
        return this.prefix(id) + "/" + name;
    }

    public String prefix(String id) {
        if (id.endsWith("/")) {
            id = id.substring(0, id.length() - 1);
        }
        return id;
    }

    public Node createMkdirNode(String path, String name) {
        return this.createMkdirNode(path, name, System.currentTimeMillis());
    }

    public Node createMkdirNode(String path, String name, long time) {
        Node temp = new Node();
        temp.setId(path);
        temp.setType("folder");
        temp.setName(name);
        temp.setDir(true);
        temp.setTime(time);
        return temp;
    }

    public Node createUploadNode(String path, String name, long size) {
        Node temp = new Node();
        temp.setId(path);
        temp.setType("file");
        temp.setName(name);
        temp.setDir(false);
        temp.setSize(size);
        temp.setTime(System.currentTimeMillis());
        return temp;
    }

    public long readAndWrite(InputStream in, OutputStream out, Node node) throws Exception {
        int len;
        long cur = 0L;
        byte[] buf = new byte[1024];
        while ((len = in.read(buf)) != -1) {
            out.write(buf, 0, len);
            this.setUploadMsg(node, cur += (long)len);
        }
        out.flush();
        return cur;
    }

    public void setUploadMsg(Node node, long cur) {
        this.setCustomMsg(node, cur, "Upload");
    }

    public void setCustomMsg(Node node, long cur, String type) {
        Long size = node.getSize();
        if (size == null) {
            node.setMsg(type + " " + StringUtil.formatBytes(cur));
        } else {
            node.setMsg(type + " " + StringUtil.formatBytes(cur) + " / " + StringUtil.formatBytes(size));
        }
        this.refreshProgress();
    }

    public void refreshProgress() {
        if (this.progress != null) {
            this.progress.callback();
        }
    }

    public String auth(AuthParam param) throws Exception {
        return null;
    }

    public boolean needSize() {
        return false;
    }

    public void finish() throws Exception {
        this.closeInOut();
        this.closeURLDownload();
    }

    public boolean refreshed() {
        return false;
    }

    public DriveAuth loadAuth() {
        return null;
    }

    public boolean isLimited(Exception e) {
        return false;
    }

    public boolean isWarning(Exception e) {
        return false;
    }

    public String supportName(String name) {
        if (name == null) {
            throw new RuntimeException("Name does not exist");
        }
        if ((name = name.trim().replaceAll("\\r\\n|\\r|\\n", " ").replaceAll("[\\\\/:*?\"<>|]", "_")).isEmpty()) {
            throw new RuntimeException("Name cannot be blank");
        }
        return name;
    }

    public InputStream getInputStreamFromUrl(String url, String token) throws Exception {
        this.downloadClient = HttpClients.createDefault();
        try {
            HttpGet httpGet = new HttpGet(url);
            httpGet.setConfig(this.requestConfig);
            if (token != null) {
                httpGet.setHeader("Authorization", "Bearer " + token);
            }
            this.downloadResponse = this.downloadClient.execute((HttpUriRequest)httpGet);
            try {
                StatusLine statusLine = this.downloadResponse.getStatusLine();
                HttpEntity entity = this.downloadResponse.getEntity();
                if (statusLine.getStatusCode() == 200) {
                    return entity.getContent();
                }
                String result = EntityUtils.toString((HttpEntity)entity);
                if (result == null || result.isEmpty()) {
                    throw new Exception("Failed to download file: " + String.valueOf(statusLine));
                }
                throw new Exception(result);
            }
            catch (SocketTimeoutException | SSLHandshakeException e) {
                throw new DriveLimitException(e.toString());
            }
        }
        catch (Exception e) {
            this.closeURLDownload();
            throw e;
        }
    }
}

