/*
 * Decompiled with CFR 0.152.
 */
package tools.mv.backend.drive;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxAPIResponseException;
import com.box.sdk.BoxFile;
import com.box.sdk.BoxFolder;
import com.box.sdk.BoxItem;
import com.box.sdk.BoxUser;
import java.io.InputStream;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import tools.mv.backend.drive.BaseDrive;
import tools.mv.backend.drive.DriveParent;
import tools.mv.backend.model.AppDrive;
import tools.mv.backend.model.AppInfo;
import tools.mv.backend.model.AuthParam;
import tools.mv.backend.model.DeleteParam;
import tools.mv.backend.model.DownloadParam;
import tools.mv.backend.model.DownloadResult;
import tools.mv.backend.model.DriveAuth;
import tools.mv.backend.model.DriveInfo;
import tools.mv.backend.model.ListParam;
import tools.mv.backend.model.ListResult;
import tools.mv.backend.model.MkdirParam;
import tools.mv.backend.model.Node;
import tools.mv.backend.model.RenameParam;
import tools.mv.backend.model.UploadParam;
import tools.mv.backend.util.ProgInputStream;
import tools.mv.backend.util.StringUtil;

public class Box
extends DriveParent
implements BaseDrive {
    private static final String ROOT_ID = "0";
    private final AppInfo app;
    private DriveAuth auth;
    private BoxAPIConnection client;

    public Box(AppDrive appDrive) {
        super(appDrive);
        this.app = appDrive.getInfo();
        this.auth = appDrive.getAuth();
        if (this.auth != null) {
            this.client = this.createClient(this.auth.getAccess());
        }
    }

    private BoxAPIConnection createClient(String access) {
        BoxAPIConnection conn = new BoxAPIConnection(access);
        conn.setConnectTimeout(6000);
        conn.setReadTimeout(60000);
        return conn;
    }

    @Override
    public String auth(AuthParam param) {
        return "https://account.box.com/api/oauth2/authorize?response_type=code&prompt=consent&state=" + param.getState() + "&client_id=" + this.app.getKey() + "&redirect_uri=" + this.app.getCallback();
    }

    @Override
    public DriveAuth callback(AuthParam param) throws Exception {
        BoxAPIConnection api = new BoxAPIConnection(this.app.getKey(), this.app.getSecret(), param.getCode());
        String access = api.getAccessToken();
        String refresh = api.getRefreshToken();
        BoxUser user = BoxUser.getCurrentUser((BoxAPIConnection)api);
        String userId = user.getID();
        this.auth = DriveAuth.builder().uuid(userId).access(access).refresh(refresh).build();
        this.client = this.createClient(access);
        return this.auth;
    }

    @Override
    public DriveInfo info() throws Exception {
        BoxUser user = BoxUser.getCurrentUser((BoxAPIConnection)this.client);
        BoxUser.Info info = user.getInfo(new String[]{"login", "name", "space_amount", "space_used"});
        return DriveInfo.builder().email(info.getLogin()).name(info.getName()).used(info.getSpaceUsed()).total(info.getSpaceAmount()).build();
    }

    @Override
    public ListResult list(ListParam param) throws Exception {
        String id = this.folderId(ROOT_ID, param.getNode());
        BoxFolder folder = new BoxFolder(this.client, id);
        ArrayList<Node> nodes = new ArrayList<Node>();
        folder.getChildren(new String[]{"id", "type", "name", "size", "modified_at"}).forEach(item -> nodes.add(this.toNode((BoxItem.Info)item)));
        return ListResult.builder().nodes(nodes).build();
    }

    private Node toNode(BoxItem.Info info) {
        boolean isDir = info.getType().equals("folder");
        Node node = new Node();
        node.setId(info.getID());
        node.setType(isDir ? "folder" : "file");
        node.setName(info.getName());
        node.setDir(isDir);
        if (!isDir) {
            node.setSize(info.getSize());
        }
        node.setTime(info.getModifiedAt().getTime());
        return node;
    }

    @Override
    public Node mkdir(MkdirParam param) throws Exception {
        String id = this.folderId(ROOT_ID, param.getNode());
        String name = param.getName();
        BoxFolder.Info info = new BoxFolder(this.client, id).createFolder(name);
        return this.toNode((BoxItem.Info)info);
    }

    @Override
    public DownloadResult download(DownloadParam param) throws Exception {
        Node node = param.getNode();
        String url = "https://api.box.com/2.0/files/" + node.getId() + "/content";
        this.in = this.getInputStreamFromUrl(url, this.auth.getAccess());
        return DownloadResult.builder().node(node).in(this.in).build();
    }

    @Override
    public Node upload(UploadParam param) throws Exception {
        String id = this.folderId(ROOT_ID, param.getNode());
        String name = param.getName();
        BoxFolder folder = new BoxFolder(this.client, id);
        DownloadResult result = param.getResult();
        InputStream in = result.getIn();
        Node fromNode = result.getNode();
        ProgInputStream stream = new ProgInputStream(in, fromNode, this);
        BoxFile.Info info = folder.uploadFile((InputStream)stream, name);
        return this.toNode((BoxItem.Info)info);
    }

    @Override
    public Node rename(RenameParam param) throws Exception {
        Node node = param.getNode();
        String id = node.getId();
        String name = param.getName();
        if (node.isDir()) {
            new BoxFolder(this.client, id).rename(name);
        } else {
            new BoxFile(this.client, id).rename(name);
        }
        node.setName(name);
        return node;
    }

    @Override
    public void delete(DeleteParam param) throws Exception {
        Node node = param.getNode();
        String id = node.getId();
        if (node.isDir()) {
            new BoxFolder(this.client, id).delete(true);
        } else {
            new BoxFile(this.client, id).delete();
        }
    }

    @Override
    public boolean expire(Exception e) {
        if (e instanceof BoxAPIResponseException) {
            String msg = e.getMessage();
            return msg != null && msg.contains("The API returned an error code [401");
        }
        String msg = e.getMessage();
        return msg != null && msg.contains("401 Unauthorized");
    }

    @Override
    public DriveAuth refresh() throws Exception {
        BoxAPIConnection api = new BoxAPIConnection(this.app.getKey(), this.app.getSecret(), this.auth.getAccess(), this.auth.getRefresh());
        api.refresh();
        this.auth.setAccess(api.getAccessToken());
        this.auth.setRefresh(api.getRefreshToken());
        this.client = this.createClient(this.auth.getAccess());
        return this.auth;
    }

    @Override
    public void newAuth(DriveAuth auth) throws Exception {
        this.auth = auth;
        this.client = this.createClient(auth.getAccess());
    }

    @Override
    public void close() {
        this.auth = null;
        this.client = null;
    }

    @Override
    public boolean isLimited(Exception e) {
        String msg = StringUtil.getMsg(e);
        if (e instanceof BoxAPIResponseException) {
            if (msg.contains("The API returned an error code [429")) {
                return true;
            }
            if (msg.contains("The API returned an error code [500")) {
                return true;
            }
            return msg.contains("connect to the Box API due to a network error");
        }
        if (e instanceof RuntimeException) {
            return msg.contains("java.io.IOException");
        }
        if (e instanceof SocketTimeoutException) {
            return msg.contains("Read timed out");
        }
        return msg.contains("rate_limit_exceeded");
    }

    @Override
    public boolean isWarning(Exception e) {
        if (e instanceof BoxAPIResponseException) {
            String msg = e.getMessage();
            return msg != null && msg.contains("file_size_limit_exceeded");
        }
        return false;
    }
}

