/*
 * Decompiled with CFR 0.152.
 */
package tools.mv.backend.controller;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import tools.mv.backend.controller.BaseController;
import tools.mv.backend.entity.Drive;
import tools.mv.backend.entity.Task;
import tools.mv.backend.exception.BusinessException;
import tools.mv.backend.model.CreateTaskParam;
import tools.mv.backend.model.EntityParam;
import tools.mv.backend.model.Node;
import tools.mv.backend.model.ResData;
import tools.mv.backend.model.TaskParam;
import tools.mv.backend.model.TaskRes;
import tools.mv.backend.model.TaskResLess;
import tools.mv.backend.model.UpdateTaskOptionsParam;
import tools.mv.backend.util.StringUtil;

@RestController
@RequestMapping(value={"/api/task"})
public class TaskController
extends BaseController {
    private Task getTaskNotNull(String id) {
        if (id == null || id.isEmpty()) {
            throw new BusinessException("Task does not exist", new Object[0]);
        }
        Task task = this.taskService.get(id);
        if (task == null) {
            throw new BusinessException("Task does not exist", new Object[0]);
        }
        return task;
    }

    @PostMapping(value={"/errors"})
    public ResData errors(@RequestBody EntityParam param) {
        Task task = this.getTaskNotNull(param.getId());
        List<Node> errorFiles = task.getTaskResult().getErrorFiles();
        return ResData.success(errorFiles);
    }

    @PostMapping(value={"/cancel"})
    public ResData cancel(@RequestBody EntityParam param) {
        Task task = this.getTaskNotNull(param.getId());
        task = this.manageTask.cancel(task);
        return ResData.success(task.toTaskRes());
    }

    @GetMapping(value={"/progress"})
    public ResData progress() {
        List<Task> tasks = this.taskService.listAll();
        List<TaskRes> list = tasks.stream().map(Task::toTaskRes).toList();
        List listLess = list.stream().map(TaskRes::toTaskResLess).collect(Collectors.toList());
        for (TaskResLess taskResLess : listLess) {
            if (!StringUtil.taskIsRunning(taskResLess.getStatus())) continue;
            taskResLess.setResult(this.manageTask.progress(taskResLess.getId()));
        }
        return ResData.success(listLess);
    }

    @PostMapping(value={"/start"})
    public ResData start(@RequestBody EntityParam param) {
        Task task = this.getTaskNotNull(param.getId());
        if (!"copy".equals(task.getType()) && !StringUtil.isVip()) {
            throw new BusinessException("The free version can only execute Copy type tasks. Please upgrade and try again.", new Object[0]);
        }
        task = this.manageTask.start(task);
        return ResData.success(task.toTaskRes());
    }

    @GetMapping(value={"/list"})
    public ResData listTask() {
        List<Task> tasks = this.taskService.listAll();
        ArrayList<TaskRes> list = new ArrayList<TaskRes>();
        for (Task task : tasks) {
            list.add(task.toTaskRes());
        }
        for (TaskRes taskRes : list) {
            if (!StringUtil.taskIsRunning(taskRes.getStatus())) continue;
            taskRes.setResult(this.manageTask.progress(taskRes.getId()));
        }
        Collections.sort(list);
        return ResData.success(list);
    }

    @PostMapping(value={"/options"})
    public ResData options(@RequestBody UpdateTaskOptionsParam param) {
        if (!StringUtil.isVip()) {
            throw new BusinessException("The free version does not allow configuring schedules or filters. Please upgrade and try again.", new Object[0]);
        }
        Task task = this.taskService.options(param.getId(), param.getOptions());
        return ResData.success(task.toTaskRes());
    }

    @PostMapping(value={"/delete"})
    public ResData deleteTask(@RequestBody EntityParam param) {
        Task task = this.getTaskNotNull(param.getId());
        this.taskService.delete(task.getId());
        return ResData.success(null);
    }

    @PostMapping(value={"/create"})
    public ResData create(@RequestBody CreateTaskParam param) throws Exception {
        String type = StringUtil.checkTaskType(param.getType());
        if (!"copy".equals(type) && !StringUtil.isVip()) {
            throw new BusinessException("The free version can only create Copy type tasks. Please upgrade and try again.", new Object[0]);
        }
        TaskParam taskParam = param.getParam();
        Drive driveFrom = this.getDriveNotNull(param.getFdid());
        Drive driveTo = this.getDriveNotNull(param.getTdid());
        Task task = this.taskService.create(type, taskParam, driveFrom, driveTo);
        return ResData.success(task.toTaskRes());
    }
}

