/*
 * Decompiled with CFR 0.152.
 */
package tools.mv.backend.controller;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import tools.mv.backend.controller.BaseController;
import tools.mv.backend.entity.Drive;
import tools.mv.backend.exception.BusinessException;
import tools.mv.backend.model.DriveDeleteParam;
import tools.mv.backend.model.DriveListParam;
import tools.mv.backend.model.DriveMkdirParam;
import tools.mv.backend.model.DriveRenameParam;
import tools.mv.backend.model.ListParam;
import tools.mv.backend.model.ListResult;
import tools.mv.backend.model.Node;
import tools.mv.backend.model.ResData;
import tools.mv.backend.util.DriveUtil;

@RestController
@RequestMapping(value={"/api/file"})
public class FileController
extends BaseController {
    private ListResult less(ListParam param, Drive drive, ListResult result) {
        String start = param.getStart();
        String type = drive.getType();
        List<Node> nodes = result.getNodes();
        String next = result.getNext();
        int limit = 1000;
        if (next == null && nodes.size() > limit && type.matches("(LocalDrive|FTP|SFTP|WebDAV|PCloud)")) {
            String nextNew = null;
            ArrayList<Node> nodesNew = new ArrayList<Node>();
            int startIndex = start == null || start.isEmpty() ? 0 : Integer.parseInt(start);
            int endIndex = startIndex + limit;
            int sum = nodes.size();
            nextNew = endIndex >= sum ? null : String.valueOf(endIndex);
            int finalEndIndex = Math.min(endIndex, sum);
            for (int i = startIndex; i < finalEndIndex; ++i) {
                nodesNew.add(nodes.get(i));
            }
            return ListResult.builder().nodes(nodesNew).next(nextNew).build();
        }
        return result;
    }

    @PostMapping(value={"/open"})
    public ResData open(@RequestBody DriveListParam param) throws Exception {
        Drive drive = this.getDriveNotNull(param.getId());
        try (DriveUtil driveUtil = new DriveUtil(this.appService, this.driveService, drive);){
            ListParam listParam = param.getParam();
            ListResult result = driveUtil.list(listParam);
            result = this.less(listParam, drive, result);
            Collections.sort(result.getNodes());
            ResData resData = ResData.success(result);
            return resData;
        }
    }

    @PostMapping(value={"/mkdir"})
    public ResData mkdir(@RequestBody DriveMkdirParam param) throws Exception {
        Drive drive = this.getDriveNotNull(param.getId());
        try (DriveUtil driveUtil = new DriveUtil(this.appService, this.driveService, drive);){
            Node node = driveUtil.mkdir(param.getParam());
            if (node == null) {
                throw new BusinessException("The result of creating the folder is empty.", new Object[0]);
            }
            ResData resData = ResData.success(node);
            return resData;
        }
    }

    @PostMapping(value={"/rename"})
    public ResData rename(@RequestBody DriveRenameParam param) throws Exception {
        Drive drive = this.getDriveNotNull(param.getId());
        try (DriveUtil driveUtil = new DriveUtil(this.appService, this.driveService, drive);){
            Node node = driveUtil.rename(param.getParam());
            if (node == null) {
                throw new BusinessException("The result of renaming the file is empty.", new Object[0]);
            }
            ResData resData = ResData.success(node);
            return resData;
        }
    }

    @PostMapping(value={"/delete"})
    public ResData delete(@RequestBody DriveDeleteParam param) throws Exception {
        Drive drive = this.getDriveNotNull(param.getId());
        try (DriveUtil driveUtil = new DriveUtil(this.appService, this.driveService, drive);){
            driveUtil.delete(param.getParam());
            ResData resData = ResData.success(param.getParam().getNode());
            return resData;
        }
    }
}

