/*
 * Decompiled with CFR 0.152.
 */
package tools.mv.backend.controller;

import com.google.gson.Gson;
import java.io.File;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import tools.mv.backend.controller.BaseController;
import tools.mv.backend.entity.App;
import tools.mv.backend.entity.Drive;
import tools.mv.backend.exception.BusinessException;
import tools.mv.backend.model.AppDrive;
import tools.mv.backend.model.AuthJumpResult;
import tools.mv.backend.model.AuthParam;
import tools.mv.backend.model.AuthResult;
import tools.mv.backend.model.DriveAuth;
import tools.mv.backend.model.DriveInfo;
import tools.mv.backend.model.EntityParam;
import tools.mv.backend.model.EntityRenameParam;
import tools.mv.backend.model.FTPParam;
import tools.mv.backend.model.LocalParam;
import tools.mv.backend.model.MediaFireParam;
import tools.mv.backend.model.ResData;
import tools.mv.backend.model.SFTPParam;
import tools.mv.backend.model.WebDAVParam;
import tools.mv.backend.util.DriveUtil;
import tools.mv.backend.util.StringUtil;

@RestController
@RequestMapping(value={"/api/drive"})
public class DriveController
extends BaseController {
    @PostMapping(value={"/space"})
    public ResData space(@RequestBody EntityParam param) throws Exception {
        Drive drive = this.getDriveNotNull(param.getId());
        Boolean base = param.getBase();
        if (base != null && base.booleanValue()) {
            return ResData.success(drive.getDriveAuth().toDriveInfo());
        }
        try (DriveUtil driveUtil = new DriveUtil(this.appService, this.driveService, drive);){
            DriveInfo info = driveUtil.info();
            ResData resData = ResData.success(info);
            return resData;
        }
    }

    @GetMapping(value={"/list"})
    public ResData list() {
        List<Drive> drives = this.driveService.listAll();
        List result = drives.stream().map(Drive::toDriveRes).sorted().collect(Collectors.toList());
        return ResData.success(result);
    }

    @PostMapping(value={"/rename"})
    public ResData rename(@RequestBody EntityRenameParam param) {
        String did = param.getId();
        String name = param.getName();
        Drive drive = this.driveService.rename(did, name);
        return ResData.success(drive.toDriveRes());
    }

    @PostMapping(value={"/delete"})
    public ResData delete(@RequestBody EntityParam param) {
        this.driveService.delete(param.getId());
        return ResData.success(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GetMapping(value={"/callback"})
    public void callback(@RequestParam(value="state", required=false) String state, @RequestParam(value="code", required=false) String code, @RequestParam(value="error", required=false) String error, @RequestParam(value="error_description", required=false) String errorDescription) throws Exception {
        boolean isDev = StringUtil.isDev(this.profile);
        String jumpUrl = isDev ? "http://localhost:5173/callback" : "http://localhost:8080";
        try (DriveUtil driveUtil = null;){
            if (errorDescription != null) {
                throw new Exception(errorDescription);
            }
            if (error != null) {
                throw new Exception(error);
            }
            if (state == null) {
                throw new BusinessException("State does not exist", new Object[0]);
            }
            AuthParam param = (AuthParam)this.session.getAttribute(state);
            if (param == null) {
                throw new BusinessException("State expired", new Object[0]);
            }
            this.session.removeAttribute(state);
            param.setCode(code);
            param.setMap(this.request.getParameterMap());
            App app = this.getAppByType(param.getType(), param.getWay());
            driveUtil = new DriveUtil(this.appService, this.driveService, param.getType(), AppDrive.builder().info(app == null ? null : app.getAppInfo()).build());
            DriveAuth auth = driveUtil.callback(param);
            DriveInfo info = driveUtil.info();
            Drive saved = this.saveDrive(param, this.createDriveName(info), auth);
            if (isDev) {
                AuthJumpResult result = AuthJumpResult.builder().status("success").data(saved.getId()).build();
                this.response.sendRedirect(jumpUrl + "?json=" + StringUtil.base64(new Gson().toJson((Object)result)));
            } else {
                StringUtil.addCookie(this.response, "drive_add", saved.getId(), 86400);
                this.response.sendRedirect(jumpUrl);
            }
        }
    }

    @PostMapping(value={"/auth"})
    public ResData auth(@RequestBody AuthParam param) throws Exception {
        String type = StringUtil.checkDriveType(param.getType());
        if (!StringUtil.isVip() && this.driveService.hasTypeDrive(type)) {
            throw new BusinessException("The free version allows only one drive of the same type to be added. Please upgrade and try again.", new Object[0]);
        }
        App app = this.getAppByType(param.getType(), param.getWay());
        if (!StringUtil.needApp(type)) {
            if (app != null) {
                throw new BusinessException("No app required", new Object[0]);
            }
        } else if (app == null) {
            throw new BusinessException("No default app exists in the system", new Object[0]);
        }
        param.setState(StringUtil.uuid());
        try (DriveUtil driveUtil = new DriveUtil(this.appService, this.driveService, type, AppDrive.builder().info(app == null ? null : app.getAppInfo()).build());){
            String url = driveUtil.auth(param);
            if (url == null) {
                DriveAuth auth = driveUtil.callback(param);
                DriveInfo info = driveUtil.info();
                Drive saved = this.saveDrive(param, this.createDriveName(info), auth);
                ResData resData = ResData.success(AuthResult.builder().type("drive").data(saved.toDriveRes()).build());
                return resData;
            }
            this.session.setAttribute(param.getState(), (Object)param);
            ResData resData = ResData.success(AuthResult.builder().type("url").data(url).build());
            return resData;
        }
    }

    private String createDriveName(DriveInfo info) {
        Object name = info.getEmail();
        if (name == null) {
            name = info.getName();
        }
        if (name == null) {
            LocalParam localParam = info.getLocal();
            if (localParam != null) {
                name = new File(localParam.getPath()).getAbsolutePath();
            }
            FTPParam ftpParam = info.getFtp();
            if (name == null && ftpParam != null) {
                name = ftpParam.getUsername() + "@" + ftpParam.getHost() + ":" + ftpParam.getPort();
            }
            SFTPParam sftpParam = info.getSftp();
            if (name == null && sftpParam != null) {
                name = sftpParam.getUsername() + "@" + sftpParam.getHost() + ":" + sftpParam.getPort();
            }
            WebDAVParam webDavParam = info.getWebdav();
            if (name == null && webDavParam != null) {
                name = webDavParam.getUsername();
            }
            MediaFireParam mediaFireParam = info.getMediafire();
            if (name == null && mediaFireParam != null) {
                name = mediaFireParam.getEmail();
            }
        }
        if (name == null) {
            name = "Drive" + new Random().nextInt(1000);
        }
        return name;
    }

    private Drive saveDrive(AuthParam param, String name, DriveAuth auth) {
        App app = this.getAppByType(param.getType(), param.getWay());
        String did = StringUtil.createDriveId(param.getType(), auth);
        String authStr = new Gson().toJson((Object)auth);
        Drive checkDrive = this.driveService.get(did);
        if (checkDrive != null) {
            return this.editDrive(checkDrive, name, authStr);
        }
        return this.driveService.add(did, param.getType(), name, authStr, app == null ? "{}" : app.getInfo());
    }

    private Drive editDrive(Drive drive, String name, String authStr) {
        drive.setName(name);
        drive.setAuth(authStr);
        this.driveService.update(drive);
        return drive;
    }
}

