/*
 * Decompiled with CFR 0.152.
 */
package tools.mv.backend.controller;

import jakarta.annotation.Resource;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestController;
import tools.mv.backend.entity.App;
import tools.mv.backend.entity.Drive;
import tools.mv.backend.exception.BusinessException;
import tools.mv.backend.model.ResData;
import tools.mv.backend.service.AppService;
import tools.mv.backend.service.DriveService;
import tools.mv.backend.service.TaskService;
import tools.mv.backend.task.ManageTask;
import tools.mv.backend.util.StringUtil;

@RestController
public class BaseController {
    @Resource
    public AppService appService;
    @Resource
    public DriveService driveService;
    @Resource
    public TaskService taskService;
    @Resource
    public ManageTask manageTask;
    @Resource
    public HttpServletRequest request;
    @Resource
    public HttpServletResponse response;
    @Resource
    public HttpSession session;
    @Value(value="${spring.profiles.active}")
    public String profile;
    public static final Logger logger = LoggerFactory.getLogger(BaseController.class);

    @ExceptionHandler(value={Exception.class})
    public ResData handleException(Exception e) {
        String msg = StringUtil.getMsg(e);
        if (e instanceof BusinessException) {
            logger.warn("Global Warning: " + msg + ((BusinessException)e).getDetail());
            return ResData.warn(msg);
        }
        logger.error("Global Error: " + msg, (Throwable)e);
        return ResData.error(msg);
    }

    public App getAppByType(String type, String way) {
        if ("custom".equals(way)) {
            return this.appService.getByType(type);
        }
        if ("system".equals(way)) {
            return this.appService.getSystemByType(type);
        }
        return null;
    }

    public Drive getDrive(String id) {
        if (id != null && !id.isEmpty()) {
            Drive drive = this.driveService.get(id);
            if (drive == null) {
                throw new BusinessException("Drive does not exist", new Object[0]);
            }
            return drive;
        }
        return null;
    }

    public Drive getDriveNotNull(String id) {
        Drive drive = this.getDrive(id);
        if (drive == null) {
            throw new BusinessException("Drive does not exist", new Object[0]);
        }
        return drive;
    }
}

