/*
 * Decompiled with CFR 0.152.
 */
package tools.mv.backend.controller;

import com.google.gson.Gson;
import org.apache.http.client.fluent.Request;
import org.apache.http.entity.ContentType;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import tools.mv.backend.config.InitRunner;
import tools.mv.backend.controller.BaseController;
import tools.mv.backend.entity.App;
import tools.mv.backend.model.FeedbackParam;
import tools.mv.backend.model.ResData;
import tools.mv.backend.model.SaveApp;
import tools.mv.backend.util.StringUtil;

@RestController
@RequestMapping(value={"/api/app"})
public class AppController
extends BaseController {
    @PostMapping(value={"/feedback"})
    public ResData feedback(@RequestBody FeedbackParam param) {
        String origin = StringUtil.getOrigin(this.profile);
        String json = new Gson().toJson((Object)param);
        try {
            Request.Post((String)(origin + "/api/feedback/add")).socketTimeout(10000).connectTimeout(10000).bodyString(json, ContentType.APPLICATION_JSON).execute().returnContent().asString();
            return ResData.success(null);
        }
        catch (Exception e) {
            return ResData.error(e.getMessage());
        }
    }

    @GetMapping(value={"/auth"})
    public ResData auth() {
        return ResData.success(InitRunner.userInfo);
    }

    @GetMapping(value={"/upgrade"})
    public ResData upgrade() {
        String origin = StringUtil.getOrigin(this.profile);
        return ResData.success(origin + "/pricing.html?code=" + StringUtil.encryptCode());
    }

    @GetMapping(value={"/refresh"})
    public ResData refresh() {
        InitRunner.refreshUserInfo(this.profile);
        return this.auth();
    }

    @GetMapping(value={"/load"})
    public ResData load(@RequestParam String type) {
        return ResData.success(this.appService.getByType(type).toSaveApp());
    }

    @PostMapping(value={"/save"})
    public ResData save(@RequestBody SaveApp param) {
        App app = this.appService.getByType(param.getType());
        app.setInfo(param.getInfo().toAppInfo().toJson());
        return ResData.success(this.appService.save(app));
    }
}

