/*
 * Decompiled with CFR 0.152.
 */
package tools.mv.backend.config;

import com.google.gson.Gson;
import jakarta.annotation.Resource;
import org.apache.http.client.fluent.Request;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.stereotype.Component;
import tools.mv.backend.entity.App;
import tools.mv.backend.model.AppInfo;
import tools.mv.backend.model.UserInfo;
import tools.mv.backend.service.AppService;
import tools.mv.backend.util.MacUtil;
import tools.mv.backend.util.StringUtil;

@Component
public class InitRunner
implements ApplicationRunner {
    @Resource
    private AppService appService;
    @Value(value="${spring.profiles.active}")
    private String profile;
    public static UserInfo userInfo = new UserInfo();

    public void run(ApplicationArguments args) {
        this.initApps();
        InitRunner.refreshUserInfo(this.profile);
        this.openBrowser();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refreshUserInfo(String profile) {
        boolean isUpdate = false;
        try {
            int timeout = 10000;
            String origin = StringUtil.getOrigin(profile);
            String jsonStr = Request.Get((String)(origin + "/api/user/now")).socketTimeout(timeout).connectTimeout(timeout).execute().returnContent().asString();
            long time = new JSONObject(jsonStr).getLong("data");
            long abs = Math.abs(System.currentTimeMillis() - time);
            if (abs < 180000L) {
                long vtime;
                jsonStr = Request.Get((String)(origin + "/api/user/load?code=" + StringUtil.encryptCode())).socketTimeout(timeout).connectTimeout(timeout).execute().returnContent().asString();
                jsonStr = StringUtil.decrypt(new JSONObject(jsonStr).getString("data"));
                JSONObject json = new JSONObject(jsonStr);
                if (StringUtil.md5(MacUtil.getMac()).equals(json.getString("id")) && (vtime = json.getLong("vtime")) > System.currentTimeMillis()) {
                    userInfo.setExpire(vtime);
                    userInfo.setVip(true);
                    isUpdate = true;
                }
            }
        }
        catch (Exception e) {
            if (StringUtil.isDev(profile)) {
                e.printStackTrace();
            }
        }
        finally {
            if (!isUpdate) {
                userInfo.setExpire(0L);
                userInfo.setVip(false);
            }
        }
    }

    private void openBrowser() {
        block3: {
            if (!StringUtil.isDev(this.profile)) {
                try {
                    new ProcessBuilder("cmd", "/c", "start", "http://localhost:8080").start();
                }
                catch (Exception e) {
                    if (!StringUtil.isDev(this.profile)) break block3;
                    e.printStackTrace();
                }
            }
        }
    }

    private void initApps() {
        AppInfo info = new AppInfo("", "", "http://localhost:8080/api/drive/callback");
        if (this.appService.getByType("GoogleDrive") == null) {
            this.initApp("GoogleDrive", info);
        }
        if (this.appService.getByType("OneDrive") == null) {
            this.initApp("OneDrive", info);
        }
        if (this.appService.getByType("Dropbox") == null) {
            this.initApp("Dropbox", info);
        }
        if (this.appService.getByType("PCloud") == null) {
            this.initApp("PCloud", info);
        }
        if (this.appService.getByType("Box") == null) {
            this.initApp("Box", info);
        }
        if (this.appService.getByType("MediaFire") == null) {
            this.initApp("MediaFire", new AppInfo("", "", ""));
        }
    }

    private void initApp(String type, AppInfo info) {
        App app = new App();
        app.setType(type);
        app.setInfo(new Gson().toJson((Object)info));
        this.appService.save(app);
    }
}

