/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.teamlog;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.teamlog.FileRequestDeadline;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import javax.annotation.Nullable;

public class FileRequestDetails {
    protected final long assetIndex;
    @Nullable
    protected final FileRequestDeadline deadline;

    public FileRequestDetails(long assetIndex, @Nullable FileRequestDeadline deadline) {
        this.assetIndex = assetIndex;
        this.deadline = deadline;
    }

    public FileRequestDetails(long assetIndex) {
        this(assetIndex, null);
    }

    public long getAssetIndex() {
        return this.assetIndex;
    }

    @Nullable
    public FileRequestDeadline getDeadline() {
        return this.deadline;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.assetIndex, this.deadline});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            FileRequestDetails other = (FileRequestDetails)obj;
            return this.assetIndex == other.assetIndex && (this.deadline == other.deadline || this.deadline != null && this.deadline.equals(other.deadline));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<FileRequestDetails> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(FileRequestDetails value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("asset_index");
            StoneSerializers.uInt64().serialize((Long)value.assetIndex, g);
            if (value.deadline != null) {
                g.writeFieldName("deadline");
                StoneSerializers.nullableStruct(FileRequestDeadline.Serializer.INSTANCE).serialize(value.deadline, g);
            }
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public FileRequestDetails deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            FileRequestDeadline f_deadline;
            Long f_assetIndex;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_assetIndex = null;
                f_deadline = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("asset_index".equals(field)) {
                        f_assetIndex = StoneSerializers.uInt64().deserialize(p);
                        continue;
                    }
                    if ("deadline".equals(field)) {
                        f_deadline = StoneSerializers.nullableStruct(FileRequestDeadline.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_assetIndex == null) {
                    throw new JsonParseException(p, "Required field \"asset_index\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            FileRequestDetails value = new FileRequestDetails(f_assetIndex, f_deadline);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }
}

