/*
 * Decompiled with CFR 0.152.
 */
package com.pcloud.sdk.internal.networking;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.pcloud.sdk.Checksums;
import com.pcloud.sdk.RemoteFile;
import com.pcloud.sdk.internal.networking.ApiResponse;
import java.util.Objects;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChecksumsResponse
extends ApiResponse
implements Checksums {
    @Expose
    @SerializedName(value="metadata")
    private RemoteFile file;
    @Expose
    @SerializedName(value="sha1")
    private ByteString sha1;
    @Expose
    @SerializedName(value="sha256")
    private ByteString sha256;
    @Expose
    @SerializedName(value="md5")
    private ByteString md5;

    private ChecksumsResponse() {
    }

    public ChecksumsResponse(int statusCode, @Nullable String message, @Nullable ByteString sha1, @Nullable ByteString sha256, @Nullable ByteString md5, @NotNull RemoteFile file) {
        super(statusCode, message);
        if (sha1 == null && sha256 == null && md5 == null) {
            throw new IllegalArgumentException("At least one checksum variant should be non-null.");
        }
        if (file == null) {
            throw new NullPointerException("Null file argument.");
        }
        this.sha1 = sha1;
        this.sha256 = sha256;
        this.md5 = md5;
    }

    @Override
    @Nullable
    public ByteString getSha1() {
        return this.sha1;
    }

    @Override
    @Nullable
    public ByteString getSha256() {
        return this.sha256;
    }

    @Override
    @Nullable
    public ByteString getMd5() {
        return null;
    }

    @Override
    @NotNull
    public RemoteFile getFile() {
        return this.file;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChecksumsResponse that = (ChecksumsResponse)o;
        return Objects.equals(this.sha1, that.sha1) && Objects.equals(this.sha256, that.sha256) && Objects.equals(this.md5, that.md5) && this.file.equals(that.file);
    }

    public int hashCode() {
        return Objects.hash(this.sha1, this.sha256, this.md5, this.file);
    }

    public String toString() {
        return "ChecksumsResponse{file=" + this.file + ", sha1=" + this.sha1 + ", sha256=" + this.sha256 + ", md5=" + this.md5 + '}';
    }
}

