/*
 * Decompiled with CFR 0.152.
 */
package com.pcloud.sdk.internal;

import com.pcloud.sdk.ApiError;
import com.pcloud.sdk.Call;
import com.pcloud.sdk.Callback;
import java.io.IOException;
import java.util.concurrent.Executor;

class ScheduledCall<T>
implements Call<T> {
    private final Call<T> delegate;
    private final Executor callbackExecutor;

    ScheduledCall(Call<T> delegate, Executor callbackExecutor) {
        this.delegate = delegate;
        this.callbackExecutor = callbackExecutor;
    }

    @Override
    public T execute() throws IOException, ApiError {
        return this.delegate.execute();
    }

    @Override
    public void enqueue(final Callback<T> callback) {
        if (callback == null) {
            throw new IllegalArgumentException("Callback argument cannot be null.");
        }
        this.delegate.enqueue(new Callback<T>(){

            @Override
            public void onResponse(Call<T> call, T response) {
                ScheduledCall.this.callbackExecutor.execute(() -> callback.onResponse(ScheduledCall.this, response));
            }

            @Override
            public void onFailure(Call<T> call, Throwable t) {
                ScheduledCall.this.callbackExecutor.execute(() -> callback.onFailure(ScheduledCall.this, t));
            }
        });
    }

    @Override
    public boolean isExecuted() {
        return this.delegate.isExecuted();
    }

    @Override
    public void cancel() {
        this.delegate.cancel();
    }

    @Override
    public boolean isCanceled() {
        return this.delegate.isCanceled();
    }

    @Override
    public ScheduledCall<T> clone() {
        return new ScheduledCall<T>(this.delegate.clone(), this.callbackExecutor);
    }

    Call<T> delegate() {
        return this.delegate;
    }

    Executor executor() {
        return this.callbackExecutor;
    }
}

