/*
 * Decompiled with CFR 0.152.
 */
package com.pcloud.sdk.internal;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.pcloud.sdk.ApiClient;
import com.pcloud.sdk.ApiError;
import com.pcloud.sdk.RemoteEntry;
import com.pcloud.sdk.RemoteFolder;
import com.pcloud.sdk.internal.RealRemoteEntry;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

public class RealRemoteFolder
extends RealRemoteEntry
implements RemoteFolder {
    private static final List<RemoteEntry> UNKNOWN_CHILDREN = Collections.unmodifiableList(new ArrayList(0));
    @Expose
    @SerializedName(value="folderid")
    private Long folderId;
    @Expose
    @SerializedName(value="contents")
    private final List<RemoteEntry> children = UNKNOWN_CHILDREN;
    @Expose
    @SerializedName(value="cancreate ")
    private boolean canCreate = true;

    RealRemoteFolder(ApiClient apiClient) {
        super(apiClient);
    }

    @Override
    public long folderId() {
        return this.folderId;
    }

    @Override
    public List<RemoteEntry> children() {
        return this.children;
    }

    @Override
    public RemoteFolder reload() throws IOException {
        return this.reload(false);
    }

    @Override
    public RemoteFolder reload(boolean recursively) throws IOException {
        try {
            return this.ownerClient().listFolder(this.folderId(), recursively).execute();
        }
        catch (ApiError apiError) {
            throw new IOException(apiError);
        }
    }

    @Override
    public boolean delete(boolean recursively) throws IOException {
        try {
            return this.ownerClient().deleteFolder(this, recursively).execute();
        }
        catch (ApiError apiError) {
            throw new IOException(apiError);
        }
    }

    @Override
    public final RealRemoteFolder asFolder() {
        return this;
    }

    @Override
    public RemoteFolder copy(RemoteFolder toFolder) throws IOException {
        try {
            return this.ownerClient().copyFolder(this, toFolder).execute();
        }
        catch (ApiError apiError) {
            throw new IOException(apiError);
        }
    }

    @Override
    public RemoteFolder copy(RemoteFolder toFolder, boolean overwrite) throws IOException {
        try {
            return this.ownerClient().copyFolder(this, toFolder, overwrite).execute();
        }
        catch (ApiError apiError) {
            throw new IOException(apiError);
        }
    }

    @Override
    public RemoteFolder move(RemoteFolder toFolder) throws IOException {
        try {
            return this.ownerClient().moveFolder(this, toFolder).execute();
        }
        catch (ApiError apiError) {
            throw new IOException(apiError);
        }
    }

    @Override
    public RemoteFolder rename(String newFilename) throws IOException {
        try {
            return this.ownerClient().renameFolder(this, newFilename).execute();
        }
        catch (ApiError apiError) {
            throw new IOException(apiError);
        }
    }

    @Override
    public boolean canCreate() {
        return this.isMine() || this.canCreate;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RealRemoteFolder that = (RealRemoteFolder)o;
        if (!this.folderId.equals(that.folderId)) {
            return false;
        }
        if (this.canCreate != that.canCreate) {
            return false;
        }
        return this.children.equals(that.children);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.folderId.hashCode();
        result = 31 * result + this.children.hashCode();
        return result;
    }

    public String toString() {
        return String.format(Locale.US, "%s | ID:%s | Created:%s | Modified: %s | Child count:%s", this.name(), this.id(), this.created(), this.lastModified(), this.children == UNKNOWN_CHILDREN ? "?" : Integer.valueOf(this.children().size()));
    }

    static class InstanceCreator
    implements com.google.gson.InstanceCreator<RealRemoteFolder> {
        private final ApiClient apiClient;

        InstanceCreator(ApiClient apiClient) {
            this.apiClient = apiClient;
        }

        public RealRemoteFolder createInstance(Type type) {
            return new RealRemoteFolder(this.apiClient);
        }
    }
}

