/*
 * Decompiled with CFR 0.152.
 */
package com.pcloud.sdk.internal;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.pcloud.sdk.ApiClient;
import com.pcloud.sdk.ApiError;
import com.pcloud.sdk.Call;
import com.pcloud.sdk.DataSink;
import com.pcloud.sdk.DownloadOptions;
import com.pcloud.sdk.FileLink;
import com.pcloud.sdk.ProgressListener;
import com.pcloud.sdk.RemoteFile;
import com.pcloud.sdk.RemoteFolder;
import com.pcloud.sdk.internal.RealRemoteEntry;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.Locale;
import okio.BufferedSource;

class RealRemoteFile
extends RealRemoteEntry
implements RemoteFile {
    @Expose
    @SerializedName(value="fileid")
    private long fileId;
    @Expose
    @SerializedName(value="contenttype")
    private String contentType;
    @Expose
    @SerializedName(value="size")
    private long size;
    @Expose
    @SerializedName(value="hash")
    private String hash;

    RealRemoteFile(ApiClient apiClient) {
        super(apiClient);
    }

    @Override
    public long fileId() {
        return this.fileId;
    }

    @Override
    public String contentType() {
        return this.contentType;
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public String hash() {
        return this.hash;
    }

    @Override
    public FileLink createFileLink(DownloadOptions options) throws IOException, ApiError {
        return this.ownerClient().createFileLink(this.fileId, options).execute();
    }

    @Override
    public FileLink createFileLink() throws IOException, ApiError {
        return this.createFileLink(DownloadOptions.create().skipFilename(true).forceDownload(false).contentType(this.contentType()).build());
    }

    @Override
    public RemoteFile asFile() {
        return this;
    }

    @Override
    public RemoteFile copy(RemoteFolder toFolder) throws IOException {
        return this.copy(toFolder, false);
    }

    @Override
    public RemoteFile copy(RemoteFolder toFolder, boolean overwrite) throws IOException {
        try {
            return this.ownerClient().copyFile(this, toFolder, overwrite).execute();
        }
        catch (ApiError apiError) {
            throw new IOException(apiError);
        }
    }

    @Override
    public RemoteFile move(RemoteFolder toFolder) throws IOException {
        try {
            return this.ownerClient().moveFile(this, toFolder).execute();
        }
        catch (ApiError apiError) {
            throw new IOException(apiError);
        }
    }

    @Override
    public RemoteFile rename(String newFilename) throws IOException {
        try {
            return this.ownerClient().renameFile(this, newFilename).execute();
        }
        catch (ApiError apiError) {
            throw new IOException(apiError);
        }
    }

    @Override
    public InputStream byteStream() throws IOException {
        return this.source().inputStream();
    }

    @Override
    public BufferedSource source() throws IOException {
        boolean success = false;
        Call<BufferedSource> call = this.ownerClient().download(this);
        try {
            BufferedSource source = call.execute();
            success = true;
            BufferedSource bufferedSource = source;
            return bufferedSource;
        }
        catch (ApiError apiError) {
            throw new IOException("API error occurred while trying to download file.", apiError);
        }
        finally {
            if (!success) {
                call.cancel();
            }
        }
    }

    @Override
    public void download(DataSink sink, ProgressListener listener) throws IOException {
        DownloadOptions options = DownloadOptions.create().skipFilename(true).forceDownload(false).contentType(this.contentType()).build();
        try {
            this.ownerClient().createFileLink(this, options).execute().download(sink, listener);
        }
        catch (ApiError apiError) {
            throw new IOException("API error occurred while trying to download file.", apiError);
        }
    }

    @Override
    public void download(DataSink sink) throws IOException {
        this.download(sink, null);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RealRemoteFile that = (RealRemoteFile)o;
        if (this.fileId != that.fileId) {
            return false;
        }
        if (this.size != that.size) {
            return false;
        }
        if (!this.contentType.equals(that.contentType)) {
            return false;
        }
        return this.hash.equals(that.hash);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (int)(this.fileId ^ this.fileId >>> 32);
        result = 31 * result + this.contentType.hashCode();
        result = 31 * result + (int)(this.size ^ this.size >>> 32);
        result = 31 * result + this.hash.hashCode();
        return result;
    }

    public String toString() {
        return String.format(Locale.US, "%s | ID:%s | Created:%s | Modified: %s | Size:%s", this.name(), this.id(), this.created(), this.lastModified(), this.size());
    }

    static class InstanceCreator
    implements com.google.gson.InstanceCreator<RealRemoteFile> {
        private final ApiClient apiClient;

        InstanceCreator(ApiClient apiClient) {
            this.apiClient = apiClient;
        }

        public RealRemoteFile createInstance(Type type) {
            return new RealRemoteFile(this.apiClient);
        }
    }
}

