/*
 * Decompiled with CFR 0.152.
 */
package com.pcloud.sdk.internal;

import com.google.gson.Gson;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.pcloud.sdk.ApiClient;
import com.pcloud.sdk.ApiError;
import com.pcloud.sdk.RemoteEntry;
import com.pcloud.sdk.RemoteFile;
import com.pcloud.sdk.RemoteFolder;
import com.pcloud.sdk.internal.RealRemoteFile;
import com.pcloud.sdk.internal.RealRemoteFolder;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Date;

abstract class RealRemoteEntry
implements RemoteEntry {
    private final ApiClient apiClient;
    @Expose
    @SerializedName(value="id")
    private String id;
    @Expose
    @SerializedName(value="parentfolderid")
    private long parentFolderId;
    @Expose
    @SerializedName(value="name")
    private String name;
    @Expose
    @SerializedName(value="modified")
    private Date lastModified;
    @Expose
    @SerializedName(value="created")
    private Date created;
    @Expose
    @SerializedName(value="isfolder")
    private boolean isFolder;
    @Expose
    @SerializedName(value="isshared")
    private boolean isShared;
    @Expose
    @SerializedName(value="ismine")
    private boolean isMine;
    @Expose
    @SerializedName(value="canread")
    private boolean canRead = true;
    @Expose
    @SerializedName(value="canmodify")
    private boolean canModify = true;
    @Expose
    @SerializedName(value="candelete")
    private boolean canDelete = true;

    RealRemoteEntry(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Date lastModified() {
        return this.lastModified;
    }

    @Override
    public Date created() {
        return this.created;
    }

    @Override
    public long parentFolderId() {
        return this.parentFolderId;
    }

    @Override
    public boolean isFile() {
        return !this.isFolder;
    }

    @Override
    public boolean isFolder() {
        return this.isFolder;
    }

    @Override
    public RemoteFolder asFolder() {
        throw new IllegalStateException("This entry is not a folder");
    }

    @Override
    public RemoteFile asFile() {
        throw new IllegalStateException("This entry is not a file");
    }

    @Override
    public boolean delete() throws IOException {
        try {
            return this.apiClient.delete(this).execute();
        }
        catch (ApiError apiError) {
            throw new IOException(apiError);
        }
    }

    @Override
    public boolean canRead() {
        return this.isMine || this.canRead;
    }

    @Override
    public boolean canModify() {
        return this.isMine || this.canModify;
    }

    @Override
    public boolean canDelete() {
        return this.isMine || this.canDelete;
    }

    @Override
    public boolean isMine() {
        return this.isMine;
    }

    @Override
    public boolean isShared() {
        return this.isShared;
    }

    protected ApiClient ownerClient() {
        return this.apiClient;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RealRemoteEntry that = (RealRemoteEntry)o;
        if (this.parentFolderId != that.parentFolderId) {
            return false;
        }
        if (this.isFolder != that.isFolder) {
            return false;
        }
        if (!this.id.equals(that.id)) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (!this.lastModified.equals(that.lastModified)) {
            return false;
        }
        if (this.isMine != that.isMine) {
            return false;
        }
        if (this.isShared != that.isShared) {
            return false;
        }
        if (this.canRead != that.canRead) {
            return false;
        }
        if (this.canModify != that.canModify) {
            return false;
        }
        if (this.canDelete != that.canDelete) {
            return false;
        }
        return this.created.equals(that.created);
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = 31 * result + (int)(this.parentFolderId ^ this.parentFolderId >>> 32);
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.lastModified.hashCode();
        result = 31 * result + this.created.hashCode();
        result = 31 * result + (this.isFolder ? 1 : 0);
        return result;
    }

    static class FileEntryDeserializer
    implements JsonDeserializer<RemoteEntry> {
        FileEntryDeserializer() {
        }

        public RemoteEntry deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json.getAsJsonObject().get("isfolder").getAsBoolean()) {
                return (RemoteEntry)context.deserialize(json, RealRemoteFolder.class);
            }
            return (RemoteEntry)context.deserialize(json, RealRemoteFile.class);
        }
    }

    static class TypeAdapterFactory
    implements com.google.gson.TypeAdapterFactory {
        private static final TypeToken<RemoteEntry> FILE_ENTRY_TYPE_TOKEN = new TypeToken<RemoteEntry>(){};
        private static final TypeToken<RemoteFile> REMOTE_FILE_TYPE_TOKEN = new TypeToken<RemoteFile>(){};
        private static final TypeToken<RemoteFolder> REMOTE_FOLDER_TYPE_TOKEN = new TypeToken<RemoteFolder>(){};

        TypeAdapterFactory() {
        }

        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (FILE_ENTRY_TYPE_TOKEN.equals(type)) {
                return gson.getAdapter(FILE_ENTRY_TYPE_TOKEN);
            }
            if (REMOTE_FILE_TYPE_TOKEN.equals(type)) {
                return gson.getAdapter(RealRemoteFile.class);
            }
            if (REMOTE_FOLDER_TYPE_TOKEN.equals(type)) {
                return gson.getAdapter(RealRemoteFolder.class);
            }
            return null;
        }
    }
}

