/*
 * Decompiled with CFR 0.152.
 */
package com.pcloud.sdk.internal;

import com.pcloud.sdk.ApiClient;
import com.pcloud.sdk.ApiError;
import com.pcloud.sdk.Call;
import com.pcloud.sdk.DataSink;
import com.pcloud.sdk.FileLink;
import com.pcloud.sdk.ProgressListener;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import okio.BufferedSource;

class RealFileLink
implements FileLink {
    private final ApiClient apiClient;
    private final Date expirationDate;
    private final List<URL> links;

    RealFileLink(ApiClient apiClient, Date expirationDate, List<URL> links) {
        this.apiClient = apiClient;
        this.expirationDate = expirationDate;
        this.links = Collections.unmodifiableList(links);
    }

    @Override
    public Date expirationDate() {
        return this.expirationDate;
    }

    @Override
    public List<URL> urls() {
        return this.links;
    }

    @Override
    public URL bestUrl() {
        return this.links.get(0);
    }

    @Override
    public InputStream byteStream() throws IOException, ApiError {
        return this.source(this.bestUrl()).inputStream();
    }

    @Override
    public InputStream byteStream(URL linkVariant) throws IOException, ApiError {
        return this.source(linkVariant).inputStream();
    }

    @Override
    public BufferedSource source() throws IOException, ApiError {
        return this.source(this.bestUrl());
    }

    @Override
    public BufferedSource source(URL linkVariant) throws IOException, ApiError {
        RealFileLink.requireUrlFromLink(this, linkVariant);
        boolean success = false;
        Call<BufferedSource> call = this.apiClient.download(this);
        try {
            BufferedSource source = call.execute();
            success = true;
            BufferedSource bufferedSource = source;
            return bufferedSource;
        }
        catch (ApiError apiError) {
            throw new IOException("API error occurred while trying to read from download link.", apiError);
        }
        finally {
            if (!success) {
                call.cancel();
            }
        }
    }

    @Override
    public void download(DataSink sink, ProgressListener listener) throws IOException, ApiError {
        this.apiClient.download(this, sink, listener).execute();
    }

    @Override
    public void download(URL linkVariant, DataSink sink, ProgressListener listener) throws IOException, ApiError {
        RealFileLink.requireUrlFromLink(this, linkVariant);
        this.apiClient.download(this, linkVariant, sink, listener).execute();
    }

    @Override
    public void download(DataSink sink) throws IOException, ApiError {
        this.apiClient.download(this, this.bestUrl(), sink, null).execute();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RealFileLink that = (RealFileLink)o;
        if (!this.expirationDate.equals(that.expirationDate)) {
            return false;
        }
        return this.links.equals(that.links);
    }

    public int hashCode() {
        int result = this.expirationDate.hashCode();
        result = 31 * result + this.links.hashCode();
        return result;
    }

    public String toString() {
        return String.format(Locale.US, "%s | Valid until:%s", this.bestUrl(), this.expirationDate);
    }

    static void requireLinkNotNull(FileLink fileLink) {
        if (fileLink == null) {
            throw new IllegalArgumentException("FileLink argument cannot be null.");
        }
    }

    static void requireUrlFromLink(FileLink fileLink, URL linkVariant) {
        if (!fileLink.urls().contains(linkVariant)) {
            throw new IllegalArgumentException("Provided url must be one of the variants in the provided file link.");
        }
    }
}

