/*
 * Decompiled with CFR 0.152.
 */
package com.pcloud.sdk.internal;

import com.pcloud.sdk.ApiClient;
import com.pcloud.sdk.Authenticator;
import com.pcloud.sdk.internal.RealApiClient;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import okhttp3.Cache;
import okhttp3.ConnectionPool;
import okhttp3.Dispatcher;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;

class RealApiServiceBuilder
implements ApiClient.Builder {
    private static final HttpUrl DEFAULT_API_HOST = HttpUrl.parse((String)"https://api.pcloud.com");
    private Cache cache;
    private Executor callbackExecutor;
    private ConnectionPool connectionPool;
    private Dispatcher dispatcher;
    private int readTimeoutMs;
    private int writeTimeoutMs;
    private int connectTimeoutMs;
    private long progressCallbackThresholdBytes;
    private Authenticator authenticator;
    private HttpUrl apiHost;

    RealApiServiceBuilder(OkHttpClient okHttpClient, Executor callbackExecutor, long progressCallbackThresholdBytes, Authenticator authenticator, HttpUrl apiHost) {
        this.cache = okHttpClient.cache();
        this.callbackExecutor = callbackExecutor;
        this.connectionPool = okHttpClient.connectionPool();
        this.dispatcher = okHttpClient.dispatcher();
        this.readTimeoutMs = okHttpClient.readTimeoutMillis();
        this.writeTimeoutMs = okHttpClient.writeTimeoutMillis();
        this.connectTimeoutMs = okHttpClient.connectTimeoutMillis();
        this.progressCallbackThresholdBytes = progressCallbackThresholdBytes;
        this.authenticator = authenticator;
        this.apiHost = apiHost;
    }

    RealApiServiceBuilder() {
        this.apiHost = DEFAULT_API_HOST;
    }

    @Override
    public ApiClient.Builder cache(Cache cache) {
        this.cache = cache;
        return this;
    }

    @Override
    public ApiClient.Builder connectionPool(ConnectionPool connectionPool) {
        this.connectionPool = connectionPool;
        return this;
    }

    @Override
    public ApiClient.Builder dispatcher(Dispatcher dispatcher) {
        this.dispatcher = dispatcher;
        return this;
    }

    @Override
    public ApiClient.Builder withClient(OkHttpClient client) {
        return this.cache(client.cache()).connectionPool(client.connectionPool()).dispatcher(client.dispatcher()).readTimeout(client.readTimeoutMillis(), TimeUnit.MILLISECONDS).writeTimeout(client.writeTimeoutMillis(), TimeUnit.MILLISECONDS).connectTimeout(client.connectTimeoutMillis(), TimeUnit.MILLISECONDS);
    }

    @Override
    public ApiClient.Builder readTimeout(long timeout, TimeUnit timeUnit) {
        this.readTimeoutMs = (int)timeUnit.toMillis(timeout);
        return this;
    }

    @Override
    public ApiClient.Builder writeTimeout(long timeout, TimeUnit timeUnit) {
        this.writeTimeoutMs = (int)timeUnit.toMillis(timeout);
        return this;
    }

    @Override
    public ApiClient.Builder connectTimeout(long timeout, TimeUnit timeUnit) {
        this.connectTimeoutMs = (int)timeUnit.toMillis(timeout);
        return this;
    }

    @Override
    public ApiClient.Builder authenticator(Authenticator authenticator) {
        this.authenticator = authenticator;
        return this;
    }

    @Override
    public ApiClient.Builder callbackExecutor(Executor callbackExecutor) {
        this.callbackExecutor = callbackExecutor;
        return this;
    }

    @Override
    public ApiClient.Builder progressCallbackThreshold(long bytes) {
        if (bytes < 0L) {
            throw new IllegalArgumentException("Threshold parameter must a positive number.");
        }
        this.progressCallbackThresholdBytes = bytes;
        return this;
    }

    @Override
    public ApiClient create() {
        return new RealApiClient(this);
    }

    public Cache cache() {
        return this.cache;
    }

    public Executor callbackExecutor() {
        return this.callbackExecutor;
    }

    public ConnectionPool connectionPool() {
        return this.connectionPool;
    }

    public Dispatcher dispatcher() {
        return this.dispatcher;
    }

    public int readTimeoutMs() {
        return this.readTimeoutMs;
    }

    public int writeTimeoutMs() {
        return this.writeTimeoutMs;
    }

    public int connectTimeoutMs() {
        return this.connectTimeoutMs;
    }

    public long progressCallbackThresholdBytes() {
        return this.progressCallbackThresholdBytes;
    }

    public HttpUrl apiHost() {
        return this.apiHost;
    }

    public Authenticator authenticator() {
        return this.authenticator;
    }

    @Override
    public ApiClient.Builder apiHost(String apiHost) {
        HttpUrl newHost = HttpUrl.parse((String)("https://" + apiHost));
        if (newHost == null) {
            throw new IllegalArgumentException("'" + apiHost + "' is not a valid API host.");
        }
        this.apiHost = newHost;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RealApiServiceBuilder builder = (RealApiServiceBuilder)o;
        if (this.readTimeoutMs != builder.readTimeoutMs) {
            return false;
        }
        if (this.writeTimeoutMs != builder.writeTimeoutMs) {
            return false;
        }
        if (this.connectTimeoutMs != builder.connectTimeoutMs) {
            return false;
        }
        if (this.progressCallbackThresholdBytes != builder.progressCallbackThresholdBytes) {
            return false;
        }
        if (!Objects.equals(this.cache, builder.cache)) {
            return false;
        }
        if (!Objects.equals(this.callbackExecutor, builder.callbackExecutor)) {
            return false;
        }
        if (!Objects.equals(this.connectionPool, builder.connectionPool)) {
            return false;
        }
        if (!Objects.equals(this.dispatcher, builder.dispatcher)) {
            return false;
        }
        return Objects.equals(this.authenticator, builder.authenticator);
    }

    public int hashCode() {
        int result = this.cache != null ? this.cache.hashCode() : 0;
        result = 31 * result + (this.callbackExecutor != null ? this.callbackExecutor.hashCode() : 0);
        result = 31 * result + (this.connectionPool != null ? this.connectionPool.hashCode() : 0);
        result = 31 * result + (this.dispatcher != null ? this.dispatcher.hashCode() : 0);
        result = 31 * result + this.readTimeoutMs;
        result = 31 * result + this.writeTimeoutMs;
        result = 31 * result + this.connectTimeoutMs;
        result = 31 * result + (int)(this.progressCallbackThresholdBytes ^ this.progressCallbackThresholdBytes >>> 32);
        result = 31 * result + (this.authenticator != null ? this.authenticator.hashCode() : 0);
        return result;
    }
}

