/*
 * Decompiled with CFR 0.152.
 */
package com.pcloud.sdk.internal;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.stream.JsonReader;
import com.pcloud.sdk.ApiClient;
import com.pcloud.sdk.ApiError;
import com.pcloud.sdk.Authenticator;
import com.pcloud.sdk.Call;
import com.pcloud.sdk.Checksums;
import com.pcloud.sdk.DataSink;
import com.pcloud.sdk.DataSource;
import com.pcloud.sdk.DownloadOptions;
import com.pcloud.sdk.FileLink;
import com.pcloud.sdk.ProgressListener;
import com.pcloud.sdk.RemoteEntry;
import com.pcloud.sdk.RemoteFile;
import com.pcloud.sdk.RemoteFolder;
import com.pcloud.sdk.UploadOptions;
import com.pcloud.sdk.UserInfo;
import com.pcloud.sdk.internal.ExecutorProgressListener;
import com.pcloud.sdk.internal.FileIdUtils;
import com.pcloud.sdk.internal.GlobalRequestInterceptor;
import com.pcloud.sdk.internal.IOUtils;
import com.pcloud.sdk.internal.OkHttpCall;
import com.pcloud.sdk.internal.ProgressCountingSink;
import com.pcloud.sdk.internal.ProgressCountingSource;
import com.pcloud.sdk.internal.RealApiServiceBuilder;
import com.pcloud.sdk.internal.RealAuthenticator;
import com.pcloud.sdk.internal.RealFileLink;
import com.pcloud.sdk.internal.RealRemoteEntry;
import com.pcloud.sdk.internal.RealRemoteFile;
import com.pcloud.sdk.internal.RealRemoteFolder;
import com.pcloud.sdk.internal.RealUserInfo;
import com.pcloud.sdk.internal.ResponseAdapter;
import com.pcloud.sdk.internal.ScheduledCall;
import com.pcloud.sdk.internal.networking.APIHttpException;
import com.pcloud.sdk.internal.networking.ApiResponse;
import com.pcloud.sdk.internal.networking.ChecksumsResponse;
import com.pcloud.sdk.internal.networking.GetFileResponse;
import com.pcloud.sdk.internal.networking.GetFolderResponse;
import com.pcloud.sdk.internal.networking.GetLinkResponse;
import com.pcloud.sdk.internal.networking.UploadFilesResponse;
import com.pcloud.sdk.internal.networking.UserInfoResponse;
import com.pcloud.sdk.internal.networking.serialization.ByteStringTypeAdapter;
import com.pcloud.sdk.internal.networking.serialization.DateTypeAdapter;
import com.pcloud.sdk.internal.networking.serialization.UnmodifiableListTypeFactory;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import java.util.Objects;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import okhttp3.Cache;
import okhttp3.ConnectionPool;
import okhttp3.Dispatcher;
import okhttp3.FormBody;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.ByteString;
import okio.Okio;
import okio.Sink;
import okio.Source;
import org.jetbrains.annotations.NotNull;

class RealApiClient
implements ApiClient {
    private static final String MULTIPART_BOUNDARY = "----pCloud-SDK-1.9.1-" + UUID.randomUUID() + "----";
    private final long progressCallbackThresholdBytes;
    private final Authenticator authenticator;
    private final Gson gson;
    private final OkHttpClient httpClient;
    private final Executor callbackExecutor;
    private final HttpUrl apiHost;

    RealApiClient() {
        this(new RealApiServiceBuilder());
    }

    RealApiClient(RealApiServiceBuilder builder) {
        TreeMap<String, String> globalParams = new TreeMap<String, String>();
        globalParams.put("timeformat", "timestamp");
        String userAgent = String.format(Locale.US, "pCloud SDK Java %s", "1.9.1");
        OkHttpClient.Builder httpClientBuilder = new OkHttpClient.Builder().readTimeout((long)builder.readTimeoutMs(), TimeUnit.MILLISECONDS).writeTimeout((long)builder.writeTimeoutMs(), TimeUnit.MILLISECONDS).connectTimeout((long)builder.connectTimeoutMs(), TimeUnit.MILLISECONDS).protocols(Collections.singletonList(Protocol.HTTP_1_1)).addInterceptor((Interceptor)new GlobalRequestInterceptor(userAgent, globalParams));
        if (builder.dispatcher() != null) {
            httpClientBuilder.dispatcher(builder.dispatcher());
        }
        if (builder.connectionPool() != null) {
            httpClientBuilder.connectionPool(builder.connectionPool());
        }
        if (builder.cache() != null) {
            httpClientBuilder.cache(builder.cache());
        }
        httpClientBuilder.authenticator(okhttp3.Authenticator.NONE);
        this.authenticator = builder.authenticator();
        if (this.authenticator != null) {
            httpClientBuilder.addInterceptor((Interceptor)((RealAuthenticator)builder.authenticator()));
        }
        this.httpClient = httpClientBuilder.build();
        this.callbackExecutor = builder.callbackExecutor();
        this.progressCallbackThresholdBytes = builder.progressCallbackThresholdBytes();
        this.gson = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().registerTypeAdapterFactory((TypeAdapterFactory)new RealRemoteEntry.TypeAdapterFactory()).registerTypeAdapterFactory((TypeAdapterFactory)new UnmodifiableListTypeFactory()).registerTypeAdapter(RemoteEntry.class, (Object)new RealRemoteEntry.FileEntryDeserializer()).registerTypeAdapter(Date.class, (Object)new DateTypeAdapter()).registerTypeAdapter(RealRemoteFile.class, (Object)new RealRemoteFile.InstanceCreator(this)).registerTypeAdapter(RealRemoteFolder.class, (Object)new RealRemoteFolder.InstanceCreator(this)).registerTypeAdapter(ByteString.class, (Object)new ByteStringTypeAdapter()).create();
        this.apiHost = builder.apiHost();
    }

    @Override
    public Call<RemoteFolder> listFolder(long folderId) {
        return this.listFolder(folderId, false);
    }

    @Override
    public Call<RemoteFolder> listFolder(long folderId, boolean recursively) {
        HttpUrl.Builder urlBuilder = this.apiHost.newBuilder().addPathSegment("listfolder").addQueryParameter("folderid", String.valueOf(folderId));
        if (recursively) {
            urlBuilder.addEncodedQueryParameter("recursive", String.valueOf(1));
        }
        Request request = this.newRequest().url(urlBuilder.build()).get().build();
        return this.newCall(request, response -> this.getAsApiResponse(response, GetFolderResponse.class).getFolder());
    }

    @Override
    public Call<RemoteFolder> listFolder(String path) {
        return this.listFolder(path, false);
    }

    @Override
    public Call<RemoteFolder> listFolder(String path, boolean recursively) {
        this.requireValidPath(path);
        HttpUrl.Builder urlBuilder = this.apiHost.newBuilder().addPathSegment("listfolder").addEncodedQueryParameter("path", path);
        if (recursively) {
            urlBuilder.addEncodedQueryParameter("recursive", String.valueOf(1));
        }
        Request request = this.newRequest().url(urlBuilder.build()).get().build();
        return this.newCall(request, response -> this.getAsApiResponse(response, GetFolderResponse.class).getFolder());
    }

    @Override
    public Call<RemoteFile> createFile(RemoteFolder folder, String filename, DataSource data) {
        return this.createFile(folder, filename, data, null, null, UploadOptions.DEFAULT);
    }

    @Override
    public Call<RemoteFile> createFile(RemoteFolder folder, String filename, DataSource data, UploadOptions uploadOptions) {
        return this.createFile(folder, filename, data, null, null, uploadOptions);
    }

    @Override
    public Call<RemoteFile> createFile(RemoteFolder folder, String filename, DataSource data, Date modifiedDate, ProgressListener listener) {
        return this.createFile(folder, filename, data, modifiedDate, listener, UploadOptions.DEFAULT);
    }

    @Override
    public Call<RemoteFile> createFile(RemoteFolder folder, String filename, DataSource data, Date modifiedDate, ProgressListener listener, UploadOptions uploadOptions) {
        if (folder == null) {
            throw new IllegalArgumentException("Folder argument cannot be null.");
        }
        return this.createFile(folder.folderId(), filename, data, modifiedDate, listener, uploadOptions);
    }

    @Override
    public Call<RemoteFile> createFile(long folderId, String filename, DataSource data) {
        return this.createFile(folderId, filename, data, null, null, UploadOptions.DEFAULT);
    }

    @Override
    public Call<RemoteFile> createFile(long folderId, String filename, DataSource data, UploadOptions uploadOptions) {
        return this.createFile(folderId, filename, data, null, null, uploadOptions);
    }

    @Override
    public Call<RemoteFile> createFile(long folderId, String filename, DataSource data, Date modifiedDate, ProgressListener listener) {
        return this.createFile(folderId, filename, data, modifiedDate, listener, UploadOptions.DEFAULT);
    }

    @Override
    public Call<RemoteFile> createFile(long folderId, String filename, DataSource data, Date modifiedDate, ProgressListener listener, UploadOptions uploadOptions) {
        return this.createFile(folderId, null, filename, data, modifiedDate, listener, uploadOptions);
    }

    @Override
    public Call<RemoteFile> createFile(String path, String filename, DataSource data) {
        return this.createFile(path, filename, data, null, null, UploadOptions.DEFAULT);
    }

    @Override
    public Call<RemoteFile> createFile(String path, String filename, DataSource data, UploadOptions uploadOptions) {
        return this.createFile(path, filename, data, null, null, uploadOptions);
    }

    @Override
    public Call<RemoteFile> createFile(String path, String filename, DataSource data, Date modifiedDate, ProgressListener listener) {
        return this.createFile(path, filename, data, modifiedDate, listener, UploadOptions.DEFAULT);
    }

    @Override
    public Call<RemoteFile> createFile(String path, String filename, DataSource data, Date modifiedDate, ProgressListener listener, UploadOptions uploadOptions) {
        this.requireValidPath(path);
        return this.createFile(null, path, filename, data, modifiedDate, listener, uploadOptions);
    }

    private Call<RemoteFile> createFile(Long folderId, String path, String filename, final DataSource data, Date modifiedDate, final ProgressListener listener, UploadOptions uploadOptions) {
        if (filename == null) {
            throw new IllegalArgumentException("Filename cannot be null.");
        }
        if (data == null) {
            throw new IllegalArgumentException("File data cannot be null.");
        }
        if (uploadOptions == null) {
            throw new IllegalArgumentException("Upload options cannot be null.");
        }
        RequestBody dataBody = new RequestBody(){

            public MediaType contentType() {
                return MediaType.parse((String)"multipart/form-data");
            }

            public void writeTo(@NotNull BufferedSink sink) throws IOException {
                if (listener != null) {
                    ProgressListener realListener = listener;
                    if (RealApiClient.this.callbackExecutor != null) {
                        realListener = new ExecutorProgressListener(listener, RealApiClient.this.callbackExecutor);
                    }
                    BufferedSink targetSink = Okio.buffer((Sink)new ProgressCountingSink((Sink)sink, data.contentLength(), realListener, RealApiClient.this.progressCallbackThresholdBytes));
                    data.writeTo(targetSink);
                    targetSink.emit();
                } else {
                    data.writeTo(sink);
                }
            }

            public long contentLength() {
                long contentLength = data.contentLength();
                if (contentLength < 0L) {
                    throw new IllegalArgumentException("Content length must be >= 0.");
                }
                return contentLength;
            }
        };
        MultipartBody compositeBody = new MultipartBody.Builder(MULTIPART_BOUNDARY).setType(MultipartBody.FORM).addFormDataPart("file", filename, dataBody).build();
        HttpUrl.Builder urlBuilder = this.apiHost.newBuilder().addPathSegment("uploadfile").addQueryParameter("renameifexists", String.valueOf(uploadOptions.overrideFile() ? 0 : 1)).addQueryParameter("nopartial", String.valueOf(uploadOptions.partialUpload() ? 0 : 1));
        if (folderId != null) {
            urlBuilder.addQueryParameter("folderid", String.valueOf(folderId));
        }
        if (path != null) {
            urlBuilder.addEncodedQueryParameter("path", path);
        }
        if (modifiedDate != null) {
            urlBuilder.addQueryParameter("mtime", String.valueOf(TimeUnit.MILLISECONDS.toSeconds(modifiedDate.getTime())));
        }
        Request uploadRequest = new Request.Builder().url(urlBuilder.build()).method("POST", (RequestBody)compositeBody).build();
        return this.newCall(uploadRequest, response -> {
            UploadFilesResponse body = this.getAsApiResponse(response, UploadFilesResponse.class);
            if (!body.getUploadedFiles().isEmpty()) {
                return body.getUploadedFiles().get(0);
            }
            throw new IOException("API uploaded file but did not return remote file data.");
        });
    }

    @Override
    public Call<Boolean> deleteFile(RemoteFile file) {
        if (file == null) {
            throw new IllegalArgumentException("File argument cannot be null.");
        }
        return this.deleteFile(file.fileId());
    }

    @Override
    public Call<Boolean> deleteFile(long fileId) {
        Request request = new Request.Builder().url(this.apiHost.newBuilder().addPathSegment("deletefile").build()).get().post((RequestBody)new FormBody.Builder().add("fileid", String.valueOf(fileId)).build()).build();
        return this.newCall(request, response -> {
            GetFileResponse body = this.deserializeResponseBody(response, GetFileResponse.class);
            return body.isSuccessful() && body.getFile() != null;
        });
    }

    @Override
    public Call<Boolean> deleteFile(String path) {
        this.requireValidPath(path);
        Request request = new Request.Builder().url(this.apiHost.newBuilder().addPathSegment("deletefile").build()).get().post((RequestBody)new FormBody.Builder().addEncoded("path", path).build()).build();
        return this.newCall(request, response -> {
            GetFileResponse body = this.deserializeResponseBody(response, GetFileResponse.class);
            return body.isSuccessful() && body.getFile() != null;
        });
    }

    @Override
    public Call<FileLink> createFileLink(RemoteFile file, DownloadOptions options) {
        if (file == null) {
            throw new IllegalArgumentException("File argument cannot be null.");
        }
        return this.createFileLink(file.fileId(), options);
    }

    @Override
    public Call<FileLink> createFileLink(long fileId, DownloadOptions options) {
        if (options == null) {
            throw new IllegalArgumentException("DownloadOptions parameter cannot be null.");
        }
        Request request = this.newDownloadLinkRequest(fileId, null, options);
        return this.newCall(request, this::getAsFileLink);
    }

    @Override
    public Call<FileLink> createFileLink(String path, DownloadOptions options) {
        this.requireValidPath(path);
        if (options == null) {
            throw new IllegalArgumentException("DownloadOptions parameter cannot be null.");
        }
        Request request = this.newDownloadLinkRequest(null, path, options);
        return this.newCall(request, this::getAsFileLink);
    }

    private FileLink getAsFileLink(Response response) throws IOException, ApiError {
        GetLinkResponse body = this.getAsApiResponse(response, GetLinkResponse.class);
        ArrayList<URL> downloadUrls = new ArrayList<URL>(body.getHosts().size());
        for (String host : body.getHosts()) {
            downloadUrls.add(new URL("https", host, body.getPath()));
        }
        return new RealFileLink(this, body.getExpires(), downloadUrls);
    }

    private Request newDownloadLinkRequest(Long fileId, String path, DownloadOptions options) {
        HttpUrl.Builder urlBuilder = this.apiHost.newBuilder().addPathSegment("getfilelink");
        if (fileId != null) {
            urlBuilder.addQueryParameter("fileid", String.valueOf(fileId));
        }
        if (path != null) {
            urlBuilder.addEncodedQueryParameter("path", path);
        }
        if (options.forceDownload()) {
            urlBuilder.addQueryParameter("forcedownload", String.valueOf(1));
        }
        if (options.skipFilename()) {
            urlBuilder.addQueryParameter("skipfilename", String.valueOf(1));
        }
        if (options.contentType() != null) {
            MediaType mediaType = MediaType.parse((String)options.contentType());
            if (mediaType == null) {
                throw new IllegalArgumentException("Invalid or not well-formatted content type DownloadOptions argument");
            }
            urlBuilder.addQueryParameter("contenttype", mediaType.toString());
        }
        return new Request.Builder().url(urlBuilder.build()).get().build();
    }

    @Override
    public Call<Void> download(FileLink fileLink, DataSink sink) {
        RealFileLink.requireLinkNotNull(fileLink);
        return this.download(fileLink, fileLink.bestUrl(), sink, null);
    }

    @Override
    public Call<Void> download(FileLink fileLink, DataSink sink, ProgressListener listener) {
        RealFileLink.requireLinkNotNull(fileLink);
        return this.download(fileLink, fileLink.bestUrl(), sink, listener);
    }

    @Override
    public Call<Void> download(FileLink fileLink, URL linkVariant, DataSink sink, ProgressListener listener) {
        if (fileLink == null) {
            throw new IllegalArgumentException("FileLink argument cannot be null.");
        }
        RealFileLink.requireUrlFromLink(fileLink, linkVariant);
        if (sink == null) {
            throw new IllegalArgumentException("DataSink argument cannot be null.");
        }
        Request request = this.newDownloadRequest(linkVariant);
        return this.newCall(request, response -> {
            try {
                BufferedSource source = this.getAsRawBytes(response);
                if (listener != null) {
                    ProgressListener realListener = listener;
                    if (this.callbackExecutor != null) {
                        realListener = new ExecutorProgressListener(listener, this.callbackExecutor);
                    }
                    source = Okio.buffer((Source)new ProgressCountingSource((Source)source, Objects.requireNonNull(response.body()).contentLength(), realListener, this.progressCallbackThresholdBytes));
                }
                sink.readAll(source);
                Void void_ = null;
                return void_;
            }
            finally {
                IOUtils.closeQuietly((Closeable)response);
            }
        });
    }

    @Override
    public Call<BufferedSource> download(RemoteFile file) {
        if (file == null) {
            throw new IllegalArgumentException("RemoteFile argument cannot be null.");
        }
        DownloadOptions options = DownloadOptions.create().skipFilename(false).contentType(file.contentType()).build();
        return this.newCall(this.newDownloadLinkRequest(file.fileId(), null, options), response -> {
            FileLink link = this.getAsFileLink(response);
            return this.newDownloadCall(link.bestUrl());
        });
    }

    @Override
    public Call<BufferedSource> download(FileLink fileLink) {
        RealFileLink.requireLinkNotNull(fileLink);
        return this.download(fileLink, fileLink.bestUrl());
    }

    @Override
    public Call<BufferedSource> download(FileLink fileLink, URL linkVariant) {
        RealFileLink.requireLinkNotNull(fileLink);
        RealFileLink.requireUrlFromLink(fileLink, linkVariant);
        return this.newCall(this.newDownloadRequest(linkVariant), this::getAsRawBytes);
    }

    @Override
    public Call<RemoteFile> copyFile(long fileId, long toFolderId) {
        return this.copyFile(fileId, toFolderId, false);
    }

    @Override
    public Call<RemoteFile> copyFile(long fileId, long toFolderId, boolean overwrite) {
        FormBody.Builder builder = new FormBody.Builder().add("fileid", String.valueOf(fileId)).add("tofolderid", String.valueOf(toFolderId));
        if (!overwrite) {
            builder.add("noover", String.valueOf(1));
        }
        Request request = this.newRequest().url(this.apiHost.newBuilder().addPathSegment("copyfile").build()).post((RequestBody)builder.build()).build();
        return this.newCall(request, response -> this.getAsApiResponse(response, GetFileResponse.class).getFile());
    }

    @Override
    public Call<RemoteFile> copyFile(RemoteFile file, RemoteFolder toFolder) {
        return this.copyFile(file, toFolder, false);
    }

    @Override
    public Call<RemoteFile> copyFile(RemoteFile file, RemoteFolder toFolder, boolean overwrite) {
        if (file == null) {
            throw new IllegalArgumentException("file argument cannot be null.");
        }
        if (toFolder == null) {
            throw new IllegalArgumentException("toFolder argument cannot be null.");
        }
        return this.copyFile(file.fileId(), toFolder.folderId(), overwrite);
    }

    @Override
    public Call<? extends RemoteEntry> copy(RemoteEntry file, RemoteFolder toFolder) {
        return this.copy(file, toFolder, false);
    }

    @Override
    public Call<? extends RemoteEntry> copy(RemoteEntry file, RemoteFolder toFolder, boolean overwriteFiles) {
        if (file == null) {
            throw new IllegalArgumentException("RemoteEntry argument cannot be null.");
        }
        if (toFolder == null) {
            throw new IllegalArgumentException("RemoteFolder argument cannot be null.");
        }
        long toFolderId = toFolder.folderId();
        return file.isFolder() ? this.copyFolder(file.asFolder().folderId(), toFolderId, overwriteFiles) : this.copyFile(file.asFile().fileId(), toFolderId, overwriteFiles);
    }

    @Override
    public Call<? extends RemoteEntry> copy(String id, long toFolderId) {
        return this.copy(id, toFolderId, false);
    }

    @Override
    public Call<? extends RemoteEntry> copy(String id, long toFolderId, boolean overwriteFiles) {
        if (id == null) {
            throw new IllegalArgumentException("File identifier argument cannot be null.");
        }
        return FileIdUtils.isFile(id) ? this.copyFile(FileIdUtils.toFileId(id), toFolderId, overwriteFiles) : this.copyFile(FileIdUtils.toFolderId(id), toFolderId, overwriteFiles);
    }

    @Override
    public Call<? extends RemoteEntry> move(RemoteEntry file, RemoteFolder toFolder) {
        if (file == null) {
            throw new IllegalArgumentException("RemoteEntry argument cannot be null.");
        }
        if (toFolder == null) {
            throw new IllegalArgumentException("RemoteFolder argument cannot be null.");
        }
        long toFolderId = toFolder.folderId();
        return file.isFolder() ? this.moveFolder(file.asFolder().folderId(), toFolderId) : this.moveFile(file.asFile().fileId(), toFolderId);
    }

    @Override
    public Call<? extends RemoteEntry> move(String id, long toFolderId) {
        if (id == null) {
            throw new IllegalArgumentException("File identifier argument cannot be null.");
        }
        return FileIdUtils.isFile(id) ? this.moveFile(FileIdUtils.toFileId(id), toFolderId) : this.moveFolder(FileIdUtils.toFolderId(id), toFolderId);
    }

    @Override
    public Call<Boolean> delete(RemoteEntry file) {
        if (file == null) {
            throw new IllegalArgumentException("RemoteEntry argument cannot be null.");
        }
        return file.isFolder() ? this.deleteFolder(file.asFolder().folderId()) : this.deleteFile(file.asFile().fileId());
    }

    @Override
    public Call<Boolean> delete(String id) {
        if (id == null) {
            throw new IllegalArgumentException("File identifier argument cannot be null.");
        }
        return FileIdUtils.isFile(id) ? this.deleteFile(FileIdUtils.toFileId(id)) : this.deleteFile(FileIdUtils.toFolderId(id));
    }

    @Override
    public Call<? extends RemoteEntry> rename(RemoteEntry file, String newFilename) {
        if (file == null) {
            throw new IllegalArgumentException("RemoteEntry argument cannot be null.");
        }
        if (newFilename == null) {
            throw new IllegalArgumentException("New filename argument cannot be null.");
        }
        return file.isFolder() ? this.renameFolder(file.asFolder().folderId(), newFilename) : this.renameFile(file.asFile().fileId(), newFilename);
    }

    @Override
    public Call<? extends RemoteEntry> rename(String id, String newFilename) {
        if (id == null) {
            throw new IllegalArgumentException("File identifier argument cannot be null.");
        }
        return FileIdUtils.isFile(id) ? this.renameFile(FileIdUtils.toFileId(id), newFilename) : this.renameFolder(FileIdUtils.toFolderId(id), newFilename);
    }

    @Override
    public Call<RemoteFile> loadFile(long fileId) {
        HttpUrl.Builder urlBuilder = this.apiHost.newBuilder().addPathSegment("stat").addQueryParameter("fileid", String.valueOf(fileId));
        Request request = this.newRequest().url(urlBuilder.build()).get().build();
        return this.newCall(request, response -> this.getAsApiResponse(response, GetFileResponse.class).getFile());
    }

    @Override
    public Call<RemoteFile> loadFile(String path) {
        this.requireValidPath(path);
        HttpUrl.Builder urlBuilder = this.apiHost.newBuilder().addPathSegment("stat").addEncodedQueryParameter("path", String.valueOf(path));
        Request request = this.newRequest().url(urlBuilder.build()).get().build();
        return this.newCall(request, response -> this.getAsApiResponse(response, GetFileResponse.class).getFile());
    }

    @Override
    public Call<RemoteFolder> loadFolder(long folderId) {
        HttpUrl.Builder urlBuilder = this.apiHost.newBuilder().addPathSegment("listfolder").addQueryParameter("folderid", String.valueOf(folderId)).addQueryParameter("nofiles", String.valueOf(1));
        Request request = this.newRequest().url(urlBuilder.build()).get().build();
        return this.newCall(request, response -> this.getAsApiResponse(response, GetFolderResponse.class).getFolder());
    }

    @Override
    public Call<RemoteFolder> loadFolder(String path) {
        this.requireValidPath(path);
        HttpUrl.Builder urlBuilder = this.apiHost.newBuilder().addPathSegment("listfolder").addQueryParameter("path", path).addQueryParameter("nofiles", String.valueOf(1));
        Request request = this.newRequest().url(urlBuilder.build()).get().build();
        return this.newCall(request, response -> this.getAsApiResponse(response, GetFolderResponse.class).getFolder());
    }

    @Override
    public Call<RemoteFile> moveFile(long fileId, long toFolderId) {
        FormBody body = new FormBody.Builder().add("fileid", String.valueOf(fileId)).add("tofolderid", String.valueOf(toFolderId)).build();
        Request request = this.newRequest().url(this.apiHost.newBuilder().addPathSegment("renamefile").build()).post((RequestBody)body).build();
        return this.newCall(request, response -> this.getAsApiResponse(response, GetFileResponse.class).getFile());
    }

    @Override
    public Call<RemoteFile> moveFile(String path, String toPath) {
        this.requireValidPath(path, "path");
        this.requireValidPath(toPath, "toPath");
        FormBody body = new FormBody.Builder().addEncoded("path", path).addEncoded("topath", toPath).build();
        Request request = this.newRequest().url(this.apiHost.newBuilder().addPathSegment("renamefile").build()).post((RequestBody)body).build();
        return this.newCall(request, response -> this.getAsApiResponse(response, GetFileResponse.class).getFile());
    }

    @Override
    public Call<RemoteFile> moveFile(RemoteFile file, RemoteFolder toFolder) {
        if (file == null) {
            throw new IllegalArgumentException("file argument cannot be null.");
        }
        if (toFolder == null) {
            throw new IllegalArgumentException("toFolder argument cannot be null.");
        }
        return this.moveFile(file.fileId(), toFolder.folderId());
    }

    @Override
    public Call<RemoteFile> renameFile(long fileId, String newFilename) {
        if (newFilename == null) {
            throw new IllegalArgumentException("newFileName argument cannot be null.");
        }
        FormBody body = new FormBody.Builder().add("fileid", String.valueOf(fileId)).add("toname", newFilename).build();
        Request request = this.newRequest().url(this.apiHost.newBuilder().addPathSegment("renamefile").build()).post((RequestBody)body).build();
        return this.newCall(request, response -> this.getAsApiResponse(response, GetFileResponse.class).getFile());
    }

    @Override
    public Call<RemoteFile> renameFile(RemoteFile file, String newFilename) {
        if (file == null) {
            throw new IllegalArgumentException("file argument cannot be null.");
        }
        return this.renameFile(file.fileId(), newFilename);
    }

    @Override
    public Call<RemoteFolder> createFolder(RemoteFolder parentFolder, String folderName) {
        if (parentFolder == null) {
            throw new IllegalArgumentException("folder argument cannot be null.");
        }
        return this.createFolder(parentFolder.folderId(), folderName);
    }

    @Override
    public Call<RemoteFolder> createFolder(long parentFolderId, String folderName) {
        if (folderName == null) {
            throw new IllegalArgumentException("Folder name is null");
        }
        FormBody body = new FormBody.Builder().add("folderid", String.valueOf(parentFolderId)).add("name", folderName).build();
        Request request = this.newRequest().url(this.apiHost.newBuilder().addPathSegment("createfolder").build()).post((RequestBody)body).build();
        return this.newCall(request, response -> this.getAsApiResponse(response, GetFolderResponse.class).getFolder());
    }

    @Override
    public Call<RemoteFolder> createFolder(String path) {
        this.requireValidPath(path);
        FormBody body = new FormBody.Builder().addEncoded("path", path).build();
        Request request = this.newRequest().url(this.apiHost.newBuilder().addPathSegment("createfolder").build()).post((RequestBody)body).build();
        return this.newCall(request, response -> this.getAsApiResponse(response, GetFolderResponse.class).getFolder());
    }

    @Override
    public Call<Boolean> deleteFolder(RemoteFolder folder) {
        if (folder == null) {
            throw new IllegalArgumentException("folder argument cannot be null.");
        }
        return this.deleteFolder(folder.folderId(), false);
    }

    @Override
    public Call<Boolean> deleteFolder(RemoteFolder folder, boolean recursively) {
        if (folder == null) {
            throw new IllegalArgumentException("folder argument cannot be null.");
        }
        return this.deleteFolder(folder.folderId(), recursively);
    }

    @Override
    public Call<Boolean> deleteFolder(long folderId) {
        return this.deleteFolder(folderId, false);
    }

    @Override
    public Call<Boolean> deleteFolder(long folderId, boolean recursively) {
        FormBody body = new FormBody.Builder().add("folderid", String.valueOf(folderId)).build();
        Request request = this.newRequest().url(this.apiHost.newBuilder().addPathSegment(recursively ? "deletefolderrecursive" : "deletefolder").build()).post((RequestBody)body).build();
        return this.newCall(request, response -> {
            this.getAsApiResponse(response, ApiResponse.class);
            return true;
        });
    }

    @Override
    public Call<Boolean> deleteFolder(String path) {
        return this.deleteFolder(path, false);
    }

    @Override
    public Call<Boolean> deleteFolder(String path, boolean recursively) {
        this.requireValidPath(path);
        FormBody body = new FormBody.Builder().addEncoded("path", path).build();
        Request request = this.newRequest().url(this.apiHost.newBuilder().addPathSegment(recursively ? "deletefolderrecursive" : "deletefolder").build()).post((RequestBody)body).build();
        return this.newCall(request, response -> {
            this.getAsApiResponse(response, ApiResponse.class);
            return true;
        });
    }

    @Override
    public Call<RemoteFolder> renameFolder(RemoteFolder folder, String newFolderName) {
        if (folder == null) {
            throw new IllegalArgumentException("folder argument cannot be null.");
        }
        return this.renameFolder(folder.folderId(), newFolderName);
    }

    @Override
    public Call<RemoteFolder> renameFolder(long folderId, String newFolderName) {
        if (newFolderName == null) {
            throw new IllegalArgumentException("Folder name is null");
        }
        FormBody body = new FormBody.Builder().add("folderid", String.valueOf(folderId)).add("toname", newFolderName).build();
        Request request = this.newRequest().url(this.apiHost.newBuilder().addPathSegment("renamefolder").build()).post((RequestBody)body).build();
        return this.newCall(request, response -> this.getAsApiResponse(response, GetFolderResponse.class).getFolder());
    }

    @Override
    public Call<RemoteFolder> moveFolder(RemoteFolder folder, RemoteFolder toFolder) {
        if (folder == null || toFolder == null) {
            throw new IllegalArgumentException("folder argument cannot be null.");
        }
        return this.moveFolder(folder.folderId(), toFolder.folderId());
    }

    @Override
    public Call<RemoteFolder> moveFolder(long folderId, long toFolderId) {
        FormBody body = new FormBody.Builder().add("folderid", String.valueOf(folderId)).add("tofolderid", String.valueOf(toFolderId)).build();
        Request request = this.newRequest().url(this.apiHost.newBuilder().addPathSegment("renamefolder").build()).post((RequestBody)body).build();
        return this.newCall(request, response -> this.getAsApiResponse(response, GetFolderResponse.class).getFolder());
    }

    @Override
    public Call<RemoteFolder> moveFolder(String path, String toPath) {
        this.requireValidPath(path, "path");
        this.requireValidPath(toPath, "toPath");
        FormBody body = new FormBody.Builder().addEncoded("path", path).addEncoded("topath", toPath).build();
        Request request = this.newRequest().url(this.apiHost.newBuilder().addPathSegment("renamefolder").build()).post((RequestBody)body).build();
        return this.newCall(request, response -> this.getAsApiResponse(response, GetFolderResponse.class).getFolder());
    }

    @Override
    public Call<RemoteFolder> copyFolder(RemoteFolder folder, RemoteFolder toFolder) {
        if (folder == null || toFolder == null) {
            throw new IllegalArgumentException("folder argument cannot be null.");
        }
        return this.copyFolder(folder.folderId(), toFolder.folderId(), false);
    }

    @Override
    public Call<RemoteFolder> copyFolder(RemoteFolder folder, RemoteFolder toFolder, boolean overwrite) {
        if (folder == null || toFolder == null) {
            throw new IllegalArgumentException("folder argument cannot be null.");
        }
        return this.copyFolder(folder.folderId(), toFolder.folderId(), overwrite);
    }

    @Override
    public Call<RemoteFolder> copyFolder(long folderId, long toFolderId) {
        return this.copyFolder(folderId, toFolderId, false);
    }

    @Override
    public Call<RemoteFolder> copyFolder(long folderId, long toFolderId, boolean overwrite) {
        FormBody.Builder builder = new FormBody.Builder().add("folderid", String.valueOf(folderId)).add("tofolderid", String.valueOf(toFolderId));
        if (!overwrite) {
            builder.add("noover", String.valueOf(1));
            builder.add("skipexisting", String.valueOf(1));
        }
        Request request = this.newRequest().url(this.apiHost.newBuilder().addPathSegment("copyfolder").build()).post((RequestBody)builder.build()).build();
        return this.newCall(request, response -> this.getAsApiResponse(response, GetFolderResponse.class).getFolder());
    }

    @Override
    public Call<UserInfo> getUserInfo() {
        Request request = this.newRequest().url(this.apiHost.newBuilder().addPathSegment("userinfo").build()).get().build();
        return this.newCall(request, response -> {
            UserInfoResponse body = this.getAsApiResponse(response, UserInfoResponse.class);
            return new RealUserInfo(body.getUserId(), body.getEmail(), body.isEmailVerified(), body.getTotalQuota(), body.getUsedQuota());
        });
    }

    @Override
    public Call<Checksums> getChecksums(long fileId) {
        Request request = this.newRequest().url(this.apiHost.newBuilder().addPathSegment("checksumfile").addQueryParameter("fileid", String.valueOf(fileId)).build()).get().build();
        return this.newCall(request, response -> this.getAsApiResponse(response, ChecksumsResponse.class));
    }

    @Override
    public Call<Checksums> getChecksums(String filePath) {
        Request request = this.newRequest().url(this.apiHost.newBuilder().addPathSegment("checksumfile").addQueryParameter("path", String.valueOf(filePath)).build()).get().build();
        return this.newCall(request, response -> this.getAsApiResponse(response, ChecksumsResponse.class));
    }

    @Override
    public RealApiServiceBuilder newBuilder() {
        return new RealApiServiceBuilder(this.httpClient, this.callbackExecutor, this.progressCallbackThresholdBytes, this.authenticator, this.apiHost);
    }

    @Override
    public Executor callbackExecutor() {
        return this.callbackExecutor;
    }

    @Override
    public Dispatcher dispatcher() {
        return this.httpClient.dispatcher();
    }

    @Override
    public ConnectionPool connectionPool() {
        return this.httpClient.connectionPool();
    }

    @Override
    public Cache cache() {
        return this.httpClient.cache();
    }

    @Override
    public int readTimeoutMs() {
        return this.httpClient.readTimeoutMillis();
    }

    @Override
    public int writeTimeoutMs() {
        return this.httpClient.writeTimeoutMillis();
    }

    @Override
    public int connectTimeoutMs() {
        return this.httpClient.connectTimeoutMillis();
    }

    @Override
    public long progressCallbackThreshold() {
        return this.progressCallbackThresholdBytes;
    }

    @Override
    public Authenticator authenticator() {
        return this.authenticator;
    }

    @Override
    public String apiHost() {
        return this.apiHost.host();
    }

    @Override
    public void shutdown() {
        this.httpClient.connectionPool().evictAll();
        this.httpClient.dispatcher().executorService().shutdownNow();
        IOUtils.closeQuietly((Closeable)this.httpClient.cache());
    }

    private Request.Builder newRequest() {
        return new Request.Builder().url(this.apiHost);
    }

    private <T> Call<T> newCall(Request request, ResponseAdapter<T> adapter) {
        OkHttpCall<T> apiCall = new OkHttpCall<T>(this.httpClient.newCall(request), adapter);
        if (this.callbackExecutor != null) {
            return new ScheduledCall<T>(apiCall, this.callbackExecutor);
        }
        return apiCall;
    }

    private <T extends ApiResponse> T getAsApiResponse(Response response, Class<? extends T> bodyType) throws IOException, ApiError {
        ApiResponse body = (ApiResponse)this.deserializeResponseBody(response, bodyType);
        if (body == null) {
            throw new IOException("API returned an empty response body.");
        }
        if (body.isSuccessful()) {
            return (T)body;
        }
        throw new ApiError(body.getStatusCode(), body.getMessage());
    }

    /*
     * Loose catch block
     */
    private <T> T deserializeResponseBody(Response response, Class<? extends T> bodyType) throws IOException {
        try {
            Object object;
            if (!response.isSuccessful()) {
                throw new APIHttpException(response.code(), response.message());
            }
            JsonReader reader = new JsonReader((Reader)new BufferedReader(new InputStreamReader(Objects.requireNonNull(response.body()).byteStream())));
            try {
                object = this.gson.fromJson(reader, bodyType);
            }
            catch (JsonSyntaxException e) {
                throw new IOException("Malformed JSON response.", e);
            }
            finally {
                IOUtils.closeQuietly((Closeable)reader);
            }
            return (T)object;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            IOUtils.closeQuietly((Closeable)response);
        }
    }

    private Request newDownloadRequest(URL url) {
        return new Request.Builder().url(url).get().build();
    }

    private BufferedSource newDownloadCall(URL url) throws IOException {
        return this.newDownloadCall(this.newDownloadRequest(url));
    }

    private BufferedSource newDownloadCall(Request request) throws IOException {
        Response response = this.httpClient.newCall(request).execute();
        return this.getAsRawBytes(response);
    }

    private BufferedSource getAsRawBytes(Response response) throws APIHttpException {
        boolean callWasSuccessful = false;
        try {
            if (response.isSuccessful()) {
                callWasSuccessful = true;
                BufferedSource bufferedSource = Objects.requireNonNull(response.body()).source();
                return bufferedSource;
            }
            throw new APIHttpException(response.code(), response.message());
        }
        finally {
            if (!callWasSuccessful) {
                IOUtils.closeQuietly((Closeable)response);
            }
        }
    }

    private boolean isValidPath(String path) {
        return path != null && !path.isEmpty();
    }

    private void requireValidPath(String path) {
        this.requireValidPath(path, null);
    }

    private void requireValidPath(String path, String label) {
        if (!this.isValidPath(path)) {
            if (label != null && !label.isEmpty()) {
                throw new IllegalArgumentException("Path argument `" + label + "` cannot be null or empty.");
            }
            throw new IllegalArgumentException("Path argument cannot be null or empty.");
        }
    }
}

