/*
 * Decompiled with CFR 0.152.
 */
package com.pcloud.sdk.internal;

import com.pcloud.sdk.ProgressListener;
import java.io.IOException;
import okio.Buffer;
import okio.ForwardingSource;
import okio.Source;
import org.jetbrains.annotations.NotNull;

final class ProgressCountingSource
extends ForwardingSource {
    private long bytesReportedOnLastNotification;
    private final long notificationThresholdBytes;
    private final ProgressListener listener;
    private long totalBytesRead;
    private final long totalBytes;

    ProgressCountingSource(Source delegate, long totalBytes, ProgressListener listener, long notificationThresholdBytes) {
        super(delegate);
        this.totalBytes = totalBytes;
        this.notificationThresholdBytes = notificationThresholdBytes;
        this.listener = listener;
    }

    public long read(@NotNull Buffer sink, long byteCount) throws IOException {
        long bytesRead = super.read(sink, byteCount);
        this.totalBytesRead += bytesRead != -1L ? bytesRead : 0L;
        if (this.totalBytesRead - this.bytesReportedOnLastNotification >= this.notificationThresholdBytes) {
            this.listener.onProgress(this.totalBytesRead, this.totalBytes);
            this.bytesReportedOnLastNotification = this.totalBytesRead;
        }
        return bytesRead;
    }
}

