/*
 * Decompiled with CFR 0.152.
 */
package com.pcloud.sdk.internal;

import com.pcloud.sdk.ProgressListener;
import java.io.IOException;
import okio.Buffer;
import okio.ForwardingSink;
import okio.Sink;
import org.jetbrains.annotations.NotNull;

final class ProgressCountingSink
extends ForwardingSink {
    private long bytesReportedOnLastNotification;
    private final long notificationThresholdBytes;
    private final ProgressListener listener;
    private long totalBytesWritten;
    private final long totalBytes;

    ProgressCountingSink(Sink delegate, long totalBytes, ProgressListener listener, long notificationThresholdBytes) {
        super(delegate);
        this.totalBytes = totalBytes;
        this.notificationThresholdBytes = notificationThresholdBytes;
        this.listener = listener;
    }

    public void write(@NotNull Buffer source, long byteCount) throws IOException {
        super.write(source, byteCount);
        this.totalBytesWritten += byteCount;
        if (this.totalBytesWritten - this.bytesReportedOnLastNotification >= this.notificationThresholdBytes) {
            this.listener.onProgress(this.totalBytesWritten, this.totalBytes);
            this.bytesReportedOnLastNotification = this.totalBytesWritten;
        }
    }
}

