/*
 * Decompiled with CFR 0.152.
 */
package com.pcloud.sdk.internal;

import com.pcloud.sdk.ApiError;
import com.pcloud.sdk.Call;
import com.pcloud.sdk.Callback;
import com.pcloud.sdk.internal.IOUtils;
import com.pcloud.sdk.internal.ResponseAdapter;
import java.io.Closeable;
import java.io.IOException;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;

final class OkHttpCall<T>
implements Call<T> {
    private final okhttp3.Call rawCall;
    private final ResponseAdapter<T> responseAdapter;

    OkHttpCall(okhttp3.Call rawCall, ResponseAdapter<T> adapter) {
        this.rawCall = rawCall;
        this.responseAdapter = adapter;
    }

    @Override
    public T execute() throws IOException, ApiError {
        Response response = this.rawCall.execute();
        return this.adapt(response);
    }

    @Override
    public void enqueue(final Callback<T> callback) {
        if (callback == null) {
            throw new IllegalArgumentException("Callback argument cannot be null.");
        }
        this.rawCall.enqueue(new okhttp3.Callback(){

            public void onFailure(@NotNull okhttp3.Call call, @NotNull IOException e) {
                callback.onFailure(OkHttpCall.this, e);
            }

            public void onResponse(@NotNull okhttp3.Call call, @NotNull Response response) {
                try {
                    callback.onResponse(OkHttpCall.this, OkHttpCall.this.adapt(response));
                }
                catch (ApiError | IOException e) {
                    IOUtils.closeQuietly((Closeable)response);
                    callback.onFailure(OkHttpCall.this, e);
                }
            }
        });
    }

    @Override
    public boolean isExecuted() {
        return this.rawCall.isExecuted();
    }

    @Override
    public void cancel() {
        this.rawCall.cancel();
    }

    @Override
    public boolean isCanceled() {
        return this.rawCall.isCanceled();
    }

    @Override
    public OkHttpCall<T> clone() {
        return new OkHttpCall<T>(this.rawCall.clone(), this.responseAdapter);
    }

    okhttp3.Call rawCall() {
        return this.rawCall;
    }

    ResponseAdapter<T> responseAdapter() {
        return this.responseAdapter;
    }

    private T adapt(Response response) throws IOException, ApiError {
        return this.responseAdapter.adapt(response);
    }
}

