/*
 * Decompiled with CFR 0.152.
 */
package com.pcloud.sdk.internal;

import java.io.IOException;
import java.util.Map;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;

class GlobalRequestInterceptor
implements Interceptor {
    private final String userAgent;
    private final String cookieValues;

    GlobalRequestInterceptor(String userAgent, Map<String, String> globalParameters) {
        this.userAgent = userAgent;
        this.cookieValues = GlobalRequestInterceptor.buildCookieValue(globalParameters);
    }

    @NotNull
    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request newRequest = chain.request().newBuilder().header("User-Agent", this.userAgent).addHeader("Cookie", this.cookieValues).build();
        return chain.proceed(newRequest);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GlobalRequestInterceptor that = (GlobalRequestInterceptor)o;
        return this.cookieValues.equals(that.cookieValues);
    }

    public int hashCode() {
        return this.cookieValues.hashCode();
    }

    private static String buildCookieValue(Map<String, String> parameters) {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, String> keyValuePair : parameters.entrySet()) {
            builder.append(keyValuePair.getKey()).append('=').append(keyValuePair.getValue());
            builder.append("; ");
        }
        builder.append("Domain=api.pcloud.com; Path=/; Secure; HttpOnly");
        return builder.toString();
    }
}

