/*
 * Decompiled with CFR 0.152.
 */
package com.pcloud.sdk.internal;

import java.util.Locale;

class FileIdUtils {
    public static final char DIRECTORY_ID_PREFIX = 'd';
    public static final char FILE_ID_PREFIX = 'f';

    private FileIdUtils() {
    }

    public static void isFileOrThrow(String id) {
        if (FileIdUtils.isFolder(id)) {
            throw new IllegalArgumentException(String.format(Locale.US, "'%s' is not a file identifier.", id));
        }
    }

    public static void isFolderOrThrow(String id) {
        if (!FileIdUtils.isFolder(id)) {
            throw new IllegalArgumentException(String.format(Locale.US, "'%s' is not a file identifier.", id));
        }
    }

    public static long toFileId(String id) {
        FileIdUtils.isFileOrThrow(id);
        return Long.parseLong(id.substring(1));
    }

    public static long toFolderId(String id) {
        FileIdUtils.isFolderOrThrow(id);
        return Long.parseLong(id.substring(1));
    }

    public static boolean isFile(String id) {
        return !FileIdUtils.isFolder(id);
    }

    public static boolean isFolder(String id) {
        char prefix = id.charAt(0);
        switch (prefix) {
            case 'd': {
                return true;
            }
            case 'f': {
                return false;
            }
        }
        throw new IllegalArgumentException(String.format(Locale.US, "'%s' is not a valid pCloud file identifier.", id));
    }
}

