/*
 * Decompiled with CFR 0.152.
 */
package com.pcloud.sdk.internal;

import com.pcloud.sdk.ProgressListener;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;

class ExecutorProgressListener
implements ProgressListener,
Runnable {
    private final ProgressListener delegate;
    private final Executor executor;
    private volatile boolean pending;
    private volatile long done;
    private volatile long total;

    ExecutorProgressListener(ProgressListener delegate, Executor executor) {
        this.delegate = delegate;
        this.executor = executor;
    }

    @Override
    public void run() {
        this.delegate.onProgress(this.done, this.total);
        this.pending = false;
    }

    @Override
    public void onProgress(long done, long total) {
        if (!this.pending || done == total) {
            this.done = done;
            this.total = total;
            try {
                this.pending = true;
                this.executor.execute(this);
            }
            catch (RejectedExecutionException ignored) {
                this.pending = false;
            }
        }
    }
}

