/*
 * Decompiled with CFR 0.152.
 */
package com.pcloud.sdk.internal;

import com.pcloud.sdk.internal.RealAuthenticator;
import java.io.IOException;
import java.util.concurrent.Callable;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;

final class AccessTokenAuthenticator
extends RealAuthenticator {
    private final Callable<String> tokenProvider;

    AccessTokenAuthenticator(Callable<String> tokenProvider) {
        if (tokenProvider == null) {
            throw new IllegalArgumentException("'tokenProvider' argument cannot be null.");
        }
        this.tokenProvider = tokenProvider;
    }

    public Response intercept(@NotNull Interceptor.Chain chain) throws IOException {
        String accessToken;
        try {
            accessToken = this.tokenProvider.call();
        }
        catch (Exception e) {
            throw new IOException("Error while providing access token.", e);
        }
        Request request = accessToken != null ? this.setBearerTokenToRequest(chain.request(), accessToken) : chain.request();
        return chain.proceed(request);
    }

    private Request setBearerTokenToRequest(Request request, String accessToken) {
        if (accessToken != null) {
            return request.newBuilder().header("Authorization", "Bearer " + accessToken).build();
        }
        return request;
    }
}

